/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import com.dell.doradus.common.CommonDefs;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.parser.QueryFieldType;
import com.dell.doradus.search.query.AllQuery;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.DatePartBinaryQuery;
import com.dell.doradus.search.query.FieldCountQuery;
import com.dell.doradus.search.query.FieldCountRangeQuery;
import com.dell.doradus.search.query.IdQuery;
import com.dell.doradus.search.query.LinkCountQuery;
import com.dell.doradus.search.query.LinkCountRangeQuery;
import com.dell.doradus.search.query.LinkIdQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.MVSBinaryQuery;
import com.dell.doradus.search.query.NoneQuery;
import com.dell.doradus.search.query.NotQuery;
import com.dell.doradus.search.query.OrQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.RangeQuery;
import com.dell.doradus.search.query.TransitiveLinkQuery;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class QueryUtils {
    public static final SimpleDateFormat[] DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd HH"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM"), new SimpleDateFormat("yyyy")};
    public static final Map<String, Integer> TruncateUnits = new HashMap<String, Integer>(){
        {
            this.put("SECOND", new Integer(13));
            this.put("MINUTE", new Integer(12));
            this.put("HOUR", new Integer(11));
            this.put("DAY", new Integer(5));
            this.put("MONTH", new Integer(2));
            this.put("YEAR", new Integer(1));
        }
    };
    public static final Map<Integer, String> TruncateUnitsNames = new HashMap<Integer, String>(){
        {
            this.put(13, "SECOND");
            this.put(12, "MINUTE");
            this.put(11, "HOUR");
            this.put(5, "DAY");
            this.put(2, "MONTH");
            this.put(1, "YEAR");
        }
    };

    protected static String GetLinkQuantifier(Query q) {
        if (q instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)q;
            return lq.quantifier;
        }
        if (q instanceof TransitiveLinkQuery) {
            TransitiveLinkQuery lq = (TransitiveLinkQuery)q;
            return lq.quantifier;
        }
        return null;
    }

    protected static void SetLinkQuantifier(Query q, String val) {
        if (q instanceof LinkQuery || q instanceof TransitiveLinkQuery) {
            Query lq;
            if (q instanceof LinkQuery) {
                lq = (LinkQuery)q;
                lq.quantifier = val;
            }
            if (q instanceof TransitiveLinkQuery) {
                lq = (TransitiveLinkQuery)q;
                ((TransitiveLinkQuery)lq).quantifier = val;
            }
            return;
        }
        throw new IllegalArgumentException("Internal error: not a link type:" + q.getClass().getSimpleName());
    }

    protected static void SetLinkName(Query q, String val) {
        if (q instanceof LinkQuery || q instanceof TransitiveLinkQuery) {
            Query lq;
            if (q instanceof LinkQuery) {
                lq = (LinkQuery)q;
                lq.link = val;
            }
            if (q instanceof TransitiveLinkQuery) {
                lq = (TransitiveLinkQuery)q;
                ((TransitiveLinkQuery)lq).link = val;
            }
            return;
        }
        throw new IllegalArgumentException("Internal error: cannot set link name, query is not a link type:" + q.getClass().getSimpleName());
    }

    protected static Query GetLast(Query q) {
        while (q instanceof LinkQuery || q instanceof TransitiveLinkQuery) {
            Query lq;
            if (q instanceof LinkQuery) {
                lq = (LinkQuery)q;
                if (lq.innerQuery != null) {
                    q = lq.innerQuery;
                } else {
                    return q;
                }
            }
            if (!(q instanceof TransitiveLinkQuery)) continue;
            lq = (TransitiveLinkQuery)q;
            if (((TransitiveLinkQuery)lq).innerQuery != null) {
                q = ((TransitiveLinkQuery)lq).innerQuery;
                continue;
            }
            return lq;
        }
        return null;
    }

    protected static Query GetLastChild(Query q) {
        while (q instanceof LinkQuery || q instanceof TransitiveLinkQuery || q instanceof NotQuery) {
            Query lq;
            if (q instanceof LinkQuery) {
                lq = (LinkQuery)q;
                if (lq.innerQuery == null) {
                    return lq;
                }
                q = lq.innerQuery;
            }
            if (q instanceof TransitiveLinkQuery) {
                lq = (TransitiveLinkQuery)q;
                if (((TransitiveLinkQuery)lq).innerQuery == null) {
                    return lq;
                }
                q = ((TransitiveLinkQuery)lq).innerQuery;
            }
            if (!(q instanceof NotQuery)) continue;
            lq = (NotQuery)q;
            q = ((NotQuery)lq).innerQuery;
        }
        return q;
    }

    protected static Query GetInnerQuery(Query q, int index, TableDefinition tableDefinition) {
        ArrayList<String> path = new ArrayList<String>();
        int current = 0;
        if (q instanceof LinkQuery || q instanceof TransitiveLinkQuery || q instanceof NotQuery) {
            while (q instanceof LinkQuery || q instanceof TransitiveLinkQuery || q instanceof NotQuery) {
                Query lq;
                if (q instanceof LinkQuery) {
                    lq = (LinkQuery)q;
                    if (current == index) {
                        return lq;
                    }
                    ++current;
                    if (lq.innerQuery == null) {
                        throw new IllegalArgumentException("Internal Error: GetInnerQuery bad index " + index);
                    }
                    q = lq.innerQuery;
                }
                if (q instanceof TransitiveLinkQuery) {
                    lq = (TransitiveLinkQuery)q;
                    if (current == index) {
                        return lq;
                    }
                    ++current;
                    if (!QueryUtils.IsLink(path, tableDefinition)) {
                        throw new IllegalArgumentException("Internal Error: GetInnerQuery: " + ((TransitiveLinkQuery)lq).link + " is not a link");
                    }
                    if (((TransitiveLinkQuery)lq).innerQuery == null) {
                        throw new IllegalArgumentException("Internal Error: GetInnerQuery bad index " + index);
                    }
                    q = ((TransitiveLinkQuery)lq).innerQuery;
                }
                if (!(q instanceof NotQuery)) continue;
                lq = (NotQuery)q;
                q = ((NotQuery)lq).innerQuery;
            }
        }
        throw new IllegalArgumentException("Internal Error: GetInnerQuery index out of range" + index);
    }

    public static TableDefinition GetTableContext(Query q, TableDefinition definition) {
        TableDefinition tableDef = definition;
        ArrayList<String> path = QueryUtils.GetPath(q, tableDef);
        int i = 0;
        while (i < path.size()) {
            FieldDefinition fd = tableDef.getFieldDef(path.get(i));
            if (fd == null && i != path.size() - 1) {
                throw new IllegalArgumentException(" Undefined Link " + path.get(i));
            }
            if (tableDef.isLinkField(path.get(i)) || fd != null && fd.isXLinkField()) {
                if ((tableDef = tableDef.getLinkExtentTableDef(fd)) == null) {
                    throw new IllegalArgumentException(" Cannot get table definition for link " + path.get(i));
                }
            } else if (fd != null && fd.getType() == FieldType.GROUP) {
                ArrayList<String> nestedLinks = QueryUtils.GetNestedFields(fd);
                if (nestedLinks.size() == 0) {
                    throw new IllegalArgumentException("Group field error: " + fd.getName() + " (" + QueryUtils.LinkName(path) + ") Does not contain any links ");
                }
                fd = tableDef.getFieldDef(nestedLinks.get(0));
                if (fd != null) {
                    tableDef = tableDef.getLinkExtentTableDef(fd);
                }
            }
            ++i;
        }
        return tableDef;
    }

    public static ArrayList<FieldDefinition> GetNestedFieldDefinitions(FieldDefinition groupFieldDef) {
        ArrayList<FieldDefinition> result = new ArrayList<FieldDefinition>();
        if (groupFieldDef.isGroupField()) {
            for (FieldDefinition nestedFieldDef : groupFieldDef.getNestedFields()) {
                if (nestedFieldDef.isGroupField()) {
                    ArrayList<FieldDefinition> nested = QueryUtils.GetNestedFieldDefinitions(nestedFieldDef);
                    if (nested == null) continue;
                    result.addAll(nested);
                    continue;
                }
                result.add(nestedFieldDef);
            }
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    protected static ArrayList<String> GetPath(Query q, TableDefinition tableDefinition) {
        ArrayList<String> path = new ArrayList<String>();
        if (q instanceof LinkQuery || q instanceof TransitiveLinkQuery || q instanceof NotQuery) {
            while (q instanceof LinkQuery || q instanceof TransitiveLinkQuery || q instanceof NotQuery) {
                Query lq;
                if (q instanceof LinkQuery) {
                    lq = (LinkQuery)q;
                    path.add(lq.link);
                    if (lq.innerQuery == null) {
                        return path;
                    }
                    q = lq.innerQuery;
                }
                if (q instanceof TransitiveLinkQuery) {
                    lq = (TransitiveLinkQuery)q;
                    path.add(((TransitiveLinkQuery)lq).link);
                    if (((TransitiveLinkQuery)lq).innerQuery == null) {
                        return path;
                    }
                    q = ((TransitiveLinkQuery)lq).innerQuery;
                }
                if (!(q instanceof NotQuery)) continue;
                lq = (NotQuery)q;
                q = ((NotQuery)lq).innerQuery;
            }
        } else if (q instanceof BinaryQuery) {
            BinaryQuery bq = (BinaryQuery)q;
            if (bq.field != null) {
                path.add(bq.field);
            } else {
                path.add(bq.value);
            }
        }
        return path;
    }

    protected static Query MergeAND(Query first, Query second) {
        OrQuery or = new OrQuery();
        if (first instanceof OrQuery) {
            OrQuery f1 = (OrQuery)first;
            OrQuery s1 = (OrQuery)second;
            int i = 0;
            while (i < f1.subqueries.size()) {
                Query query = f1.subqueries.get(i);
                Query query2 = s1.subqueries.get(i);
                AndQuery and1 = new AndQuery();
                and1.subqueries.add(query);
                and1.subqueries.add(query2);
                or.subqueries.add(and1);
                ++i;
            }
            return or;
        }
        AndQuery and = new AndQuery();
        and.subqueries.add(first);
        and.subqueries.add(second);
        return and;
    }

    protected static Query GetParent(Query q, Query child) {
        while (q instanceof LinkQuery || q instanceof TransitiveLinkQuery || q instanceof NotQuery) {
            Query lq;
            if (q instanceof NotQuery) {
                NotQuery notQ = (NotQuery)q;
                if (notQ.innerQuery != null && notQ.innerQuery == child) {
                    return notQ;
                }
                q = ((NotQuery)q).innerQuery;
                continue;
            }
            if (q instanceof LinkQuery) {
                lq = (LinkQuery)q;
                if (lq.innerQuery != null) {
                    if (lq.innerQuery == child) {
                        return lq;
                    }
                    q = lq.innerQuery;
                } else {
                    return null;
                }
            }
            if (!(q instanceof TransitiveLinkQuery)) continue;
            lq = (TransitiveLinkQuery)q;
            if (((TransitiveLinkQuery)lq).innerQuery != null) {
                if (((TransitiveLinkQuery)lq).innerQuery == child) {
                    return lq;
                }
                q = ((TransitiveLinkQuery)lq).innerQuery;
                continue;
            }
            return null;
        }
        return null;
    }

    protected static boolean IsLink(ArrayList<String> path, TableDefinition tableDefinition) {
        TableDefinition tableDef = tableDefinition;
        int i = 0;
        while (i < path.size()) {
            ArrayList<FieldDefinition> result;
            if (tableDef == null) {
                return false;
            }
            FieldDefinition fd = tableDef.getFieldDef(path.get(i));
            if (fd == null) {
                return false;
            }
            if (fd.isGroupField() && (result = QueryUtils.GetNestedFieldDefinitions(fd)) != null) {
                fd = result.get(0);
            }
            if (!fd.isLinkField() && !fd.isXLinkField()) {
                return false;
            }
            tableDef = tableDef.getLinkExtentTableDef(fd);
            ++i;
        }
        return tableDef != null;
    }

    protected static void CheckPath(ArrayList<String> path, int depth, TableDefinition tableDefinition, boolean lastLink) {
        boolean lasttIsLink;
        TableDefinition tableDef = tableDefinition;
        if (tableDef == null) {
            return;
        }
        int i = 0;
        while (i < depth - 1) {
            String name = path.get(i);
            FieldDefinition fd = tableDef.getFieldDef(name);
            if (fd == null) {
                throw new IllegalArgumentException("Error: " + name + " is not a link");
            }
            if (tableDef.isLinkField(name) || fd.isXLinkField()) {
                if ((tableDef = tableDef.getLinkExtentTableDef(fd)) == null) {
                    throw new IllegalArgumentException("Error: table definition is not found for link " + name);
                }
            } else {
                throw new IllegalArgumentException("Error: " + name + " is not a link");
            }
            ++i;
        }
        String lname = path.get(depth);
        FieldDefinition fd = tableDef.getFieldDef(lname);
        boolean bl = lasttIsLink = tableDef.isLinkField(lname) || fd != null && fd.isXLinkField();
        if (lastLink) {
            if (!lasttIsLink) {
                throw new IllegalArgumentException("Error: " + lname + " is not a link");
            }
        } else if (lasttIsLink) {
            throw new IllegalArgumentException("Error: " + lname + " is a link");
        }
    }

    public static ArrayList<String> GetNestedFields(FieldDefinition groupFieldDef) {
        ArrayList<String> result = new ArrayList<String>();
        for (FieldDefinition nestedFieldDef : groupFieldDef.getNestedFields()) {
            if (nestedFieldDef.isGroupField()) {
                result.addAll(QueryUtils.GetNestedFields(nestedFieldDef));
                continue;
            }
            result.add(nestedFieldDef.getName());
        }
        return result;
    }

    protected static FieldDefinition GetField(ArrayList<String> path, TableDefinition tableDefinition) {
        return QueryUtils.GetField(path, path.size() - 1, tableDefinition);
    }

    protected static FieldDefinition GetField(ArrayList<String> path, int index, TableDefinition tableDefinition) {
        if (tableDefinition == null) {
            return null;
        }
        FieldDefinition fd = null;
        TableDefinition tableDef = tableDefinition;
        int current = 0;
        while (tableDef != null) {
            fd = tableDef.getFieldDef(path.get(current));
            if (tableDef.isLinkField(path.get(current)) || fd != null && fd.isXLinkField()) {
                if (fd == null) {
                    return null;
                }
                tableDef = tableDef.getLinkExtentTableDef(fd);
            }
            if (current == index) {
                return fd;
            }
            if (fd != null && fd.isGroupField()) {
                ArrayList<String> nested = QueryUtils.GetNestedFields(fd);
                fd = tableDef.getFieldDef(nested.get(0));
                if (tableDef.isLinkField(nested.get(0)) || fd != null && fd.isXLinkField()) {
                    tableDef = tableDef.getLinkExtentTableDef(fd);
                }
            }
            ++current;
        }
        return null;
    }

    protected static TableDefinition GetTableDefinition(ArrayList<String> path, TableDefinition tableDefinition) {
        return QueryUtils.GetTableDefinition(path, path.size(), tableDefinition);
    }

    protected static TableDefinition GetTableDefinition(ArrayList<String> path, int index, TableDefinition tableDefinition) {
        if (tableDefinition == null) {
            return null;
        }
        FieldDefinition fd = null;
        TableDefinition tableDef = tableDefinition;
        int i = 0;
        while (i < index) {
            if (tableDef == null) {
                return null;
            }
            fd = tableDef.getFieldDef(path.get(i));
            if (tableDef.isLinkField(path.get(i)) || fd != null && fd.isXLinkField()) {
                if (fd == null) {
                    return null;
                }
                tableDef = tableDef.getLinkExtentTableDef(fd);
            } else if (fd != null && fd.isGroupField()) {
                ArrayList<String> nested = QueryUtils.GetNestedFields(fd);
                fd = tableDef.getFieldDef(nested.get(0));
                if (tableDef.isLinkField(nested.get(0)) || fd != null && fd.isXLinkField()) {
                    tableDef = tableDef.getLinkExtentTableDef(fd);
                } else {
                    return tableDef;
                }
            }
            ++i;
        }
        return tableDef;
    }

    protected static QueryFieldType GetFieldType(ArrayList<String> path, TableDefinition tableDefinition) {
        return QueryUtils.GetFieldType(path, path.size() - 1, tableDefinition);
    }

    protected static QueryFieldType GetFieldType(ArrayList<String> path, int index, TableDefinition tableDefinition) {
        FieldDefinition fd = QueryUtils.GetField(path, index, tableDefinition);
        return QueryUtils.GetQueryFieldType(fd);
    }

    protected static QueryFieldType GetBasicFieldType(ArrayList<String> path, TableDefinition tableDefinition) {
        return QueryUtils.GetBasicFieldType(path, path.size() - 1, tableDefinition);
    }

    protected static QueryFieldType GetBasicFieldType(ArrayList<String> path, int index, TableDefinition tableDefinition) {
        FieldDefinition fd = QueryUtils.GetField(path, index, tableDefinition);
        if (fd != null) {
            return QueryUtils.GetBasicQueryFieldType(fd);
        }
        return QueryFieldType.Unknown;
    }

    public static QueryFieldType GetBasicQueryFieldType(FieldDefinition groupFieldDef) {
        ArrayList<FieldDefinition> result = QueryUtils.GetNestedFieldDefinitions(groupFieldDef);
        if (result != null) {
            return QueryUtils.GetQueryFieldType(result.get(0));
        }
        return QueryUtils.GetQueryFieldType(groupFieldDef);
    }

    private static QueryFieldType GetQueryFieldType(FieldDefinition fd) {
        if (fd == null) {
            return QueryFieldType.Unknown;
        }
        if (fd.isGroupField()) {
            return QueryFieldType.Group;
        }
        if (fd.isLinkField()) {
            return QueryFieldType.Link;
        }
        if (fd.isXLinkField()) {
            return QueryFieldType.Link;
        }
        if (fd.isCollection()) {
            return QueryFieldType.MultiValueScalar;
        }
        if (fd.isScalarField()) {
            return QueryFieldType.Field;
        }
        return QueryFieldType.Unknown;
    }

    protected static String GetLinkQueryLink(Query q) {
        if (q instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)q;
            return lq.link;
        }
        if (q instanceof TransitiveLinkQuery) {
            TransitiveLinkQuery lq = (TransitiveLinkQuery)q;
            return lq.link;
        }
        return null;
    }

    protected static boolean HasInnerQuery(Query q) {
        if (q instanceof LinkQuery || q instanceof TransitiveLinkQuery || q instanceof NotQuery) {
            if (q instanceof LinkQuery) {
                LinkQuery lq = (LinkQuery)q;
                return lq.innerQuery != null;
            }
            if (q instanceof TransitiveLinkQuery) {
                TransitiveLinkQuery lq = (TransitiveLinkQuery)q;
                return lq.innerQuery != null;
            }
            if (q instanceof NotQuery) {
                return true;
            }
        }
        return false;
    }

    protected static Query GetInnerQuery(Query q) {
        if (q instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)q;
            return lq.innerQuery;
        }
        if (q instanceof TransitiveLinkQuery) {
            TransitiveLinkQuery lq = (TransitiveLinkQuery)q;
            return lq.innerQuery;
        }
        return null;
    }

    static void SetInnerQuery(Query q, Query value) {
        if (q instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)q;
            lq.innerQuery = value;
            return;
        }
        if (q instanceof TransitiveLinkQuery) {
            TransitiveLinkQuery lq = (TransitiveLinkQuery)q;
            lq.innerQuery = value;
            return;
        }
        if (q instanceof NotQuery) {
            NotQuery lq = (NotQuery)q;
            lq.innerQuery = value;
            return;
        }
        throw new IllegalArgumentException(" Internal error 2");
    }

    public static Query CloneQuery(Query q) {
        if (q == null) {
            return null;
        }
        CloneAction z = CloneAction.valueOf(q.getClass().getSimpleName());
        return z.Clone(q);
    }

    static String FullLinkName(List<AggregationGroupItem> items) {
        return QueryUtils.FullLinkName(items, items.size());
    }

    static String FullLinkName(List<AggregationGroupItem> items, int len) {
        StringBuilder builder = new StringBuilder();
        String delimiter = "";
        int i = 0;
        while (i < len) {
            builder.append(delimiter);
            builder.append(items.get((int)i).name);
            delimiter = ".";
            ++i;
        }
        return builder.toString();
    }

    static String LinkName(List<String> items) {
        StringBuilder builder = new StringBuilder();
        String delimiter = "";
        int i = 0;
        while (i < items.size()) {
            builder.append(delimiter);
            builder.append(items.get(i));
            delimiter = ".";
            ++i;
        }
        return builder.toString();
    }

    public static ArrayList<String> GetLinkPath(Stack<String> links) {
        ArrayList<String> path = new ArrayList<String>();
        int i = 0;
        while (i < links.size()) {
            path.add((String)links.get(i));
            ++i;
        }
        return path;
    }

    protected static String GetFieldName(Query q) {
        if (q instanceof BinaryQuery) {
            return ((BinaryQuery)q).field;
        }
        if (q instanceof IdQuery) {
            return CommonDefs.SystemFields._ID.toString();
        }
        if (q instanceof LinkCountRangeQuery) {
            return ((LinkCountRangeQuery)q).link;
        }
        if (q instanceof LinkCountQuery) {
            return ((LinkCountQuery)q).link;
        }
        if (q instanceof LinkIdQuery) {
            return ((LinkIdQuery)q).link;
        }
        if (q instanceof LinkQuery) {
            return ((LinkQuery)q).link;
        }
        if (q instanceof MVSBinaryQuery) {
            return ((MVSBinaryQuery)q).quantifier;
        }
        if (q instanceof RangeQuery) {
            return ((RangeQuery)q).field;
        }
        if (q instanceof TransitiveLinkQuery) {
            return ((TransitiveLinkQuery)q).link;
        }
        return null;
    }

    public static boolean isSystemField(String name) {
        if (name != null) {
            return CommonDefs.SystemFields._ID.toString().equals(name);
        }
        return false;
    }

    public static enum CloneAction {
        AllQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                return new AllQuery();
            }
        }
        ,
        AndQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                AndQuery andQuery = (AndQuery)q;
                AndQuery aq = new AndQuery();
                int i = 0;
                while (i < andQuery.subqueries.size()) {
                    aq.subqueries.add(QueryUtils.CloneQuery(andQuery.subqueries.get(i)));
                    ++i;
                }
                return aq;
            }
        }
        ,
        BinaryQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                BinaryQuery binaryQuery = (BinaryQuery)q;
                return new BinaryQuery(binaryQuery.operation, binaryQuery.field, binaryQuery.value);
            }
        }
        ,
        DatePartBinaryQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                DatePartBinaryQuery linkQuery = (DatePartBinaryQuery)q;
                return new DatePartBinaryQuery(linkQuery.part, (BinaryQuery)QueryUtils.CloneQuery(linkQuery.innerQuery));
            }
        }
        ,
        IdQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                return new IdQuery(((IdQuery)q).id);
            }
        }
        ,
        LinkCountRangeQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                LinkCountRangeQuery linkQuery = (LinkCountRangeQuery)q;
                LinkCountRangeQuery lc = new LinkCountRangeQuery(linkQuery.link, (RangeQuery)QueryUtils.CloneQuery(linkQuery.range));
                if (linkQuery.filter != null) {
                    // empty if block
                }
                lc.filter = QueryUtils.CloneQuery(linkQuery.filter);
                return lc;
            }
        }
        ,
        LinkCountQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                LinkCountQuery linkQuery = (LinkCountQuery)q;
                LinkCountQuery lc = new LinkCountQuery(linkQuery.link, linkQuery.count);
                if (linkQuery.filter != null) {
                    // empty if block
                }
                lc.filter = QueryUtils.CloneQuery(linkQuery.filter);
                return lc;
            }
        }
        ,
        FieldCountRangeQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                FieldCountRangeQuery fcrq = (FieldCountRangeQuery)q;
                FieldCountRangeQuery lc = new FieldCountRangeQuery(fcrq.field, (RangeQuery)QueryUtils.CloneQuery(fcrq.range));
                return lc;
            }
        }
        ,
        FieldCountQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                FieldCountQuery fcq = (FieldCountQuery)q;
                FieldCountQuery lc = new FieldCountQuery(fcq.field, fcq.count);
                return lc;
            }
        }
        ,
        LinkIdQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                LinkIdQuery linkQuery = (LinkIdQuery)q;
                return new LinkIdQuery(linkQuery.quantifier, linkQuery.link, linkQuery.id);
            }
        }
        ,
        LinkQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                LinkQuery linkQuery = (LinkQuery)q;
                LinkQuery lq = new LinkQuery(linkQuery.quantifier, linkQuery.link, null);
                lq.innerQuery = QueryUtils.CloneQuery(linkQuery.innerQuery);
                if (linkQuery.filter != null) {
                    // empty if block
                }
                lq.filter = QueryUtils.CloneQuery(linkQuery.filter);
                return lq;
            }
        }
        ,
        MVSBinaryQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                MVSBinaryQuery mvsQuery = (MVSBinaryQuery)q;
                return new MVSBinaryQuery(mvsQuery.quantifier, (BinaryQuery)QueryUtils.CloneQuery(mvsQuery.innerQuery));
            }
        }
        ,
        NoneQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                return new NoneQuery();
            }
        }
        ,
        NotQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                NotQuery notQuery = (NotQuery)q;
                NotQuery nq = new NotQuery();
                nq.innerQuery = QueryUtils.CloneQuery(notQuery.innerQuery);
                return nq;
            }
        }
        ,
        OrQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                OrQuery orQuery = (OrQuery)q;
                OrQuery oq = new OrQuery();
                int i = 0;
                while (i < orQuery.subqueries.size()) {
                    oq.subqueries.add(QueryUtils.CloneQuery(orQuery.subqueries.get(i)));
                    ++i;
                }
                return oq;
            }
        }
        ,
        RangeQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                RangeQuery orQuery = (RangeQuery)q;
                return new RangeQuery(orQuery.field, orQuery.min, orQuery.minInclusive, orQuery.max, orQuery.maxInclusive);
            }
        }
        ,
        TransitiveLinkQuery{

            @Override
            Query Clone(Query q) {
                if (q == null) {
                    return null;
                }
                TransitiveLinkQuery orQuery = (TransitiveLinkQuery)q;
                TransitiveLinkQuery lc = new TransitiveLinkQuery(orQuery.quantifier, orQuery.depth, orQuery.link, QueryUtils.CloneQuery(orQuery.innerQuery));
                if (orQuery.filter != null) {
                    // empty if block
                }
                lc.filter = QueryUtils.CloneQuery(orQuery.filter);
                return lc;
            }
        };


        abstract Query Clone(Query var1);
    }
}

