/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.parser.QueryTreeVisitor;
import com.dell.doradus.search.parser.QueryUtils;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.IdQuery;
import com.dell.doradus.search.query.LinkIdQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.TransitiveLinkQuery;
import java.util.ArrayList;
import java.util.Stack;

class LinkCheckVisitor
implements QueryTreeVisitor {
    TableDefinition tableDefinition;

    public LinkCheckVisitor(TableDefinition tableDef) {
        this.tableDefinition = tableDef;
    }

    @Override
    public Query visit(Stack<String> links, Query query) {
        ArrayList<Object> path;
        if (query instanceof BinaryQuery) {
            BinaryQuery bq = (BinaryQuery)query;
            if (bq.field != null) {
                if (bq.field.equals("_ID")) {
                    if (bq.operation.equals(BinaryQuery.CONTAINS)) {
                        throw new IllegalArgumentException("Operation ':' is not supported for _ID field");
                    }
                    IdQuery id = new IdQuery(bq.value);
                    return id;
                }
                if (BinaryQuery.EQUALS.equals(bq.operation) && this.tableDefinition != null) {
                    if (!links.empty()) {
                        path = QueryUtils.GetLinkPath(links);
                        path.add(bq.field);
                        if (QueryUtils.IsLink(path, this.tableDefinition)) {
                            LinkIdQuery li = new LinkIdQuery(LinkQuery.ANY, bq.field, bq.value);
                            return li;
                        }
                    } else {
                        FieldDefinition fd = this.tableDefinition.getFieldDef(bq.field);
                        if (this.tableDefinition.isLinkField(bq.field) || fd != null && fd.isXLinkField()) {
                            LinkIdQuery li = new LinkIdQuery(LinkQuery.ANY, bq.field, bq.value);
                            return li;
                        }
                    }
                }
            }
        }
        if ((query instanceof LinkQuery || query instanceof TransitiveLinkQuery) && this.tableDefinition != null) {
            ArrayList<Object> path2 = new ArrayList();
            if (!links.empty()) {
                path2 = QueryUtils.GetLinkPath(links);
            }
            String linkName = "";
            linkName = query instanceof LinkQuery ? ((LinkQuery)query).link : ((TransitiveLinkQuery)query).link;
            path2.add(linkName);
            switch (QueryUtils.GetFieldType(path2, this.tableDefinition)) {
                case Link: {
                    break;
                }
                case Group: {
                    FieldDefinition groupfield = QueryUtils.GetField(path2, this.tableDefinition);
                    ArrayList<String> nestedLinks = QueryUtils.GetNestedFields(groupfield);
                    if (nestedLinks.size() != 0) break;
                    throw new IllegalArgumentException("Group field error: " + groupfield.getName() + " (" + QueryUtils.LinkName(path2) + ") Does not contain any links ");
                }
                default: {
                    throw new IllegalArgumentException("Error: " + linkName + " (" + QueryUtils.LinkName(path2) + ") is not a link");
                }
            }
        }
        if (query instanceof LinkIdQuery && this.tableDefinition != null) {
            LinkIdQuery q = (LinkIdQuery)query;
            path = new ArrayList<String>();
            if (!links.empty()) {
                path = QueryUtils.GetLinkPath(links);
            }
            path.add(q.link);
            if (!QueryUtils.IsLink(path, this.tableDefinition)) {
                BinaryQuery bq = new BinaryQuery(BinaryQuery.EQUALS, q.link, q.id);
                return bq;
            }
        }
        return query;
    }
}

