/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import com.dell.doradus.common.CommonDefs;
import com.dell.doradus.search.parser.DoradusQueryBuilder;
import com.dell.doradus.search.parser.FieldSetItem;
import com.dell.doradus.search.parser.grammar.GrammarItem;
import java.util.ArrayList;
import java.util.Stack;

public class FieldSetQueryBuilder {
    public static FieldSetItem BuildFieldSet(String text) {
        ArrayList<GrammarItem> items = DoradusQueryBuilder.ParseFieldSet(text);
        FieldSetItem parent = new FieldSetItem("root");
        Stack<FieldSetItem> stack = new Stack<FieldSetItem>();
        stack.push(parent);
        int i = 0;
        while (i < items.size()) {
            GrammarItem item = items.get(i);
            if (!item.getType().equals("WhiteSpaces") && !item.getType().equals("semantic")) {
                if (item.getType().equals("COMMA")) {
                    parent = (FieldSetItem)stack.peek();
                } else if (item.getType().equals("LEFTPAREN")) {
                    stack.push(parent);
                } else if (!item.getType().equals("DOT")) {
                    if (item.getType().equals("RIGHTPAREN")) {
                        parent = (FieldSetItem)stack.pop();
                    } else if (!item.getType().equals("BRACKET")) {
                        if (item.getType().equals("LIMIT")) {
                            try {
                                parent.limit = Integer.parseInt(item.getValue());
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Cannot parse integer value " + item.getValue(), e);
                            }
                        }
                        if (item.getType().equals("ALIAS_NAME")) {
                            parent.alias = item.getValue();
                        } else if (item.getValue().equals("WHERE")) {
                            GrammarItem grammarItem;
                            ArrayList<GrammarItem> subList = new ArrayList<GrammarItem>();
                            if (parent.grammarItems == null) {
                                parent.grammarItems = new ArrayList();
                            }
                            parent.grammarItems.add(subList);
                            while (!(grammarItem = items.get(++i)).getValue().equals("ENDWHERE")) {
                                subList.add(grammarItem);
                            }
                        } else {
                            FieldSetItem next;
                            String fieldName = item.getValue();
                            if (fieldName != null && fieldName.startsWith("_")) {
                                try {
                                    CommonDefs.SystemFields.valueOf((String)fieldName);
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException("Unknown system field " + fieldName);
                                }
                            }
                            if ((next = FieldSetQueryBuilder.GetChild(parent, fieldName)) == null) {
                                next = new FieldSetItem(fieldName);
                            }
                            parent.children.add(next);
                            parent = next;
                        }
                    }
                }
            }
            ++i;
        }
        parent = (FieldSetItem)stack.pop();
        return parent;
    }

    public static FieldSetItem GetChild(FieldSetItem parent, String value) {
        return null;
    }
}

