/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import com.dell.doradus.search.parser.grammar.CharacterRule;
import com.dell.doradus.search.parser.grammar.Context;
import com.dell.doradus.search.parser.grammar.Grammar;
import com.dell.doradus.search.parser.grammar.GrammarItem;
import com.dell.doradus.search.parser.grammar.GrammarRule;
import com.dell.doradus.search.parser.grammar.GrammarToken;
import com.dell.doradus.search.parser.grammar.Keyword;
import com.dell.doradus.search.parser.grammar.ListRule;
import com.dell.doradus.search.parser.grammar.Semantic;
import com.dell.doradus.search.parser.grammar.SequenceRule;
import com.dell.doradus.search.parser.grammar.StringToken;
import com.dell.doradus.search.parser.grammar.SwitchRule;
import com.dell.doradus.search.parser.grammar.Token;
import java.util.ArrayList;
import java.util.Hashtable;

public class DoradusSearchQueryGrammar {
    public static String SearchQueryGrammar = "SearchQuery";
    public static String AggregationQueryGrammar = "AggregationGroup";
    public static String AggregationMetricGrammar = "AggregationMetric";
    public static String StatisticMetricGrammar = "StatisticMetric";
    public static String StatisticQueryGrammar = "StatisticQuery";
    public static String StatisticParameterGrammar = "StatisticParameter";
    public static String FieldSetGrammar = "FieldSetGrammar";
    public static String SortOrderGrammar = "SortOrderGrammar";
    public static String SkipWhitespace = "SkipWhitespaces";
    public static String SkipWhitespaceOptionRule = "SkipWhitespaceRule";
    public static String NotSkipWhitespaceOptionRule = "NotSkipWhitespaceRule";
    private static Hashtable<String, GrammarRule> grammars;

    public static GrammarRule GetGrammar(String name) {
        if (grammars == null) {
            grammars = DoradusSearchQueryGrammar.getGrammar();
        }
        return grammars.get(name);
    }

    public static GrammarRule GetGrammar() {
        return DoradusSearchQueryGrammar.GetGrammar(SearchQueryGrammar);
    }

    /*
     * WARNING - void declaration
     */
    private static Hashtable<String, GrammarRule> getGrammar() {
        void SortOrder2;
        void StatisticParameter;
        void result;
        void SortOrderContinue;
        void ASC;
        void DESC;
        void FieldSetContinue;
        void FieldOrLinkNameContinue;
        void OptionalWhereAndLimit;
        void OptionalLimit;
        void OptionalWhereClause1;
        void optionalWhereBodyList;
        void OptionalAlias;
        void FieldOrLinkNameNext;
        void FieldSet2;
        void FieldOrLinkName;
        void StatisticParameterContinue;
        void StatisticRangeExpression;
        void StatisticParameterValue;
        void AggregationMetricQueryListContinue;
        void AggregationMetricQueryList;
        void AggregationMetricQueryTerm;
        void AggregationMetricExpressionContinue;
        void OptionalMetricAlias;
        void AggregationMetricQuery;
        void AggregationMetricExpression;
        void ArithmeticOperation;
        void DOUBLENUMBER;
        void AggregationMetricFunctionQuery;
        void DateDiffFunction;
        void AggregationMetricCountStarQuery;
        void DoubleNumberLiteral;
        void SignNumberContinue;
        void WhereStar;
        void DateDiffParameters;
        void DateDiffParameterValue;
        void MetricFunctionBinary;
        Semantic processEscape = new Semantic("processEscape"){

            @Override
            public Context Match(Context context) {
                GrammarItem item = context.items.get(context.items.size() - 1);
                char c = (char)Integer.parseInt(item.getValue().substring(2), 16);
                item.setValue("" + c);
                return context;
            }
        };
        Semantic processEscapeChar = new Semantic("processEscapeChar"){

            @Override
            public Context Match(Context context) {
                GrammarItem item = context.items.get(context.items.size() - 1);
                char c = item.getValue().charAt(1);
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case '\f': {
                        c = '\f';
                        break;
                    }
                    case '\'': {
                        c = '\'';
                        break;
                    }
                    case '\"': {
                        c = '\"';
                    }
                }
                item.setValue("" + c);
                return context;
            }
        };
        Semantic RemoveQuotes = new Semantic("RemoveQuotes"){

            @Override
            public Context Match(Context context) {
                GrammarItem item = context.items.get(context.items.size() - 1);
                String newValue = item.getValue().substring(1, item.getValue().length() - 1);
                item.setValue(newValue);
                return context;
            }
        };
        GrammarToken PLUS = new GrammarToken("+");
        GrammarToken MINUS = new GrammarToken("-");
        GrammarToken COLON = new GrammarToken(":");
        GrammarToken STAR = new GrammarToken("*");
        GrammarToken DIVIDE = new GrammarToken("/");
        GrammarToken LEFTPAREN = new GrammarToken("(");
        GrammarToken RIGHTPAREN = new GrammarToken(")");
        GrammarToken LEFTBRACKET = new GrammarToken("[");
        GrammarToken RIGHTBRACKET = new GrammarToken("]");
        GrammarToken LEFTBRACE = new GrammarToken("{");
        GrammarToken RIGHTBRACE = new GrammarToken("}");
        GrammarToken TO = new GrammarToken("TO");
        GrammarToken LESS = new GrammarToken("<");
        GrammarToken LESSEQUAL = new GrammarToken("<=");
        GrammarToken EQUAL = new GrammarToken("=");
        GrammarToken GREATER = new GrammarToken(">");
        GrammarToken GREATEREQUAL = new GrammarToken(">=");
        GrammarToken COMMA = new GrammarToken(",");
        GrammarToken TRANSITIVE = new GrammarToken("^");
        GrammarToken DOT = new GrammarToken(".");
        GrammarToken ESCAPE = new GrammarToken("\\");
        GrammarToken ESCAPEU = new GrammarToken("u");
        GrammarToken UNDERSCORE = new GrammarToken("_");
        GrammarToken QUESTION = new GrammarToken("?");
        GrammarToken FETCH = new GrammarToken("@");
        GrammarToken DIES = new GrammarToken("#");
        GrammarToken IN = new GrammarToken("IN");
        GrammarToken LOWER = new GrammarToken("LOWER");
        GrammarToken UPPER = new GrammarToken("UPPER");
        GrammarToken SLASH = new GrammarToken("/");
        SwitchRule ReservedEscapeCharacter = new SwitchRule("ReservedEscapeCharacter", new GrammarToken("t"), new GrammarToken("b"), new GrammarToken("n"), new GrammarToken("r"), new GrammarToken("f"), new GrammarToken("'"), new GrammarToken("\""), new GrammarToken("\\"));
        Token UnicodeCharacter = new Token(Grammar.Rule("UnicodeCharacter", ESCAPE, ESCAPEU, Grammar.HexDigit, Grammar.HexDigit, Grammar.HexDigit, Grammar.HexDigit));
        SwitchRule EscapeSequence = new SwitchRule(SwitchRule.First, "EscapeSequence", Grammar.Rule(UnicodeCharacter, processEscape), Grammar.Rule(new Token(Grammar.Rule("esc", ESCAPE, ReservedEscapeCharacter)), processEscapeChar));
        GrammarToken SINGLEQUOTE = new GrammarToken("'");
        GrammarToken DOUBLEQUOTE = new GrammarToken("\"");
        SwitchRule SingleQuoteStringCharacters = new SwitchRule("SingleQuoteStringCharacters", new GrammarRule[0]);
        SingleQuoteStringCharacters.setMode(SwitchRule.First);
        SingleQuoteStringCharacters.body = Grammar.asRule(Grammar.Rule(EscapeSequence, Grammar.MustMatchAction, SingleQuoteStringCharacters), Grammar.Rule(Grammar.ExceptChar('\''), SingleQuoteStringCharacters), Grammar.emptyRule);
        SwitchRule DoubleQuoteStringCharacters = new SwitchRule("DoubleQuoteStringCharacters", new GrammarRule[0]);
        DoubleQuoteStringCharacters.body = Grammar.asRule(Grammar.Rule(EscapeSequence, DoubleQuoteStringCharacters), Grammar.Rule(Grammar.ExceptChar('\"'), DoubleQuoteStringCharacters), Grammar.emptyRule);
        GrammarRule SingleQuotedString = Grammar.Rule("SingleQuotedString", new Token(Grammar.Rule(SINGLEQUOTE, SingleQuoteStringCharacters, SINGLEQUOTE)), RemoveQuotes);
        GrammarRule DoubleQuotedString = Grammar.Rule("DoubleQuotedString", new Token(Grammar.Rule(DOUBLEQUOTE, DoubleQuoteStringCharacters, DOUBLEQUOTE)), RemoveQuotes);
        boolean optimizeStringLiterals = true;
        if (optimizeStringLiterals) {
            DoubleQuotedString = new StringToken("DStringToken", '\"');
            SingleQuotedString = new StringToken("SStringToken", '\'');
        }
        SwitchRule FieldNameLiteralStart = new SwitchRule(SwitchRule.First, "FieldNameLiteralStart", Grammar.Letter, Grammar.Digit, MINUS, STAR, UNDERSCORE, QUESTION, FETCH, DIES);
        SwitchRule FieldNameLiteralMiddle = new SwitchRule("FieldNameLiteralMiddle", FieldNameLiteralStart, MINUS);
        SwitchRule LiteralStart = new SwitchRule(SwitchRule.First, "LiteralStart", FieldNameLiteralStart, EscapeSequence);
        SwitchRule LiteralMiddle = new SwitchRule("LiteralMiddle", LiteralStart, MINUS);
        SwitchRule LiteralContinue = new SwitchRule("LiteralContinue", new GrammarRule[0]);
        LiteralContinue.optionalMode = true;
        LiteralContinue.body = Grammar.asRule(Grammar.Rule(LiteralMiddle, LiteralContinue), Grammar.emptyRule);
        SwitchRule TimeZoneCharacter = new SwitchRule(SwitchRule.First, "TimeZoneCharacter", LiteralMiddle, PLUS, SLASH);
        SequenceRule TimeZoneLiteral = new SequenceRule("TimeZoneLiteral", new GrammarRule[0]);
        SwitchRule TimeZoneLiteralContinue = new SwitchRule("TimeZoneLiteralContinue", Grammar.Rule(TimeZoneCharacter, TimeZoneLiteral), Grammar.emptyRule);
        TimeZoneLiteral.body = Grammar.asRule(TimeZoneCharacter, TimeZoneLiteralContinue);
        Token TimeZoneToken = new Token(TimeZoneLiteral);
        SwitchRule FieldNameLiteralContinue = new SwitchRule("FieldNameLiteralContinue", new GrammarRule[0]);
        FieldNameLiteralContinue.body = Grammar.asRule(Grammar.Rule(FieldNameLiteralMiddle, FieldNameLiteralContinue), Grammar.emptyRule);
        SequenceRule Literal2 = Grammar.Rule("Literal", LiteralStart, LiteralContinue);
        SequenceRule FieldNameLiteral = Grammar.Rule("FieldNameLiteral", FieldNameLiteralStart, FieldNameLiteralContinue);
        GrammarRule WORD = new Token(Literal2);
        boolean optimizeLiterals = true;
        if (optimizeLiterals) {
            WORD = Grammar.WordLiteral;
        }
        Token FIELDNAMEWORD = new Token(FieldNameLiteral);
        SequenceRule NumberLiteral = new SequenceRule("NumberLiteral", new GrammarRule[0]);
        SwitchRule NumberLiteralContinue = new SwitchRule("NumberLiteralContinue", NumberLiteral, Grammar.emptyRule);
        NumberLiteral.body = Grammar.asRule(Grammar.Digit, NumberLiteralContinue);
        Token NUMBER = new Token(NumberLiteral);
        Keyword OR = new Keyword("OR", WORD);
        Keyword AND = new Keyword("AND", WORD);
        Keyword NOT = new Keyword("NOT", WORD);
        Keyword ANY = new Keyword("ANY", WORD);
        Keyword ALL = new Keyword("ALL", WORD);
        Keyword NONE = new Keyword("NONE", WORD);
        Keyword IS = new Keyword("IS", WORD);
        Keyword NULL = new Keyword("NULL", WORD);
        Keyword YEAR = new Keyword("YEAR", WORD);
        Keyword WEEK = new Keyword("WEEK", WORD);
        Keyword QUARTER = new Keyword("QUARTER", WORD);
        Keyword MOHTH = new Keyword("MONTH", WORD);
        Keyword DAY = new Keyword("DAY", WORD);
        Keyword HOUR = new Keyword("HOUR", WORD);
        Keyword MINUTE = new Keyword("MINUTE", WORD);
        Keyword SECOND = new Keyword("SECOND", WORD);
        Keyword WHERE = new Keyword("WHERE", WORD);
        Keyword TRUNCATE = new Keyword("TRUNCATE", WORD);
        Keyword BATCH = new Keyword("BATCH", WORD);
        Keyword SETS = new Keyword("SETS", WORD);
        Keyword TOP = new Keyword("TOP", WORD);
        Keyword BOTTOM = new Keyword("BOTTOM", WORD);
        Keyword FIRST = new Keyword("FIRST", WORD);
        Keyword LAST = new Keyword("LAST", WORD);
        GrammarToken GMT = new GrammarToken("GMT");
        Keyword MIN = new Keyword("MIN", WORD, false);
        Keyword MAX = new Keyword("MAX", WORD, false);
        Keyword COUNT = new Keyword("COUNT", WORD, false);
        Keyword MINCOUNT = new Keyword("MINCOUNT", WORD, false);
        Keyword MAXCOUNT = new Keyword("MAXCOUNT", WORD, false);
        Keyword SUM = new Keyword("SUM", WORD, false);
        Keyword AVERAGE = new Keyword("AVERAGE", WORD, false);
        Keyword DISTINCT = new Keyword("DISTINCT", WORD, false);
        Keyword DATEDIFF = new Keyword("DATEDIFF", WORD, false);
        Keyword TERMS = new Keyword("TERMS", WORD, false);
        Keyword GROUP = new Keyword("GROUP", WORD, false);
        Keyword EXCLUDE = new Keyword("EXCLUDE", WORD, false);
        Keyword INCLUDE = new Keyword("INCLUDE", WORD, false);
        Keyword AS = new Keyword("AS", WORD, false);
        Keyword Period = new Keyword("PERIOD", WORD, false);
        Keyword Today = new Keyword("TODAY", WORD, false);
        Keyword LastDay = new Keyword("LASTDAY", WORD, false);
        Keyword ThisHour = new Keyword("THISHOUR", WORD, false);
        Keyword LastHour = new Keyword("LASTHOUR", WORD, false);
        Keyword ThisMinute = new Keyword("THISMINUTE", WORD, false);
        Keyword LastMinute = new Keyword("LASTMINUTE", WORD, false);
        Keyword ThisWeek = new Keyword("THISWEEK", WORD, false);
        Keyword LastWeek = new Keyword("LASTWEEK", WORD, false);
        Keyword ThisMonth = new Keyword("THISMONTH", WORD, false);
        Keyword LastMonth = new Keyword("LASTMONTH", WORD, false);
        Keyword ThisYear = new Keyword("THISYEAR", WORD, false);
        Keyword LastYear = new Keyword("LASTYEAR", WORD, false);
        Keyword Now = new Keyword("NOW", WORD, false);
        Keyword Minute = new Keyword("MINUTE", WORD, false);
        Keyword Hour = new Keyword("HOUR", WORD, false);
        Keyword Day = new Keyword("DAY", WORD, false);
        Keyword Week = new Keyword("WEEK", WORD, false);
        Keyword Month = new Keyword("MONTH", WORD, false);
        Keyword Year = new Keyword("YEAR", WORD, false);
        Keyword Minutes1 = new Keyword("MINUTES", WORD, false);
        Keyword Hours1 = new Keyword("HOURS", WORD, false);
        Keyword Days1 = new Keyword("DAYS", WORD, false);
        Keyword Weeks1 = new Keyword("WEEKS", WORD, false);
        Keyword Months1 = new Keyword("MONTHS", WORD, false);
        Keyword Years1 = new Keyword("YEARS", WORD, false);
        CharacterRule CharE = new CharacterRule('E');
        CharacterRule Chare = new CharacterRule('e');
        SwitchRule Exponent = new SwitchRule("Exponent", CharE, Chare);
        SwitchRule SkipWhiteSpacesRule = new SwitchRule("AllowedWhitespaces", Grammar.WhiteSpaces, Grammar.emptyRule);
        SwitchRule OptWhiteSpaces = new SwitchRule("OptWhiteSpaces", Grammar.WhiteSpaces, Grammar.emptyRule);
        SequenceRule SpaceSeparatedTermList = Grammar.Rule("TermList", new GrammarRule[0]);
        SwitchRule TermListContinue = new SwitchRule("TermListContinue", Grammar.Rule(Grammar.WhiteSpaces, Grammar.Semantic("ImpliedOr"), SpaceSeparatedTermList), Grammar.emptyRule);
        SwitchRule StringLiteral = new SwitchRule("StringLiteral", SingleQuotedString, DoubleQuotedString);
        SwitchRule Term = new SwitchRule("Term", WORD, StringLiteral);
        SwitchRule PlusMinus = new SwitchRule("PlusMinus", PLUS, MINUS);
        SwitchRule ExponentField = new SwitchRule("ExponentField", Grammar.Rule(Exponent, PlusMinus, NUMBER), Grammar.Rule(Exponent, NUMBER), Grammar.emptyRule);
        SwitchRule FloatPointNumberContinue = new SwitchRule("FloatPointNumberContinue", Grammar.Rule(DOT, NUMBER, ExponentField), ExponentField);
        SwitchRule FloatPointLiteral = new SwitchRule("FloatPointNumber", Grammar.Rule(PlusMinus, NUMBER, FloatPointNumberContinue), Grammar.Rule(NUMBER, FloatPointNumberContinue));
        Token FloatPointNumber = new Token(FloatPointLiteral);
        SequenceRule FieldName = Grammar.Rule("FieldName", FIELDNAMEWORD);
        SpaceSeparatedTermList.body = Grammar.asRule(Term, TermListContinue);
        SwitchRule RangeStart = new SwitchRule("RangeStart", LEFTBRACE, LEFTBRACKET);
        SwitchRule RangeEnd = new SwitchRule("RangeEnd", RIGHTBRACKET, RIGHTBRACE);
        SequenceRule PeriodDefinition = new SequenceRule("PeriodDefinition", new GrammarRule[0]);
        SequenceRule NowFunction = new SequenceRule("NowFunction", new GrammarRule[0]);
        SwitchRule TermOrFunction = new SwitchRule(SwitchRule.First, "TermOrFunction", NowFunction, FloatPointNumber, Term);
        SequenceRule RangeExpressionValue = Grammar.Rule("RangeExpressionValue", TermOrFunction);
        SwitchRule RangeExpression = new SwitchRule(SwitchRule.First, "RangeExpression", Grammar.Rule(OptWhiteSpaces, RangeStart, OptWhiteSpaces, Grammar.MustMatchAction, RangeExpressionValue, Grammar.WhiteSpaces, TO, Grammar.WhiteSpaces, RangeExpressionValue, OptWhiteSpaces, RangeEnd), PeriodDefinition);
        ListRule CommaSeparatedTermList = new ListRule("CommaSeparatedTermList", TermOrFunction, Grammar.Rule(OptWhiteSpaces, COMMA, OptWhiteSpaces));
        SwitchRule EqualsExpressionValue = new SwitchRule(SwitchRule.First, "EqualsExpressionValue", RangeExpression, TermOrFunction, Grammar.Rule(LEFTPAREN, Grammar.MustMatchAction, OptWhiteSpaces, CommaSeparatedTermList, OptWhiteSpaces, RIGHTPAREN));
        SequenceRule Query2 = Grammar.Rule("Query", new GrammarRule[0]);
        SwitchRule LogicOperation = new SwitchRule("LogicOperation", OR, Grammar.Rule(AND), Grammar.Rule(Grammar.Semantic("ImpliedAnd"), NOT));
        SwitchRule OptionalLogicOperation = new SwitchRule(SwitchRule.First, "OptionalLogicOperation", Grammar.Rule(LogicOperation, Grammar.MustMatchAction, OptWhiteSpaces), Grammar.Rule(Grammar.Semantic("ImpliedAnd"), Grammar.emptyRule));
        SequenceRule ContainsExpression = new SequenceRule("ContainsExpression", new GrammarRule[0]);
        SwitchRule Value = new SwitchRule("Value", Grammar.Rule(OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, ContainsExpression, OptWhiteSpaces, RIGHTPAREN), TermOrFunction, RangeExpression);
        SwitchRule ContainsExpressionContinue = new SwitchRule(SwitchRule.First, "ContainsExpressionContinue", Grammar.Rule(Grammar.WhiteSpaces, OptionalLogicOperation, ContainsExpression), Grammar.emptyRule);
        ContainsExpression.body = Grammar.asRule(Value, ContainsExpressionContinue);
        SwitchRule CompareOperation = new SwitchRule("CompareOperation", LESS, LESSEQUAL, GREATER, GREATEREQUAL);
        SwitchRule TimestampSubfield = new SwitchRule("TimestampSubfield", YEAR, MOHTH, DAY, HOUR, MINUTE, SECOND);
        GrammarRule DotSemantic = Grammar.Semantic("dotSemantic");
        GrammarRule LinkFunctionEndSemantic = Grammar.Semantic("linkFunctionEndSemantic");
        SequenceRule TransitiveLimit = Grammar.Rule("TransitiveLimit", LEFTPAREN, OptWhiteSpaces, Grammar.MustMatchAction, NUMBER, OptWhiteSpaces, RIGHTPAREN, Grammar.Semantic("transitiveValue"));
        SwitchRule OptionalTransitiveLimit = new SwitchRule("OptionalTransitiveLimit", TransitiveLimit, Grammar.emptyRule);
        SwitchRule OptionalTransitiveFunction = new SwitchRule(SwitchRule.First, "OptionalTransitiveFunction", Grammar.Rule(TRANSITIVE, Grammar.MustMatchAction, OptionalTransitiveLimit), Grammar.Rule(Grammar.emptyRule));
        SequenceRule FieldPath = new SequenceRule("FieldPath", new GrammarRule[0]);
        SwitchRule ExplicitFunctionType = new SwitchRule(SwitchRule.First, "ExplicitFunctionType", ANY, ALL, NONE);
        SequenceRule ExplicitQuantifierFunction = Grammar.Rule("ExplicitQuantifierFunction", ExplicitFunctionType, OptWhiteSpaces, LEFTPAREN, Grammar.MustMatchAction, OptWhiteSpaces, FieldPath, OptionalTransitiveFunction, OptWhiteSpaces, RIGHTPAREN, LinkFunctionEndSemantic, OptWhiteSpaces);
        SwitchRule SearchCriteria = new SwitchRule(SwitchRule.First, "SearchCriteria", Grammar.Rule(OptWhiteSpaces, COLON, OptWhiteSpaces, Grammar.MustMatchAction, Value), Grammar.Rule(SkipWhiteSpacesRule, EQUAL, SkipWhiteSpacesRule, Grammar.MustMatchAction, EqualsExpressionValue), Grammar.Rule(SkipWhiteSpacesRule, IN, Grammar.SetTextValue("="), SkipWhiteSpacesRule, Grammar.MustMatchAction, EqualsExpressionValue), Grammar.Rule(OptWhiteSpaces, CompareOperation, Grammar.MustMatchAction, OptWhiteSpaces, TermOrFunction), Grammar.Rule(SkipWhiteSpacesRule, IS, SkipWhiteSpacesRule, Grammar.MustMatchAction, NULL));
        SwitchRule FieldOrLinkOperation = new SwitchRule(SwitchRule.First, "FieldOrLinkOperation", SearchCriteria, Grammar.emptyRule);
        SequenceRule WhereQuery = Grammar.Rule("WhereQuery", new GrammarRule[0]);
        SequenceRule WhereParenthesizedExpression = Grammar.Rule("WhereParenthesizedExpression", OptWhiteSpaces, LEFTPAREN, Grammar.MustMatchAction, Query2, OptWhiteSpaces, RIGHTPAREN);
        SwitchRule WhereExpression = new SwitchRule(SwitchRule.First, "WhereExpression", NowFunction, Grammar.Rule(Term, FieldOrLinkOperation));
        SwitchRule WhereClauseType = new SwitchRule(SwitchRule.First, "WhereClauseType", WhereParenthesizedExpression, WhereExpression);
        SwitchRule WhereClause = new SwitchRule("WhereClause", new GrammarRule[0]);
        WhereClause.body = Grammar.asRule(Grammar.Rule(NOT, OptWhiteSpaces, Query2), WhereClauseType);
        WhereQuery.body = Grammar.asRule(OptWhiteSpaces, Query2);
        SequenceRule NumberRangeExpression = Grammar.Rule("NumberRangeExpression", OptWhiteSpaces, RangeStart, OptWhiteSpaces, Grammar.MustMatchAction, NUMBER, Grammar.WhiteSpaces, TO, Grammar.WhiteSpaces, NUMBER, OptWhiteSpaces, RangeEnd);
        SwitchRule CountLinkValue = new SwitchRule("CountLinkValue", NUMBER, NumberRangeExpression);
        SwitchRule CountExpressionContinue = new SwitchRule("CountExpressionContinue", Grammar.Rule(OptWhiteSpaces, EQUAL, Grammar.MustMatchAction, OptWhiteSpaces, CountLinkValue), Grammar.Rule(OptWhiteSpaces, CompareOperation, Grammar.MustMatchAction, OptWhiteSpaces, NUMBER), Grammar.Rule(OptWhiteSpaces, COLON, Grammar.MustMatchAction, OptWhiteSpaces, NumberRangeExpression));
        SwitchRule WhereClauseEnd = new SwitchRule("WhereContinue", new GrammarRule[0]);
        WhereClauseEnd.setMode(SwitchRule.First);
        SequenceRule StartingWhereClause = Grammar.Rule("StartingWhereClause", WHERE, Grammar.DropLexem, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, Query2, OptWhiteSpaces, RIGHTPAREN, WhereClauseEnd);
        SwitchRule CountExpressionFieldPath = new SwitchRule(SwitchRule.First, "CountExpressionFieldPath", Grammar.Rule(WHERE, Grammar.DropLexem, OptWhiteSpaces, LEFTPAREN, Grammar.DropLexem, OptWhiteSpaces, FieldPath, OptWhiteSpaces, RIGHTPAREN, Grammar.DropLexem), FieldPath);
        SequenceRule CountExpression = Grammar.Rule("CountExpression", COUNT, Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, CountExpressionFieldPath, OptWhiteSpaces, RIGHTPAREN, LinkFunctionEndSemantic, OptWhiteSpaces, CountExpressionContinue);
        SwitchRule NextClause = new SwitchRule("NextClause", Grammar.Rule(Grammar.WhiteSpaces, OptionalLogicOperation, Query2), Grammar.emptyRule);
        SwitchRule ExpressionContinue = new SwitchRule("ExpressionContinue", new GrammarRule[0]);
        ExpressionContinue.setMode(SwitchRule.First);
        SequenceRule QueryWhere = Grammar.Rule("QueryWhere", WHERE, Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, Grammar.Semantic("("), OptWhiteSpaces, Grammar.MustMatchAction, Query2, OptWhiteSpaces, RIGHTPAREN);
        SwitchRule FieldPathContinue = new SwitchRule("FieldPathContinue", new GrammarRule[0]);
        SequenceRule FieldPathNext = Grammar.Rule("FieldPathNext", FieldName, DotSemantic, FieldPathContinue);
        FieldPathContinue.body = Grammar.asRule(Grammar.Rule(DOT, Grammar.Semantic("WHERE_FILTER_START"), QueryWhere, Grammar.Semantic("WHERE_FILTER_END"), Grammar.MustMatchAction, FieldPathContinue), Grammar.Rule(DOT, FieldPathNext), Grammar.emptyRule);
        FieldPath.body = Grammar.asRule(FieldName, FieldPathContinue);
        SwitchRule WhereContinue = new SwitchRule("WhereContinue", new GrammarRule[0]);
        WhereContinue.setMode(SwitchRule.First);
        ArrayList<GrammarRule> bodyw = new ArrayList<GrammarRule>();
        bodyw.add(Grammar.Rule(DOT, Grammar.Semantic("WHERE_SIBLING_START"), QueryWhere, Grammar.Semantic("WHERE_SIBLING_END"), Grammar.MustMatchAction, WhereContinue));
        bodyw.add(Grammar.Rule(Grammar.Semantic(")"), Grammar.Semantic("SearchCriteriaStart"), SearchCriteria));
        bodyw.add(Grammar.Rule(Grammar.Semantic("WHERE_CONTINUE_START"), ExpressionContinue, Grammar.Semantic("WHERE_CONTINUE_END")));
        bodyw.add(Grammar.Rule(Grammar.Semantic(")"), Grammar.emptyRule));
        WhereContinue.body = bodyw;
        SwitchRule ExpressionContinueWithoutTransitive = new SwitchRule(SwitchRule.First, "ExpressionContinueWithoutTransitive", Grammar.Rule(DOT, TimestampSubfield, Grammar.MustMatchAction, Grammar.SetType("lexem"), DotSemantic, SearchCriteria), Grammar.Rule(DOT, QueryWhere, WhereContinue), Grammar.Rule(DOT, ExplicitQuantifierFunction, DotSemantic, ExpressionContinue), Grammar.Rule(DOT, Grammar.MustMatchAction, FieldName, DotSemantic, ExpressionContinue), Grammar.Rule(SearchCriteria));
        ArrayList<GrammarRule> body = new ArrayList<GrammarRule>();
        body.add(ExpressionContinueWithoutTransitive);
        body.add(Grammar.Rule(TRANSITIVE, Grammar.MustMatchAction, OptionalTransitiveLimit, ExpressionContinueWithoutTransitive));
        body.add(SearchCriteria);
        ExpressionContinue.body = body;
        SwitchRule Expression = new SwitchRule(SwitchRule.First, "Expression", CountExpression, StartingWhereClause, NowFunction, FloatPointNumber, Grammar.Rule(ExplicitQuantifierFunction, ExpressionContinue), Grammar.Rule(FieldName, ExpressionContinue), Term);
        WhereClauseEnd.body = Grammar.asRule(Grammar.Rule(DOT, Grammar.DropLexem, Grammar.Semantic("ImpliedAnd"), Expression), Grammar.emptyRule);
        SwitchRule Clause = new SwitchRule(SwitchRule.First, "Clause", Grammar.Rule(NOT, OptWhiteSpaces, Query2), Grammar.Rule(OptWhiteSpaces, LEFTPAREN, Grammar.MustMatchAction, OptWhiteSpaces, Query2, OptWhiteSpaces, RIGHTPAREN), Expression);
        Query2.body = Grammar.asRule(OptWhiteSpaces, Clause, Grammar.MustMatchAction, NextClause);
        SequenceRule DoradusQuery = Grammar.Rule("DoradusQuery", Query2, SkipWhiteSpacesRule, Grammar.Semantic("EOF"));
        SwitchRule FloatPointNumberOrTerm = new SwitchRule(SwitchRule.First, "FloatPointNumberOrTerm", FloatPointNumber, Term);
        ListRule NumbersList = new ListRule("NumbersList", Grammar.Rule(FloatPointNumberOrTerm, Grammar.SetType("BatchValue")), Grammar.Rule(OptWhiteSpaces, COMMA, Grammar.SetType("ignore"), OptWhiteSpaces));
        SwitchRule ExcludeItemValue = new SwitchRule(SwitchRule.First, "ExcludeItemValue", FloatPointNumber, Term, NULL);
        ListRule ExcludeNameList = new ListRule("ExcludeNameList", Grammar.Rule(ExcludeItemValue, Grammar.SetType("excludeValue")), Grammar.Rule(SkipWhiteSpacesRule, COMMA, Grammar.SetType("ignore"), SkipWhiteSpacesRule, Grammar.MustMatchAction));
        SequenceRule AggregationFieldPath = new SequenceRule("AggregationFieldPath", new GrammarRule[0]);
        SwitchRule ExcludeOrInclude = new SwitchRule("ExcludeOrInclude", Grammar.Rule(EXCLUDE, Grammar.SetType("ExcludeList")), Grammar.Rule(INCLUDE, Grammar.SetType("IncludeList")));
        SequenceRule AggregationFieldPathEnd = Grammar.Rule("AggregationFieldPathEnd", DOT, ExcludeOrInclude, Grammar.MustMatchAction, SkipWhiteSpacesRule, LEFTPAREN, Grammar.SetType("ignore"), SkipWhiteSpacesRule, ExcludeNameList, SkipWhiteSpacesRule, RIGHTPAREN, Grammar.SetType("ignore"));
        SwitchRule AggregationFieldPathContinue = new SwitchRule(SwitchRule.First, "AggregationFieldPathContinue", Grammar.Rule(AggregationFieldPathEnd, AggregationFieldPathEnd), AggregationFieldPathEnd, Grammar.Rule(DOT, TimestampSubfield, Grammar.SetType("TruncateSubfieldValue")), Grammar.Rule(DOT, AggregationFieldPath), Grammar.emptyRule);
        SequenceRule Subfield = new SequenceRule("Subfield", new GrammarRule[0]);
        SwitchRule SubfieldContinue = new SwitchRule(SwitchRule.First, "SubfieldContinue", Grammar.Rule(DOT, TimestampSubfield, Grammar.SetType("TruncateSubfieldValue")), Grammar.Rule(DOT, Subfield), Grammar.Rule(TRANSITIVE, Grammar.SetType("transitive"), LEFTPAREN, Grammar.DropLexem, NUMBER, Grammar.SetType("transitiveValue"), RIGHTPAREN, Grammar.DropLexem, DOT, Subfield), Grammar.Rule(TRANSITIVE, Grammar.SetType("transitive"), DOT, Subfield), Grammar.Rule(TRANSITIVE, Grammar.SetType("transitive")), Grammar.emptyRule);
        Subfield.body = Grammar.asRule(WORD, SubfieldContinue);
        SwitchRule OptionalWhereClause = new SwitchRule("OptionalWhereClause", new GrammarRule[0]);
        OptionalWhereClause.setMode(SwitchRule.First);
        ArrayList<GrammarRule> obody = new ArrayList<GrammarRule>();
        obody.add(Grammar.Rule(DOT, WHERE, Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, Query2, OptWhiteSpaces, RIGHTPAREN, Grammar.Semantic("EOF"), Grammar.Semantic("ENDWHERE"), OptionalWhereClause));
        obody.add(Grammar.emptyRule);
        OptionalWhereClause.body = obody;
        SwitchRule OptionalTransitiveClause = new SwitchRule(SwitchRule.First, "OptionalTransitiveClause", Grammar.Rule(TRANSITIVE, Grammar.SetType("transitive"), LEFTPAREN, Grammar.DropLexem, NUMBER, Grammar.SetType("transitiveValue"), RIGHTPAREN, Grammar.DropLexem), Grammar.Rule(TRANSITIVE, Grammar.SetType("transitive")), Grammar.emptyRule);
        SequenceRule AggregationFieldName = Grammar.Rule("AggregationFieldName", WORD, OptionalTransitiveClause, Grammar.NotLexem("AS"), OptionalWhereClause);
        SwitchRule AggregationFieldCaseFunctionName = new SwitchRule(SwitchRule.First, "AggregationFieldCaseFunctionName", Grammar.Rule(LOWER, Grammar.SetType("LOWER")), Grammar.Rule(UPPER, Grammar.SetType("UPPER")));
        SwitchRule AggregationFieldSubfieldPathWhere = new SwitchRule("AggregationFieldSubfieldPathWhere", new GrammarRule[0]);
        SwitchRule AggregationFieldCaseFunctionClause = new SwitchRule("AggregationFieldCaseFunctionClause", Grammar.Rule(AggregationFieldCaseFunctionName, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, AggregationFieldSubfieldPathWhere, OptWhiteSpaces, RIGHTPAREN), AggregationFieldSubfieldPathWhere);
        SequenceRule StopWordList = new SequenceRule("StopWordList", new GrammarRule[0]);
        SwitchRule StopWordListContinue = new SwitchRule("StopWordListContinue", Grammar.Rule(Grammar.WhiteSpaces, Grammar.MustMatchAction, StopWordList), Grammar.emptyRule);
        StopWordList.body = Grammar.asRule(WORD, Grammar.SetType("stopValue"), StopWordListContinue);
        SwitchRule OptionalStopWordList = new SwitchRule(SwitchRule.First, "OptionalStopWordList", Grammar.Rule(OptWhiteSpaces, COMMA, Grammar.SetType("ignore"), OptWhiteSpaces, LEFTPAREN, Grammar.SetType("ignore"), OptWhiteSpaces, StopWordList, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("ignore")), Grammar.Rule(Grammar.emptyRule, Grammar.Semantic("stopWordAny")));
        SwitchRule AggregationQueryTermsClause = new SwitchRule(SwitchRule.First, "AggregationQueryTermsClause", Grammar.Rule(OptWhiteSpaces, TERMS, Grammar.SetType("TERMS"), Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, Grammar.SetType("ignore"), OptWhiteSpaces, AggregationFieldCaseFunctionClause, OptionalStopWordList, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("ignore")), AggregationFieldCaseFunctionClause);
        SwitchRule AggregationFieldDateFunctionName = new SwitchRule("AggregationFieldDateFunctionName", TimestampSubfield, WEEK, QUARTER);
        SwitchRule Hours = new SwitchRule("Hours", Grammar.Digit, Grammar.Rule(Grammar.Digit, Grammar.Digit));
        SequenceRule Minutes = Grammar.Rule("Minutes", Grammar.Rule(Grammar.Digit, Grammar.Digit));
        Token GmtValue4 = new Token(Grammar.Rule(Grammar.Digit, Grammar.Digit, Grammar.Digit, Grammar.Digit));
        Token GmtValue3 = new Token(Grammar.Rule(Grammar.Digit, Grammar.Digit, Grammar.Digit));
        Token GmtValue2 = new Token(Grammar.Rule(Grammar.Digit, Grammar.Digit));
        Token GmtValue1 = new Token(Grammar.Rule(Grammar.Digit));
        Token HoursColonMinutes = new Token(Grammar.Rule(Hours, COLON, Minutes));
        Token GmtValue = new Token(new SwitchRule(SwitchRule.First, "GmtValue", Grammar.Rule(HoursColonMinutes), Grammar.Rule(GmtValue4), Grammar.Rule(GmtValue3), Grammar.Rule(GmtValue2), Grammar.Rule(GmtValue1)));
        Token GmtSignValue = new Token(Grammar.Rule("GmtSignValue", PlusMinus, GmtValue));
        SequenceRule TimeZoneValue = Grammar.Rule("TimeZoneValue", GMT, Grammar.DropLexem, GmtSignValue);
        SwitchRule GmtTime = new SwitchRule("GmtOption", Grammar.Rule(GMT, GmtSignValue), TimeZoneValue);
        SwitchRule TimeZoneDefinition = new SwitchRule(SwitchRule.First, "TimeZoneDefinition", Grammar.Rule(TimeZoneValue, Grammar.SetType("TimeZoneValue")), Grammar.Rule(SINGLEQUOTE, Grammar.DropLexem, TimeZoneValue, Grammar.SetType("TimeZoneValue"), SINGLEQUOTE, Grammar.DropLexem), Grammar.Rule(DOUBLEQUOTE, Grammar.DropLexem, TimeZoneValue, Grammar.SetType("TimeZoneValue"), DOUBLEQUOTE, Grammar.DropLexem), Grammar.Rule(StringLiteral, Grammar.SetType("TimeZoneDisplayName")), Grammar.Rule(TimeZoneToken, Grammar.SetType("TimeZoneDisplayName")));
        SwitchRule TimeZone2 = new SwitchRule(SwitchRule.First, "TimeZone", Grammar.Rule(GmtTime, Grammar.SetType("TimeZoneValue")), Grammar.Rule(SINGLEQUOTE, Grammar.DropLexem, GmtTime, Grammar.SetType("TimeZoneValue"), SINGLEQUOTE, Grammar.DropLexem), Grammar.Rule(DOUBLEQUOTE, Grammar.DropLexem, GmtTime, Grammar.SetType("TimeZoneValue"), DOUBLEQUOTE, Grammar.DropLexem), Grammar.Rule(StringLiteral, Grammar.SetType("TimeZoneDisplayName")), Grammar.Rule(TimeZoneToken, Grammar.SetType("TimeZoneDisplayName")));
        SwitchRule OptionalTimeZone = new SwitchRule("OptionalTimeZone", Grammar.Rule(COMMA, Grammar.SetType("ignore"), OptWhiteSpaces, TimeZone2), Grammar.emptyRule);
        SwitchRule OptionalPeriodTimeZone = new SwitchRule(SwitchRule.First, "OptionalPeriodTimeZone", Grammar.Rule(OptWhiteSpaces, TimeZoneDefinition), Grammar.SetType("PeriodGMT"));
        SwitchRule ThisPeriodUnits = new SwitchRule(SwitchRule.First, "ThisPeriodUnits", Grammar.Rule(ThisMinute), Grammar.Rule(ThisHour), Grammar.Rule(Today), Grammar.Rule(ThisWeek), Grammar.Rule(ThisMonth), Grammar.Rule(ThisYear));
        SwitchRule LastPeriodUnits = new SwitchRule(SwitchRule.First, "LastPeriodUnits", Grammar.Rule(LastMinute), Grammar.Rule(LastHour), Grammar.Rule(LastDay), Grammar.Rule(LastWeek), Grammar.Rule(LastMonth), Grammar.Rule(LastYear));
        SwitchRule OptionalLastPeriodValue = new SwitchRule(SwitchRule.First, "OptionalLastPeriodValue", Grammar.Rule(OptWhiteSpaces, LEFTPAREN, Grammar.SetType("ignore"), OptWhiteSpaces, NUMBER, Grammar.SetType("LastPeriodValue"), OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("ignore")), Grammar.emptyRule);
        SwitchRule PeriodUnits = new SwitchRule(SwitchRule.First, "PeriodUnits", Grammar.Rule(LastPeriodUnits, Grammar.SetType("LastPeriodUnits"), OptionalLastPeriodValue), Grammar.Rule(ThisPeriodUnits, Grammar.SetType("ThisPeriodUnits")), Grammar.Error("Wrong syntax: Expected Last* or This*"));
        SwitchRule PeriodDefinitionContinue = new SwitchRule(SwitchRule.First, "PeriodDefinitionContinue", Grammar.Rule(DOT, Grammar.SetType("ignore"), PeriodUnits, Grammar.Semantic("CalculatePeriod")), Grammar.Error("error", "Wrong syntax for Period definition"));
        PeriodDefinition.body = Grammar.asRule(OptWhiteSpaces, Period, Grammar.SetType("ignore"), OptWhiteSpaces, LEFTPAREN, Grammar.SetType("ignore"), Grammar.MustMatchAction, OptionalPeriodTimeZone, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("ignore"), PeriodDefinitionContinue);
        SwitchRule NowUnits = new SwitchRule("NowUnits", Minute, Hour, Day, Week, Month, Year, Minutes1, Hours1, Days1, Weeks1, Months1, Years1);
        SequenceRule NowUnitsDefinition = Grammar.Rule("NowUnitsDefinition", NowUnits, Grammar.SetType("NowUnits"));
        SwitchRule SignNumber = new SwitchRule("SignNumber", Grammar.Rule(PLUS, Grammar.SetType("ignore"), NUMBER, Grammar.SetType("PositiveNumber")), Grammar.Rule(MINUS, Grammar.SetType("ignore"), NUMBER, Grammar.SetType("NegativeNumber")));
        SwitchRule NowDefinitionContinue = new SwitchRule("NowDefinitionContinue", Grammar.Rule(TimeZoneDefinition, Grammar.WhiteSpaces, SignNumber, Grammar.WhiteSpaces, NowUnitsDefinition), Grammar.Rule(SignNumber, Grammar.WhiteSpaces, NowUnitsDefinition), TimeZoneDefinition, Grammar.emptyRule);
        NowFunction.body = Grammar.asRule(OptWhiteSpaces, Now, Grammar.SetType("Now"), OptWhiteSpaces, LEFTPAREN, Grammar.SetType("ignore"), OptWhiteSpaces, NowDefinitionContinue, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("ignore"), Grammar.Semantic("CalculateNow"));
        SwitchRule AggregationQueryTruncateClause = new SwitchRule("AggregationQueryTruncateClause", Grammar.Rule(TRUNCATE, Grammar.SetType("TRUNCATE"), Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, AggregationQueryTermsClause, OptWhiteSpaces, COMMA, Grammar.SetType("ignore"), OptWhiteSpaces, AggregationFieldDateFunctionName, Grammar.SetType("TruncateValue"), OptWhiteSpaces, OptionalTimeZone, OptWhiteSpaces, RIGHTPAREN), Grammar.Rule(AggregationQueryTermsClause, OptWhiteSpaces, Grammar.Semantic("EOAE")));
        SwitchRule BatchexCase = new SwitchRule("BatchexCase", Query2, OptWhiteSpaces, AS, OptWhiteSpaces, Term, OptWhiteSpaces);
        ListRule BatchexList = new ListRule("BatchexList", BatchexCase, Grammar.Rule(OptWhiteSpaces, COMMA, Grammar.SetType("NEXTSETS"), OptWhiteSpaces));
        SwitchRule AggregationQueryBatchClause = new SwitchRule("AggregationQueryBatchClause", Grammar.Rule(SETS, Grammar.SetType("SETS"), Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, Grammar.SetType("ignore"), OptWhiteSpaces, BatchexList, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("ENDSETS")), Grammar.Rule(BATCH, Grammar.SetType("BATCH"), Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, AggregationQueryTruncateClause, OptWhiteSpaces, COMMA, Grammar.SetType("ignore"), OptWhiteSpaces, NumbersList, OptWhiteSpaces, RIGHTPAREN), AggregationQueryTruncateClause);
        SwitchRule TopBottom = new SwitchRule("TopBottom", TOP, BOTTOM, FIRST, LAST);
        SequenceRule AggregationQueryList = new SequenceRule("AggregationQueryList", new GrammarRule[0]);
        SwitchRule AggregationQueryListContinue = new SwitchRule("AggregationQueryListContinue", Grammar.Rule(OptWhiteSpaces, COMMA, OptWhiteSpaces, AggregationQueryList), Grammar.emptyRule);
        SwitchRule AggregationQuery = new SwitchRule("AggregationQuery", AggregationQueryBatchClause, Grammar.Rule(TopBottom, Grammar.MustMatchAction, Grammar.SetType("topbottom"), OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, NUMBER, Grammar.SetType("topbottomvalue"), OptWhiteSpaces, COMMA, Grammar.SetType("ignore"), OptWhiteSpaces, AggregationQueryBatchClause, OptWhiteSpaces, RIGHTPAREN));
        SwitchRule AggregationAliasName = new SwitchRule(SwitchRule.First, "AggregationAliasName", Grammar.Rule(SkipWhiteSpacesRule, AS, Grammar.SetType("ignore"), SkipWhiteSpacesRule, Term, Grammar.SetType("alias")), Grammar.Rule(DOT, Grammar.DropLexem, AS, Grammar.SetType("ignore"), LEFTPAREN, Grammar.DropLexem, OptWhiteSpaces, Term, Grammar.SetType("alias"), OptWhiteSpaces, RIGHTPAREN), Grammar.emptyRule);
        AggregationQueryList.body = Grammar.asRule(OptWhiteSpaces, AggregationQuery, AggregationAliasName, OptWhiteSpaces, AggregationQueryListContinue);
        SwitchRule AggregationGroupValues = new SwitchRule(SwitchRule.First, "AggregationGroupValues", STAR, AggregationQueryList);
        SequenceRule AggregationGroup2 = Grammar.Rule("AggregationGroup", OptWhiteSpaces, GROUP, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, AggregationGroupValues, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("endGroup"));
        SequenceRule AggregationGroupList = new SequenceRule("AggregationGroupList", new GrammarRule[0]);
        SwitchRule AggregationGroupListContinue = new SwitchRule("AggregationGroupListContinue", Grammar.Rule(OptWhiteSpaces, COMMA, Grammar.SetType("newGroup"), OptWhiteSpaces, AggregationGroupList), Grammar.emptyRule);
        AggregationGroupList.body = Grammar.asRule(AggregationGroup2, OptWhiteSpaces, AggregationGroupListContinue);
        AggregationFieldPath.body = Grammar.asRule(AggregationFieldName, AggregationFieldPathContinue);
        SwitchRule AggregationClause = new SwitchRule(SwitchRule.First, "AggregationClause", AggregationGroupList, AggregationQueryList);
        SwitchRule AggregationWordStart = new SwitchRule(SwitchRule.First, "AggregationWordStart", Grammar.Letter, Grammar.Digit, UNDERSCORE, FETCH, DIES);
        SwitchRule AggregationWordNext = new SwitchRule("AggregationWordNext", new GrammarRule[0]);
        AggregationWordNext.body = Grammar.asRule(Grammar.Rule(AggregationWordStart, AggregationWordNext), Grammar.emptyRule);
        SwitchRule StatisticMetricFunctionName = new SwitchRule("StatisticMetricFunctionName", SUM, AVERAGE, COUNT, MINCOUNT, MAXCOUNT);
        SwitchRule AggregationMetricFunctionName = new SwitchRule("AggregationMetricFunctionName", MIN, MAX, DISTINCT, StatisticMetricFunctionName);
        SwitchRule switchRule = new SwitchRule("MetricFunctionBinary", new Keyword("ROUNDUP", WORD));
        AggregationFieldSubfieldPathWhere.body = Grammar.asRule(Grammar.Rule(WHERE, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, Query2, OptWhiteSpaces, RIGHTPAREN, Grammar.Semantic("EOF"), Grammar.Semantic("ENDWHERE"), DOT, Grammar.SetType("DOT"), AggregationFieldSubfieldPathWhere), Grammar.Rule(new GrammarRule[]{MetricFunctionBinary, Grammar.SetType("MetricFunctionBinary"), OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, AggregationFieldSubfieldPathWhere, OptWhiteSpaces, COMMA, Grammar.SetType("MetricFunctionComma"), OptWhiteSpaces, Term, Grammar.SetType("MetricFunctionParameter"), RIGHTPAREN}), AggregationFieldPath);
        SequenceRule sequenceRule = Grammar.Rule("AggregationMetricFunctionQuery", OptWhiteSpaces, AggregationMetricFunctionName, Grammar.SetType("AggregationMetricFunctionName"), Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, AggregationFieldSubfieldPathWhere, OptWhiteSpaces, RIGHTPAREN);
        SwitchRule switchRule2 = new SwitchRule(SwitchRule.First, "DateDiffParameterValue", Grammar.Rule(NowFunction), Grammar.Rule(Term, Grammar.SetType("datediff")));
        SequenceRule sequenceRule2 = Grammar.Rule("DateDiffParameters", new GrammarRule[]{OptWhiteSpaces, AggregationFieldDateFunctionName, Grammar.SetType("datediff"), OptWhiteSpaces, COMMA, Grammar.DropLexem, OptWhiteSpaces, DateDiffParameterValue, OptWhiteSpaces, COMMA, Grammar.DropLexem, OptWhiteSpaces, DateDiffParameterValue, Grammar.Semantic("datediff_calc")});
        SequenceRule sequenceRule3 = Grammar.Rule("DateDiffFunction", new GrammarRule[]{OptWhiteSpaces, DATEDIFF, Grammar.DropLexem, OptWhiteSpaces, LEFTPAREN, Grammar.DropLexem, OptWhiteSpaces, DateDiffParameters, OptWhiteSpaces, RIGHTPAREN, Grammar.DropLexem});
        SwitchRule switchRule3 = new SwitchRule("WhereStar", new GrammarRule[0]);
        WhereStar.body = Grammar.asRule(Grammar.Rule(new GrammarRule[]{WHERE, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, Query2, OptWhiteSpaces, RIGHTPAREN, Grammar.Semantic("EOF"), Grammar.Semantic("ENDWHERE"), DOT, Grammar.SetType("DOT"), WhereStar}), STAR);
        SequenceRule sequenceRule4 = Grammar.Rule("AggregationMetricCountStarQuery", new GrammarRule[]{OptWhiteSpaces, COUNT, Grammar.SetType("AggregationMetricFunctionName"), OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, WhereStar, OptWhiteSpaces, RIGHTPAREN});
        SwitchRule switchRule4 = new SwitchRule("SignNumberContinue", Grammar.Rule(DOT, NUMBER), Grammar.emptyRule);
        SwitchRule switchRule5 = new SwitchRule(SwitchRule.First, "DoubleNumberLiteral", Grammar.Rule(new GrammarRule[]{PLUS, Grammar.MustMatchAction, NUMBER, SignNumberContinue}), Grammar.Rule(new GrammarRule[]{MINUS, Grammar.MustMatchAction, NUMBER, SignNumberContinue}), Grammar.Rule(new GrammarRule[]{NUMBER, SignNumberContinue}));
        Token token = new Token((GrammarRule)DoubleNumberLiteral);
        SwitchRule switchRule6 = new SwitchRule(SwitchRule.First, "AggregationMetricQuery", new GrammarRule[]{AggregationMetricCountStarQuery, DateDiffFunction, AggregationMetricFunctionQuery, Grammar.Rule(OptWhiteSpaces, FloatPointNumber, Grammar.SetType("number")), Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, DOUBLENUMBER, Grammar.SetType("number")}), Grammar.Rule(OptWhiteSpaces, Subfield)});
        SwitchRule switchRule7 = new SwitchRule(SwitchRule.First, "ArithmeticOperation", PLUS, MINUS, STAR, DIVIDE);
        SwitchRule switchRule8 = new SwitchRule("AggregationMetricExpression", new GrammarRule[0]);
        SwitchRule switchRule9 = new SwitchRule(SwitchRule.First, "AggregationMetricExpressionContinue", Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, ArithmeticOperation, Grammar.SetType("op"), OptWhiteSpaces, AggregationMetricExpression}), Grammar.emptyRule);
        SwitchRule switchRule10 = new SwitchRule(SwitchRule.First, "OptionalMetricAlias", Grammar.Rule(Grammar.WhiteSpaces, AS, Grammar.DropLexem, Grammar.WhiteSpaces, Term, Grammar.SetType("ALIAS_NAME")), Grammar.emptyRule);
        SequenceRule sequenceRule5 = Grammar.Rule("AggregationMetricQueryTerm", new GrammarRule[]{AggregationMetricQuery, OptionalMetricAlias, Grammar.InputPointer, Grammar.Semantic("endMetric"), OptWhiteSpaces, AggregationMetricExpressionContinue});
        AggregationMetricExpression.body = Grammar.asRule(new GrammarRule[]{Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, LEFTPAREN, Grammar.SetType("op"), OptWhiteSpaces, AggregationMetricExpression, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("op"), AggregationMetricExpressionContinue}), AggregationMetricQueryTerm});
        SequenceRule sequenceRule6 = new SequenceRule("AggregationMetricQueryList", new GrammarRule[0]);
        SwitchRule switchRule11 = new SwitchRule("AggregationMetricQueryListContinue", Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, COMMA, OptWhiteSpaces, AggregationMetricQueryList}), Grammar.Rule(OptWhiteSpaces, Grammar.emptyRule));
        AggregationMetricQueryList.body = Grammar.asRule(new GrammarRule[]{AggregationMetricExpression, AggregationMetricQueryListContinue});
        SwitchRule switchRule12 = new SwitchRule(SwitchRule.First, "StatisticParameterValue", FloatPointNumber, Term, StringLiteral);
        SequenceRule sequenceRule7 = Grammar.Rule("StatisticRangeExpression", new GrammarRule[]{OptWhiteSpaces, LEFTBRACKET, OptWhiteSpaces, Grammar.MustMatchAction, StatisticParameterValue, Grammar.WhiteSpaces, TO, Grammar.WhiteSpaces, StatisticParameterValue, OptWhiteSpaces, RIGHTBRACKET});
        SwitchRule switchRule13 = new SwitchRule(SwitchRule.First, "StatisticParameterContinue", Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, EQUAL, Grammar.MustMatchAction, OptWhiteSpaces, StatisticParameterValue, Grammar.Semantic("value")}), Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, COLON, Grammar.MustMatchAction, OptWhiteSpaces, StatisticRangeExpression, Grammar.Semantic("rangeValue")}));
        SwitchRule switchRule14 = new SwitchRule(SwitchRule.First, "StatisticParameter", Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, GROUP, Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, NUMBER, Grammar.Semantic("level"), OptWhiteSpaces, RIGHTPAREN, StatisticParameterContinue}), OptWhiteSpaces);
        SequenceRule sequenceRule8 = new SequenceRule("FieldOrLinkName", new GrammarRule[0]);
        SwitchRule switchRule15 = new SwitchRule(SwitchRule.Longest, "FieldOrLinkNameNext", Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, DOT, Grammar.SetType("DOT"), FieldOrLinkName}), Grammar.emptyRule);
        SequenceRule sequenceRule9 = new SequenceRule("FieldSet", new GrammarRule[0]);
        SwitchRule switchRule16 = new SwitchRule(SwitchRule.Longest, "FieldOrLinkNameContinue", new GrammarRule[]{Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, LEFTPAREN, Grammar.SetType("LEFTPAREN"), Grammar.MustMatchAction, FieldSet2, OptWhiteSpaces, RIGHTPAREN, Grammar.SetType("RIGHTPAREN"), FieldOrLinkNameNext}), FieldOrLinkNameNext});
        SwitchRule switchRule17 = new SwitchRule(SwitchRule.First, "OptionalLimit", Grammar.Rule(DOT, Grammar.DropLexem, AS, Grammar.DropLexem, LEFTPAREN, Grammar.DropLexem, OptWhiteSpaces, Term, Grammar.SetType("ALIAS_NAME"), OptWhiteSpaces, RIGHTPAREN, Grammar.DropLexem), Grammar.Rule(Grammar.WhiteSpaces, AS, Grammar.DropLexem, Grammar.WhiteSpaces, Term, Grammar.SetType("ALIAS_NAME")), Grammar.emptyRule);
        SwitchRule switchRule18 = new SwitchRule(SwitchRule.First, "OptionalLimit", new GrammarRule[]{Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, LEFTBRACKET, Grammar.SetType("BRACKET"), OptWhiteSpaces, NUMBER, Grammar.SetType("LIMIT"), OptWhiteSpaces, RIGHTBRACKET, Grammar.SetType("BRACKET"), OptionalAlias}), OptionalAlias});
        SwitchRule switchRule19 = new SwitchRule("OptionalWhereClause1", new GrammarRule[0]);
        ArrayList arrayList = new ArrayList();
        optionalWhereBodyList.add(Grammar.Rule(new GrammarRule[]{DOT, Grammar.SetType("DOT"), WHERE, Grammar.MustMatchAction, OptWhiteSpaces, LEFTPAREN, OptWhiteSpaces, Query2, OptWhiteSpaces, RIGHTPAREN, Grammar.Semantic("EOF"), Grammar.Semantic("ENDWHERE"), OptionalWhereClause1}));
        optionalWhereBodyList.add(Grammar.emptyRule);
        OptionalWhereClause1.body = optionalWhereBodyList;
        SwitchRule switchRule20 = new SwitchRule("OptionalWhereAndLimit", new GrammarRule[]{Grammar.Rule(new GrammarRule[]{OptionalWhereClause1, OptionalLimit}), OptionalLimit});
        OptionalWhereAndLimit.optionalMode = true;
        FieldOrLinkName.body = Grammar.asRule(new GrammarRule[]{OptWhiteSpaces, FieldName, OptionalWhereAndLimit, FieldOrLinkNameContinue});
        SwitchRule switchRule21 = new SwitchRule(SwitchRule.First, "FieldSetContinue", Grammar.Rule(new GrammarRule[]{OptWhiteSpaces, COMMA, Grammar.SetType("COMMA"), Grammar.MustMatchAction, FieldSet2}), Grammar.Rule(Grammar.emptyRule));
        FieldSet2.body = Grammar.asRule(new GrammarRule[]{FieldOrLinkName, FieldSetContinue, OptWhiteSpaces});
        Keyword keyword = new Keyword("DESC", WORD);
        Keyword keyword2 = new Keyword("ASC", WORD);
        SwitchRule switchRule22 = new SwitchRule(SwitchRule.First, "SortOrderContinue", Grammar.Rule(new GrammarRule[]{SkipWhiteSpacesRule, DESC, Grammar.SetType("DESC")}), Grammar.Rule(new GrammarRule[]{SkipWhiteSpacesRule, ASC, Grammar.SetType("ASC")}), Grammar.Rule(OptWhiteSpaces, Grammar.emptyRule));
        SequenceRule sequenceRule10 = Grammar.Rule("SortOrder", new GrammarRule[]{AggregationFieldPath, SortOrderContinue});
        Hashtable hashtable = new Hashtable();
        result.put(SearchQueryGrammar, DoradusQuery);
        result.put(AggregationQueryGrammar, AggregationClause);
        result.put(AggregationMetricGrammar, AggregationMetricQueryList);
        result.put(StatisticMetricGrammar, AggregationMetricQuery);
        result.put(StatisticQueryGrammar, AggregationQueryList);
        result.put(StatisticParameterGrammar, StatisticParameter);
        result.put(FieldSetGrammar, FieldSet2);
        result.put(SortOrderGrammar, SortOrder2);
        result.put(SkipWhitespace, OptWhiteSpaces);
        result.put(SkipWhitespaceOptionRule, SkipWhiteSpacesRule);
        result.put(NotSkipWhitespaceOptionRule, Grammar.emptyRule);
        return result;
    }
}

