/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.parser.BuilderContext;
import com.dell.doradus.search.parser.LinkItem;
import com.dell.doradus.search.parser.ParseResult;
import com.dell.doradus.search.parser.Parser;
import com.dell.doradus.search.parser.QueryTreeVisitor;
import com.dell.doradus.search.parser.QueryVisitor;
import com.dell.doradus.search.parser.SearchQueryBuilder;
import com.dell.doradus.search.parser.TimeUtils;
import com.dell.doradus.search.parser.grammar.Context;
import com.dell.doradus.search.parser.grammar.GrammarItem;
import com.dell.doradus.search.parser.grammar.Literal;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.LinkCountQuery;
import com.dell.doradus.search.query.LinkIdQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.NoneQuery;
import com.dell.doradus.search.query.NotQuery;
import com.dell.doradus.search.query.OrQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.RangeQuery;
import com.dell.doradus.search.query.TransitiveLinkQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Stack;
import java.util.TimeZone;

public class DoradusQueryBuilder {
    public static void traverse(Query query, QueryVisitor visitor) {
        visitor.visit(query);
        if (query instanceof AndQuery) {
            AndQuery aq = (AndQuery)query;
            int i = 0;
            while (i < aq.subqueries.size()) {
                DoradusQueryBuilder.traverse(aq.subqueries.get(i), visitor);
                ++i;
            }
            return;
        }
        if (query instanceof BinaryQuery) {
            visitor.visit(query);
            return;
        }
        if (query instanceof LinkCountQuery) {
            visitor.visit(query);
            return;
        }
        if (query instanceof LinkIdQuery) {
            return;
        }
        if (query instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)query;
            visitor.visit(lq);
            DoradusQueryBuilder.traverse(lq.innerQuery, visitor);
            return;
        }
        if (query instanceof NoneQuery) {
            return;
        }
        if (query instanceof NotQuery) {
            NotQuery nq = (NotQuery)query;
            DoradusQueryBuilder.traverse(nq.innerQuery, visitor);
            return;
        }
        if (query instanceof OrQuery) {
            OrQuery aq = (OrQuery)query;
            int i = 0;
            while (i < aq.subqueries.size()) {
                visitor.visit(aq.subqueries.get(i));
                DoradusQueryBuilder.traverse(aq.subqueries.get(i), visitor);
                ++i;
            }
            return;
        }
        if (query instanceof RangeQuery) {
            visitor.visit(query);
            return;
        }
        if (query instanceof TransitiveLinkQuery) {
            TransitiveLinkQuery lq = (TransitiveLinkQuery)query;
            visitor.visit(lq);
            DoradusQueryBuilder.traverse(lq.innerQuery, visitor);
            return;
        }
        throw new IllegalArgumentException("Unknown type of query:" + query.getClass());
    }

    public static Query traverseTree(Stack<String> links, Query query, QueryTreeVisitor visitor) {
        if ((query = visitor.visit(links, query)) instanceof AndQuery) {
            AndQuery aq = (AndQuery)query;
            int i = 0;
            while (i < aq.subqueries.size()) {
                Query nextChild = aq.subqueries.get(i);
                nextChild = visitor.visit(links, nextChild);
                aq.subqueries.set(i, nextChild);
                DoradusQueryBuilder.traverseTree(links, nextChild, visitor);
                ++i;
            }
            return query;
        }
        if (query instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)query;
            links.push(lq.link);
            lq.innerQuery = DoradusQueryBuilder.traverseTree(links, lq.innerQuery, visitor);
            links.pop();
            return query;
        }
        if (query instanceof TransitiveLinkQuery) {
            TransitiveLinkQuery lq = (TransitiveLinkQuery)query;
            links.push(lq.link);
            lq.innerQuery = DoradusQueryBuilder.traverseTree(links, lq.innerQuery, visitor);
            links.pop();
            return query;
        }
        if (query instanceof NotQuery) {
            NotQuery nq = (NotQuery)query;
            nq.innerQuery = visitor.visit(links, nq.innerQuery);
            nq.innerQuery = DoradusQueryBuilder.traverseTree(links, nq.innerQuery, visitor);
            return query;
        }
        if (query instanceof OrQuery) {
            OrQuery aq = (OrQuery)query;
            int i = 0;
            while (i < aq.subqueries.size()) {
                Query nextChild = aq.subqueries.get(i);
                nextChild = visitor.visit(links, nextChild);
                aq.subqueries.set(i, nextChild);
                DoradusQueryBuilder.traverseTree(links, nextChild, visitor);
                ++i;
            }
            return query;
        }
        return query;
    }

    public static void pushGrammarItem(BuilderContext builderContext, GrammarItem item) {
        BinaryQuery bq = new BinaryQuery(BinaryQuery.CONTAINS, null, item.getValue());
        builderContext.queries.push(bq);
    }

    public static Query Build(ArrayList<GrammarItem> originalItems, TableDefinition definition) {
        ArrayList<LinkItem> items = DoradusQueryBuilder.extractTokens(originalItems);
        BuilderContext context = new BuilderContext();
        context.definition = definition;
        return SearchQueryBuilder.build(items, context);
    }

    public static Query Build(Context context) {
        return DoradusQueryBuilder.Build(context, null);
    }

    public static Query Build(Context context, TableDefinition definition) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot create query:Context is null");
        }
        if (context.items.isEmpty()) {
            return new NoneQuery();
        }
        return DoradusQueryBuilder.Build(context.items, definition);
    }

    public static Query Build(String string, TableDefinition definition) {
        string = definition.replaceAliaces(string);
        Parser parser = Parser.GetDoradusQueryParser();
        ParseResult result = parser.Parse(string);
        if (result.error == null) {
            return DoradusQueryBuilder.Build(result.context, definition);
        }
        throw new IllegalArgumentException(result.error);
    }

    public static ArrayList<GrammarItem> ParseFieldSet(String string) {
        Parser parser = Parser.GetFieldSetParser();
        ParseResult result = parser.Parse(string);
        if (result.error == null) {
            return result.context.items;
        }
        throw new IllegalArgumentException(result.error);
    }

    private static void AddLinkItem(ArrayList<LinkItem> grammarItems, GrammarItem item) {
        grammarItems.add(new LinkItem(item));
    }

    private static void MergeLastTwo(ArrayList<LinkItem> grammarItems) {
        LinkItem bi1 = grammarItems.remove(grammarItems.size() - 1);
        LinkItem bi2 = grammarItems.remove(grammarItems.size() - 1);
        if (bi2.item == null) {
            bi2.items.add(bi1);
            grammarItems.add(bi2);
            return;
        }
        if (bi2.item.getType().equals("token")) {
            grammarItems.add(bi2);
            grammarItems.add(bi1);
        } else {
            LinkItem bi3 = new LinkItem(null);
            bi3.items.add(bi2);
            bi3.items.add(bi1);
            grammarItems.add(bi3);
        }
    }

    private static void SetOperation(ArrayList<LinkItem> grammarItems, GrammarItem gi) {
        LinkItem bi1 = grammarItems.get(grammarItems.size() - 1);
        if (bi1.items.size() > 0) {
            bi1.items.get((int)(bi1.items.size() - 1)).transitive = gi.getValue();
        } else {
            bi1.transitive = gi.getValue();
        }
    }

    private static void SetValue(ArrayList<LinkItem> grammarItems, GrammarItem gi) {
        LinkItem bi1 = grammarItems.get(grammarItems.size() - 1);
        if (bi1.items.size() > 0) {
            bi1.items.get((int)(bi1.items.size() - 1)).value = gi;
        } else {
            bi1.value = gi;
        }
    }

    private static LinkItem DropItem(ArrayList<LinkItem> grammarItems, String value) {
        LinkItem bi = grammarItems.remove(grammarItems.size() - 1);
        if (!(value == null || bi.item != null && bi.item.getValue().equals(value))) {
            throw new IllegalArgumentException("Internal error: value does not match: " + value);
        }
        return bi;
    }

    private static LinkItem DropItem(ArrayList<LinkItem> grammarItems) {
        return DoradusQueryBuilder.DropItem(grammarItems, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static ArrayList<LinkItem> extractTokens(ArrayList<GrammarItem> grammarItems) {
        items = new ArrayList<LinkItem>();
        stack = new Stack<ArrayList<LinkItem>>();
        calendar = Calendar.getInstance();
        currentDate = calendar.getTimeInMillis();
        WHERE_SIBLING_START = false;
        i = 0;
        while (i < grammarItems.size()) {
            block52: {
                block68: {
                    block53: {
                        block67: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block62: {
                                                block61: {
                                                    block60: {
                                                        block59: {
                                                            block58: {
                                                                block57: {
                                                                    block56: {
                                                                        block55: {
                                                                            block54: {
                                                                                block51: {
                                                                                    grammarItem = grammarItems.get(i);
                                                                                    itemType = grammarItem.getType();
                                                                                    if (!itemType.equals("lexem") && !itemType.equals("string")) break block51;
                                                                                    DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                                                                                    break block52;
                                                                                }
                                                                                if (itemType.equals("ignore")) break block52;
                                                                                if (!itemType.equals("semantic")) break block53;
                                                                                if (!grammarItem.getValue().equals("ImpliedAnd")) break block54;
                                                                                DoradusQueryBuilder.AddLinkItem(items, new Literal("AND", "token", -1));
                                                                                break block52;
                                                                            }
                                                                            if (!grammarItem.getValue().equals("SearchCriteriaStart")) break block55;
                                                                            DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                                                                            break block52;
                                                                        }
                                                                        if (!grammarItem.getValue().equals("WHERE_FILTER_START")) break block56;
                                                                        stack.push(items);
                                                                        items = new ArrayList<E>();
                                                                        DoradusQueryBuilder.AddLinkItem(items, new Literal("ADDF", "token", -1));
                                                                        WHERE_SIBLING_START = true;
                                                                        break block52;
                                                                    }
                                                                    if (!grammarItem.getValue().equals("WHERE_FILTER_END")) break block57;
                                                                    DoradusQueryBuilder.AddLinkItem(items, new Literal(")", "token", -1));
                                                                    filter /* !! */  = items;
                                                                    items = (ArrayList)stack.pop();
                                                                    last = DoradusQueryBuilder.DropItem(items);
                                                                    items.add(last);
                                                                    if (last.item == null) {
                                                                        if (last.items.size() == 0) {
                                                                            throw new IllegalArgumentException("Internal error:empty filter");
                                                                        }
                                                                        last = last.items.get(last.items.size() - 1);
                                                                    }
                                                                    if (last.filters == null) {
                                                                        last.filters = new ArrayList<E>();
                                                                    }
                                                                    last.filters.add(filter /* !! */ );
                                                                    break block52;
                                                                }
                                                                if (!grammarItem.getValue().equals("WHERE_CONTINUE_START")) break block58;
                                                                DoradusQueryBuilder.AddLinkItem(items, new Literal("AND", "token", -1));
                                                                DoradusQueryBuilder.AddLinkItem(items, new Literal("(", "token", -1));
                                                                break block52;
                                                            }
                                                            if (!grammarItem.getValue().equals("WHERE_CONTINUE_END")) break block59;
                                                            DoradusQueryBuilder.AddLinkItem(items, new Literal(")", "token", -1));
                                                            DoradusQueryBuilder.AddLinkItem(items, new Literal(")", "token", -1));
                                                            break block52;
                                                        }
                                                        if (!grammarItem.getValue().equals("WHERE_SIBLING_START")) break block60;
                                                        DoradusQueryBuilder.AddLinkItem(items, new Literal("AND", "token", -1));
                                                        WHERE_SIBLING_START = true;
                                                        break block52;
                                                    }
                                                    if (!grammarItem.getValue().equals("WHERE_SIBLING_END")) break block61;
                                                    DoradusQueryBuilder.AddLinkItem(items, new Literal(")", "token", -1));
                                                    break block52;
                                                }
                                                if (!grammarItem.getValue().equals("ImpliedOr")) break block62;
                                                DoradusQueryBuilder.AddLinkItem(items, new Literal("OR", "token", -1));
                                                break block52;
                                            }
                                            if (!grammarItem.getValue().equals("transitiveValue")) break block63;
                                            DoradusQueryBuilder.DropItem(items, ")");
                                            bi = DoradusQueryBuilder.DropItem(items);
                                            DoradusQueryBuilder.DropItem(items, "(");
                                            DoradusQueryBuilder.SetValue(items, bi.item);
                                            break block52;
                                        }
                                        if (!grammarItem.getValue().equals("dotSemantic")) break block64;
                                        DoradusQueryBuilder.MergeLastTwo(items);
                                        break block52;
                                    }
                                    if (!grammarItem.getValue().equals("linkFunctionEndSemantic")) break block65;
                                    DoradusQueryBuilder.DropItem(items, ")");
                                    bi = DoradusQueryBuilder.DropItem(items);
                                    DoradusQueryBuilder.DropItem(items, "(");
                                    function = DoradusQueryBuilder.DropItem(items);
                                    function.operation = function.item.getValue();
                                    function.item = null;
                                    function.items.add(bi);
                                    if (function.operation.equals("ALL") || function.operation.equals("ANY") || function.operation.equals("NONE")) {
                                        bi.operation = function.operation;
                                        k = 0;
                                        while (k < bi.items.size()) {
                                            next = bi.items.get(k);
                                            next.operation = function.operation;
                                            ++k;
                                        }
                                    }
                                    items.add(function);
                                    break block52;
                                }
                                if (!grammarItem.getValue().equals("CalculateNow")) break block66;
                                last = DoradusQueryBuilder.DropItem(items);
                                type = last.item.getType();
                                value = last.item.getValue();
                                timezone = "UTC";
                                timezoneValue = null;
                                units = null;
                                intvalue = null;
                                while (!type.equals("Now")) {
                                    if (type.equals("NowUnits")) {
                                        units = value;
                                    }
                                    if (type.equals("PositiveNumber")) {
                                        try {
                                            intvalue = Integer.parseInt(value);
                                        }
                                        catch (Exception e) {
                                            throw new IllegalArgumentException("Bad now offset units  value: " + value);
                                        }
                                    }
                                    if (type.equals("NegativeNumber")) {
                                        try {
                                            intvalue = Integer.parseInt("-" + value);
                                        }
                                        catch (Exception e) {
                                            throw new IllegalArgumentException("Bad now offset units  value: -" + value);
                                        }
                                    }
                                    if (type.equals("TimeZoneValue")) {
                                        timezoneValue = value;
                                    }
                                    if (type.equals("TimeZoneDisplayName")) {
                                        timezone = value;
                                    }
                                    last = DoradusQueryBuilder.DropItem(items);
                                    type = last.item.getType();
                                    value = last.item.getValue();
                                }
                                calendar = timezoneValue != null ? TimeUtils.getCalendarByValue(timezoneValue) : TimeUtils.getCalendarByName(timezone);
                                calendar.setTimeInMillis(currentDate);
                                start = TimeUtils.getNowValue(calendar, units, intvalue);
                                DoradusQueryBuilder.AddLinkItem(items, new Literal(TimeUtils.toUtcTime(start), "string", -1));
                                break block52;
                            }
                            if (!grammarItem.getValue().equals("CalculatePeriod")) break block67;
                            last = DoradusQueryBuilder.DropItem(items);
                            value = last.item.getType();
                            units = last.item.getValue();
                            if (value.equals("LastPeriodValue")) {
                                value = last.item.getValue();
                                units = DoradusQueryBuilder.DropItem((ArrayList<LinkItem>)items).item.getValue();
                            } else {
                                value = null;
                            }
                            start = TimeUtils.getPeriodStart(calendar, units, value);
                            end = TimeUtils.getPeriodEnd(calendar, units);
                            DoradusQueryBuilder.AddLinkItem(items, new Literal("[", "token", -1));
                            DoradusQueryBuilder.AddLinkItem(items, new Literal(TimeUtils.toUtcTime(start), "string", -1));
                            DoradusQueryBuilder.AddLinkItem(items, new Literal("TO", "token", -1));
                            DoradusQueryBuilder.AddLinkItem(items, new Literal(TimeUtils.toUtcTime(end), "string", -1));
                            if (TimeUtils.isThisUnit(units)) {
                                DoradusQueryBuilder.AddLinkItem(items, new Literal("}", "token", -1));
                            } else {
                                DoradusQueryBuilder.AddLinkItem(items, new Literal("]", "token", -1));
                            }
                            break block52;
                        }
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    }
                    if (!itemType.equals("token")) ** GOTO lbl192
                    notProcess = true;
                    if (grammarItem.getValue().equals(",")) {
                        DoradusQueryBuilder.AddLinkItem(items, new Literal("OR", "token", -1));
                        notProcess = false;
                    }
                    if (grammarItem.getValue().equals("-")) {
                        DoradusQueryBuilder.AddLinkItem(items, new Literal("NOT", "token", -1));
                        notProcess = false;
                    }
                    if (!grammarItem.getValue().equals("^")) break block68;
                    DoradusQueryBuilder.SetOperation(items, grammarItem);
                    break block52;
                }
                if (grammarItem.getValue().equals(".")) break block52;
                if (grammarItem.getValue().equals("IS")) {
                    DoradusQueryBuilder.AddLinkItem(items, new Literal("NULL", "token", -1));
                } else if (grammarItem.getValue().equals("NULL")) {
                    DoradusQueryBuilder.AddLinkItem(items, new Literal("*", "lexem", -1));
                } else if (grammarItem.getValue().equals("WHERE") && WHERE_SIBLING_START) {
                    WHERE_SIBLING_START = false;
                } else {
                    if (notProcess) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    }
lbl192:
                    // 4 sources

                    if (itemType.equals("PeriodGMT")) {
                        calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        calendar.setTimeInMillis(currentDate);
                    } else if (itemType.equals("TimeZoneDisplayName")) {
                        calendar = TimeUtils.getCalendarByName(grammarItem.getValue());
                        calendar.setTimeInMillis(currentDate);
                    } else if (itemType.equals("TimeZoneValue")) {
                        calendar = TimeUtils.getCalendarByValue(grammarItem.getValue());
                        calendar.setTimeInMillis(currentDate);
                    } else if (itemType.equals("ThisPeriodUnits")) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    } else if (itemType.equals("LastPeriodUnits")) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    } else if (itemType.equals("LastPeriodValue")) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    } else if (itemType.equals("Now")) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    } else if (itemType.equals("PositiveNumber")) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    } else if (itemType.equals("NegativeNumber")) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    } else if (itemType.equals("NowUnits")) {
                        DoradusQueryBuilder.AddLinkItem(items, grammarItem);
                    }
                }
            }
            ++i;
        }
        return items;
    }
}

