/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.aggregate.AggregationMetric;
import com.dell.doradus.search.aggregate.BinaryExpression;
import com.dell.doradus.search.aggregate.LinkInfo;
import com.dell.doradus.search.aggregate.LongIntegerExpression;
import com.dell.doradus.search.aggregate.MetricExpression;
import com.dell.doradus.search.aggregate.NumberExpression;
import com.dell.doradus.search.aggregate.SortOrder;
import com.dell.doradus.search.parser.DoradusQueryBuilder;
import com.dell.doradus.search.parser.Item;
import com.dell.doradus.search.parser.ParseResult;
import com.dell.doradus.search.parser.Parser;
import com.dell.doradus.search.parser.QueryUtils;
import com.dell.doradus.search.parser.TimeUtils;
import com.dell.doradus.search.parser.grammar.Context;
import com.dell.doradus.search.parser.grammar.GrammarItem;
import com.dell.doradus.search.parser.grammar.Literal;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.OrQuery;
import com.dell.doradus.search.query.Query;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TimeZone;

public class AggregationQueryBuilder {
    static HashSet<String> availableTimeZones;

    public static AggregationMetric BuildStatisticMetric(String string, TableDefinition definition) {
        string = definition.replaceAliaces(string);
        Parser parser = Parser.GetStatisticMetricParser();
        ParseResult res1 = parser.Parse(string);
        if (res1.error == null) {
            ArrayList<AggregationMetric> metric = AggregationQueryBuilder.BuildMetrics(res1.context, definition);
            return metric.get(0);
        }
        throw new IllegalArgumentException(res1.error);
    }

    public static List<AggregationGroup> BuildStatistic(String string, TableDefinition definition) {
        List<AggregationGroup> group = AggregationQueryBuilder.Build(string, definition);
        return group;
    }

    public static AggregationMetric BuildAggregationMetric(String string, TableDefinition definition) {
        ArrayList<AggregationMetric> metrics = AggregationQueryBuilder.BuildAggregationMetrics(string, definition);
        return metrics.get(0);
    }

    public static ArrayList<AggregationMetric> BuildAggregationMetrics(String string, TableDefinition definition) {
        string = definition.replaceAliaces(string);
        Parser parser = Parser.GetAggregationMetricParser();
        ParseResult res1 = parser.Parse(string);
        if (res1.error == null) {
            ArrayList<AggregationMetric> metric = AggregationQueryBuilder.BuildMetrics(res1.context, definition);
            return metric;
        }
        throw new IllegalArgumentException(res1.error);
    }

    public static ArrayList<MetricExpression> BuildAggregationMetricsExpression(String string, TableDefinition definition) {
        string = definition.replaceAliaces(string);
        Parser parser = Parser.GetAggregationMetricParser();
        ParseResult res1 = parser.Parse(string);
        if (res1.error == null) {
            return AggregationQueryBuilder.BuildMetricsExpression(res1.context, definition);
        }
        throw new IllegalArgumentException(res1.error);
    }

    public static SortOrder[] BuildSortOrders(String string, TableDefinition definition) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        List strings = Utils.split((String)string, (char)',');
        SortOrder[] orders = new SortOrder[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            orders[i] = AggregationQueryBuilder.BuildSortOrder((String)strings.get(i), definition);
        }
        return orders;
    }

    public static SortOrder BuildSortOrder(String string, TableDefinition definition) {
        string = definition.replaceAliaces(string);
        Parser parser = Parser.GetSortOrderParser();
        ParseResult res1 = parser.Parse(string);
        if (res1.error == null) {
            SortOrder order = AggregationQueryBuilder.BuildSort(res1.context, definition);
            return order;
        }
        throw new IllegalArgumentException(res1.error);
    }

    public static List<AggregationGroup> Build(String string, TableDefinition definition) {
        string = definition.replaceAliaces(string);
        Parser parser = Parser.GetAggregationQueryParser();
        ParseResult res1 = parser.Parse(string);
        if (res1.error == null) {
            List<AggregationGroup> group = AggregationQueryBuilder.Build(res1.context, definition);
            return group;
        }
        throw new IllegalArgumentException(res1.error);
    }

    public static ArrayList<ArrayList<AggregationGroup>> BuildAggregation(String string, TableDefinition definition) {
        string = definition.replaceAliaces(string);
        Parser parser = Parser.GetAggregationQueryParser();
        ParseResult res1 = parser.Parse(string);
        if (res1.error == null) {
            ArrayList<ArrayList<AggregationGroup>> group = AggregationQueryBuilder.BuildAg(res1.context, definition);
            return group;
        }
        throw new IllegalArgumentException(res1.error);
    }

    private static ArrayList<AggregationMetric> BuildMetrics(Context context, TableDefinition definition) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot create query:Context is null");
        }
        if (context.items.isEmpty()) {
            return null;
        }
        ArrayList<AggregationMetric> result = new ArrayList<AggregationMetric>();
        AggregationMetric metric = new AggregationMetric(definition);
        ArrayList<Item> items = AggregationQueryBuilder.extractTokens(context);
        TableDefinition tableDef = definition;
        boolean fieldDetected = false;
        int ptr = 0;
        int inputPtr = 0;
        for (int i = 0; i < items.size(); ++i) {
            Item item = items.get(i);
            if (item.item.getType().equals("AggregationMetricFunctionName")) {
                ptr = item.item.getPtr();
                metric.function = item.item.getValue();
                continue;
            }
            if (item.item.getType().equals("InputPointer")) {
                inputPtr = item.item.getPtr();
                continue;
            }
            if (item.item.getType().equals("token") && item.item.getValue().equals(",")) {
                result.add(metric);
                tableDef = definition;
                fieldDetected = false;
                metric.sourceText = context.inputString.substring(ptr, inputPtr);
                metric = new AggregationMetric(definition);
                continue;
            }
            if (fieldDetected) {
                throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(metric.items));
            }
            AggregationGroupItem ai = new AggregationGroupItem();
            if (metric.items == null) {
                metric.items = new ArrayList<AggregationGroupItem>();
            }
            metric.items.add(ai);
            ai.name = item.item.getValue();
            if (tableDef != null) {
                FieldDefinition fd;
                ai.fieldDef = fd = tableDef.getFieldDef(ai.name);
                if (fd == null) {
                    if (i != items.size() - 1) {
                        throw new IllegalArgumentException(" Undefined Link " + QueryUtils.FullLinkName(metric.items));
                    }
                    if (!QueryUtils.isSystemField(ai.name)) {
                        throw new IllegalArgumentException("Unknown system field " + ai.name);
                    }
                }
                if (tableDef.isLinkField(ai.name) || fd != null && fd.isXLinkField()) {
                    ai.isLink = true;
                    if (fieldDetected) {
                        throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(metric.items));
                    }
                    if ((tableDef = tableDef.getLinkExtentTableDef(fd)) == null) {
                        throw new IllegalArgumentException(" Cannot get table definition for link " + QueryUtils.FullLinkName(metric.items));
                    }
                } else {
                    if (fd != null && fd.getType() == FieldType.GROUP) {
                        throw new IllegalArgumentException("Group fields are not allowed in metrics");
                    }
                    fieldDetected = true;
                }
                ai.tableDef = tableDef;
            }
            if (item.queryItems == null) continue;
            for (int j = 0; j < item.queryItems.size(); ++j) {
                ArrayList<GrammarItem> filterItems = item.queryItems.get(j);
                ai.query = AggregationQueryBuilder.CompileQuery(tableDef, ai.query, filterItems);
            }
        }
        metric.sourceText = context.inputString.substring(ptr);
        result.add(metric);
        return result;
    }

    private static void doOperation(String op1, Stack<MetricExpression> expressions, Stack<String> operations) {
        BinaryExpression me;
        if (op1.equals("+")) {
            me = new BinaryExpression();
            me.second = expressions.pop();
            me.first = expressions.pop();
            me.operation = BinaryExpression.MetricOperation.PLUS;
            expressions.push(me);
        }
        if (op1.equals("-")) {
            me = new BinaryExpression();
            me.second = expressions.pop();
            me.first = expressions.pop();
            me.operation = BinaryExpression.MetricOperation.MINUS;
            expressions.push(me);
        }
        if (op1.equals("*")) {
            me = new BinaryExpression();
            me.second = expressions.pop();
            me.first = expressions.pop();
            me.operation = BinaryExpression.MetricOperation.MULTIPLAY;
            expressions.push(me);
        }
        if (op1.equals("/")) {
            me = new BinaryExpression();
            me.second = expressions.pop();
            me.first = expressions.pop();
            me.operation = BinaryExpression.MetricOperation.DIVIDE;
            expressions.push(me);
        }
    }

    private static void pushOp(String operation, Stack<MetricExpression> expressions, Stack<String> operations) {
        String op1;
        if (operation.equals("(")) {
            operations.push(operation);
            return;
        }
        if (operation.equals(")")) {
            while (!operations.isEmpty()) {
                String op = operations.pop();
                if (op.equals("(")) {
                    return;
                }
                AggregationQueryBuilder.doOperation(op, expressions, operations);
            }
        }
        if (operation.equals("*") || operation.equals("/")) {
            if (operations.isEmpty()) {
                operations.push(operation);
            } else {
                op1 = operations.peek();
                if (!op1.equals("(")) {
                    if (op1.equals("+") || op1.equals("-")) {
                        operations.push(operation);
                    } else {
                        AggregationQueryBuilder.doOperation(operations.pop(), expressions, operations);
                        operations.push(operation);
                    }
                } else {
                    operations.push(operation);
                }
            }
        }
        if (operation.equals("+") || operation.equals("-")) {
            if (operations.isEmpty()) {
                operations.push(operation);
            } else {
                op1 = operations.peek();
                if (!op1.equals("(")) {
                    AggregationQueryBuilder.doOperation(operations.pop(), expressions, operations);
                }
                operations.push(operation);
            }
        }
    }

    private static Item DropItem(ArrayList<Item> grammarItems) {
        return grammarItems.remove(grammarItems.size() - 1);
    }

    private static ArrayList<MetricExpression> BuildMetricsExpression(Context context, TableDefinition definition) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot create query:Context is null");
        }
        if (context.items.isEmpty()) {
            return null;
        }
        AggregationMetric metric = new AggregationMetric(definition);
        ArrayList<Item> items = AggregationQueryBuilder.extractMetricTokens(context);
        TableDefinition tableDef = definition;
        boolean fieldDetected = false;
        int ptr = 0;
        int endMetricPtr = 0;
        ArrayList<MetricExpression> resultList = new ArrayList<MetricExpression>();
        Stack<MetricExpression> expressions = new Stack<MetricExpression>();
        Stack<String> operations = new Stack<String>();
        for (int i = 0; i < items.size(); ++i) {
            ArrayList<GrammarItem> filterItems;
            Item item = items.get(i);
            if (item.item.getType().equals("op")) {
                AggregationQueryBuilder.pushOp(item.item.getValue(), expressions, operations);
                continue;
            }
            if (item.item.getType().equals("datediff")) {
                operations.push(item.item.getValue());
                continue;
            }
            if (item.item.getType().equals("semantic") && item.item.getValue().equals("datediff_calc")) {
                GregorianCalendar c2;
                GregorianCalendar c1;
                String unit2 = operations.pop();
                String unit1 = operations.pop();
                String unit = operations.pop();
                try {
                    c1 = Utils.parseDate((String)unit1);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Bad date time format:" + unit1);
                }
                try {
                    c2 = Utils.parseDate((String)unit2);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Bad date time format:" + unit2);
                }
                LongIntegerExpression le = new LongIntegerExpression();
                le.value = TimeUtils.getTimeDifference(unit, c1, c2);
                expressions.push(le);
                metric = null;
                continue;
            }
            if (item.item.getType().equals("InputPointer")) {
                endMetricPtr = item.item.getPtr();
                continue;
            }
            if (item.item.getType().equals("number")) {
                NumberExpression ne = new NumberExpression();
                try {
                    ne.value = Double.parseDouble(item.item.getValue());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot convert '" + item.item.getValue() + "' to double");
                }
                expressions.push(ne);
                metric = null;
                continue;
            }
            if (item.item.getType().equals("MetricFunctionBinary")) {
                metric.metricFunction = item.item.getValue();
                continue;
            }
            if (item.item.getType().equals("MetricFunctionParameter")) {
                if (metric.metricFunctionParameters == null) {
                    metric.metricFunctionParameters = new ArrayList<String>();
                }
                metric.metricFunctionParameters.add(item.item.getValue());
                continue;
            }
            if (item.item.getType().equals("transitiveValue") || item.item.getType().equals("transitive")) {
                AggregationGroupItem agItem = metric.items.get(metric.items.size() - 1);
                if (item.item.getType().equals("transitiveValue")) {
                    agItem.transitiveDepth = Integer.parseInt(item.item.getValue());
                } else {
                    agItem.isTransitive = true;
                }
                if (item.queryItems == null) continue;
                for (int j = 0; j < item.queryItems.size(); ++j) {
                    filterItems = item.queryItems.get(j);
                    agItem.query = AggregationQueryBuilder.CompileQuery(tableDef, agItem.query, filterItems);
                }
                continue;
            }
            if (item.item.getType().equals("AggregationMetricFunctionName")) {
                ptr = item.item.getPtr();
                metric.function = item.item.getValue();
                if (item.queryItems == null) continue;
                for (int j = 0; j < item.queryItems.size(); ++j) {
                    ArrayList<GrammarItem> filterItems2 = item.queryItems.get(j);
                    metric.filter = AggregationQueryBuilder.CompileQuery(tableDef, metric.filter, filterItems2);
                }
                continue;
            }
            if (item.item.getType().equals("semantic") && item.item.getValue().equals("endMetric")) {
                if (metric != null) {
                    expressions.push(metric);
                    metric.sourceText = context.inputString.substring(ptr, endMetricPtr);
                }
                tableDef = definition;
                fieldDetected = false;
                metric = new AggregationMetric(definition);
                continue;
            }
            if (item.item.getType().equals("TruncateSubfieldValue")) {
                metric.subField = AggregationGroup.SubField.valueOf(item.item.getValue());
                continue;
            }
            if (item.item.getType().equals("token") && item.item.getValue().equals(",")) {
                while (!operations.isEmpty()) {
                    AggregationQueryBuilder.doOperation(operations.pop(), expressions, operations);
                }
                MetricExpression me = expressions.pop();
                if (!expressions.isEmpty()) {
                    throw new IllegalArgumentException("Bad expression");
                }
                resultList.add(me);
                tableDef = definition;
                fieldDetected = false;
                metric = new AggregationMetric(definition);
                continue;
            }
            if (fieldDetected) {
                throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(metric.items));
            }
            AggregationGroupItem ai = new AggregationGroupItem();
            if (metric.items == null) {
                metric.items = new ArrayList<AggregationGroupItem>();
            }
            metric.items.add(ai);
            ai.name = item.item.getValue();
            if (tableDef != null) {
                FieldDefinition fd;
                ai.fieldDef = fd = tableDef.getFieldDef(ai.name);
                if (fd == null) {
                    if (i != items.size() - 1) {
                        throw new IllegalArgumentException(" Undefined Link " + QueryUtils.FullLinkName(metric.items));
                    }
                    if (!QueryUtils.isSystemField(ai.name)) {
                        throw new IllegalArgumentException("Unknown system field " + ai.name);
                    }
                }
                if (tableDef.isLinkField(ai.name) || fd != null && fd.isXLinkField()) {
                    ai.isLink = true;
                    if (fieldDetected) {
                        throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(metric.items));
                    }
                    if ((tableDef = tableDef.getLinkExtentTableDef(fd)) == null) {
                        throw new IllegalArgumentException(" Cannot get table definition for link " + QueryUtils.FullLinkName(metric.items));
                    }
                } else {
                    if (fd != null && fd.getType() == FieldType.GROUP) {
                        throw new IllegalArgumentException("Group fields are not allowed in metrics");
                    }
                    fieldDetected = true;
                }
                ai.tableDef = tableDef;
            }
            if (item.queryItems == null) continue;
            if (ai.isLink) {
                for (int j = 0; j < item.queryItems.size(); ++j) {
                    filterItems = item.queryItems.get(j);
                    ai.query = AggregationQueryBuilder.CompileQuery(tableDef, ai.query, filterItems);
                }
                continue;
            }
            throw new IllegalArgumentException(ai.name + " is not a link name. Filters are supported for links");
        }
        while (!operations.isEmpty()) {
            AggregationQueryBuilder.doOperation((String)operations.pop(), expressions, operations);
        }
        MetricExpression me = (MetricExpression)expressions.pop();
        if (!expressions.isEmpty()) {
            throw new IllegalArgumentException("Bad expression");
        }
        resultList.add(me);
        return resultList;
    }

    public static Query CompileQuery(TableDefinition tableDef, Query query, ArrayList<GrammarItem> filterItems) {
        Query filter = DoradusQueryBuilder.Build(filterItems, tableDef);
        if (query == null) {
            return filter;
        }
        if (!(query instanceof AndQuery)) {
            AndQuery andq = new AndQuery();
            andq.subqueries.add(query);
            andq.subqueries.add(filter);
            return andq;
        }
        AndQuery andq = (AndQuery)query;
        andq.subqueries.add(filter);
        return andq;
    }

    private static SortOrder BuildSort(Context context, TableDefinition definition) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot create query:Context is null");
        }
        if (context.items.isEmpty()) {
            return null;
        }
        SortOrder result = new SortOrder();
        result.tableDef = definition;
        ArrayList<Item> items = AggregationQueryBuilder.extractTokens(context);
        TableDefinition tableDef = definition;
        boolean fieldDetected = false;
        for (int i = 0; i < items.size(); ++i) {
            FieldDefinition fd;
            Item item = items.get(i);
            if (item.item.getType().equals("DESC")) {
                result.ascending = false;
                continue;
            }
            if (item.item.getType().equals("ASC")) {
                result.ascending = true;
                continue;
            }
            if (fieldDetected) {
                throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(result.items));
            }
            AggregationGroupItem ai = new AggregationGroupItem();
            if (result.items == null) {
                result.items = new ArrayList<AggregationGroupItem>();
            }
            result.items.add(ai);
            ai.name = item.item.getValue();
            if (tableDef == null) continue;
            ai.fieldDef = fd = tableDef.getFieldDef(ai.name);
            if (fd == null) {
                if (i != items.size() - 1) {
                    throw new IllegalArgumentException(" Undefined Link " + QueryUtils.FullLinkName(result.items));
                }
                if (!QueryUtils.isSystemField(ai.name)) {
                    throw new IllegalArgumentException("Unknown field " + ai.name);
                }
            }
            if (tableDef.isLinkField(ai.name) || fd != null && fd.isXLinkField()) {
                ai.isLink = true;
                if (fieldDetected) {
                    throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(result.items));
                }
                if ((tableDef = tableDef.getLinkExtentTableDef(fd)) == null) {
                    throw new IllegalArgumentException(" Cannot get table definition for link " + QueryUtils.FullLinkName(result.items));
                }
            } else {
                if (fd != null && fd.getType() == FieldType.GROUP) {
                    throw new IllegalArgumentException("Group fields are not allowed in sort order");
                }
                fieldDetected = true;
            }
            ai.tableDef = tableDef;
        }
        if (!fieldDetected) {
            throw new IllegalArgumentException("Sort field must be scalar field");
        }
        return result;
    }

    private static ArrayList<ArrayList<AggregationGroup>> BuildAg(Context context, TableDefinition definition) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot create query:Context is null");
        }
        if (context.items.isEmpty()) {
            return null;
        }
        ArrayList<ArrayList<AggregationGroup>> resultList = new ArrayList<ArrayList<AggregationGroup>>();
        ArrayList<ArrayList<Item>> groups = AggregationQueryBuilder.extractAgTokens(context);
        for (int j = 0; j < groups.size(); ++j) {
            ArrayList<Item> items = groups.get(j);
            ArrayList<AggregationGroup> result = AggregationQueryBuilder.processItems(context, definition, items);
            resultList.add(result);
        }
        return resultList;
    }

    private static List<AggregationGroup> Build(Context context, TableDefinition definition) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot create query:Context is null");
        }
        if (context.items.isEmpty()) {
            return null;
        }
        return AggregationQueryBuilder.processItems(context, definition, AggregationQueryBuilder.extractTokens(context));
    }

    private static ArrayList<AggregationGroup> processItems(Context context, TableDefinition definition, ArrayList<Item> items) {
        AggregationGroup group;
        int i;
        AggregationGroup aggregationGroup = new AggregationGroup(definition);
        TableDefinition tableDef = definition;
        boolean fieldDetected = false;
        ArrayList<AggregationGroup> result = new ArrayList<AggregationGroup>();
        int startPos = -1;
        int lastPos = -1;
        boolean includeList = false;
        for (i = 0; i < items.size(); ++i) {
            GrammarItem last;
            ArrayList<GrammarItem> filterItems;
            Item item = items.get(i);
            if (item.item.getPtr() != -1) {
                lastPos = item.item.getPtr() + item.item.getValue().length();
            }
            if (startPos == -1) {
                startPos = item.item.getPtr();
            }
            if (item.item.getType().equals("ignore")) {
                AggregationQueryBuilder.SetFilter(aggregationGroup, tableDef, item);
                continue;
            }
            if (item.item.getType().equals("global")) {
                AggregationQueryBuilder.SetFilter(aggregationGroup, tableDef, item);
                continue;
            }
            if (item.item.getType().equals("endGroup")) {
                lastPos = item.item.getPtr();
                if (aggregationGroup.items == null) continue;
                result.add(aggregationGroup);
                aggregationGroup.text = context.inputString.substring(startPos, item.item.getPtr());
                startPos = item.item.getPtr() + item.item.getValue().length();
                aggregationGroup = new AggregationGroup(definition);
                tableDef = definition;
                fieldDetected = false;
                continue;
            }
            if (item.item.getValue().equals(",")) {
                result.add(aggregationGroup);
                aggregationGroup.text = context.inputString.substring(startPos, item.item.getPtr());
                startPos = item.item.getPtr() + item.item.getValue().length();
                aggregationGroup = new AggregationGroup(definition);
                AggregationQueryBuilder.SetFilter(aggregationGroup, tableDef, item);
                tableDef = definition;
                fieldDetected = false;
                continue;
            }
            String type = item.item.getType();
            if (type.equals("TruncateValue")) {
                aggregationGroup.truncate = item.item.getValue();
                continue;
            }
            if (type.equals("TruncateSubfieldValue")) {
                aggregationGroup.subField = AggregationGroup.SubField.valueOf(item.item.getValue());
                continue;
            }
            if (type.equals("TimeZoneValue")) {
                aggregationGroup.timeZone = item.item.getValue().trim();
                char ch = aggregationGroup.timeZone.charAt(0);
                if (ch == '+' || ch == '-') {
                    aggregationGroup.timeZone = "GMT" + aggregationGroup.timeZone;
                } else if (Character.getType(ch) == 9) {
                    aggregationGroup.timeZone = "GMT+" + aggregationGroup.timeZone;
                }
                String prefix = aggregationGroup.timeZone.substring(0, 4);
                String val = aggregationGroup.timeZone.substring(4);
                switch (val.length()) {
                    case 1: {
                        aggregationGroup.timeZone = prefix + "0" + val + ":00";
                        break;
                    }
                    case 2: {
                        aggregationGroup.timeZone = prefix + val + ":00";
                        break;
                    }
                    case 3: {
                        aggregationGroup.timeZone = prefix + "0" + val.substring(0, 1) + ":" + val.substring(1);
                        break;
                    }
                    case 4: {
                        if (val.charAt(1) == ':') {
                            aggregationGroup.timeZone = prefix + "0" + val;
                            break;
                        }
                        aggregationGroup.timeZone = prefix + val.substring(0, 2) + ":" + val.substring(2);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Internal error: bad timezone(1)");
                    }
                }
                TimeZone zone = TimeZone.getTimeZone(aggregationGroup.timeZone);
                String id = zone.getID();
                if (id.compareTo(aggregationGroup.timeZone) == 0) continue;
                throw new IllegalArgumentException("Bad timezone value: '" + aggregationGroup.timeZone + "'");
            }
            if (type.equals("TimeZoneDisplayName")) {
                aggregationGroup.timeZone = item.item.getValue();
                if (AggregationQueryBuilder.isCorrectTimeZone(aggregationGroup.timeZone)) continue;
                throw new IllegalArgumentException("Unknown timezone: '" + aggregationGroup.timeZone + "'");
            }
            if (type.equals("GROUP")) continue;
            if (type.equals("BatchValue")) {
                if (aggregationGroup.batch == null) {
                    aggregationGroup.batch = new ArrayList<Object>();
                }
                aggregationGroup.batch.add(item.item.getValue());
                continue;
            }
            if (type.equals("topbottomvalue")) {
                aggregationGroup.selectionValue = Integer.parseInt(item.item.getValue());
                continue;
            }
            if (type.equals("UPPER")) {
                aggregationGroup.tocase = "UPPER";
                continue;
            }
            if (type.equals("LOWER")) {
                aggregationGroup.tocase = "LOWER";
                continue;
            }
            if (type.equals("TRUNCATE") || type.equals("BATCH")) {
                AggregationQueryBuilder.SetFilter(aggregationGroup, tableDef, item);
                continue;
            }
            if (type.equals("SETS")) {
                Query q = DoradusQueryBuilder.Build(item.queryItems.get(0), tableDef);
                String alias = item.item.getValue();
                if ("".equals(alias)) {
                    alias = q.toString();
                }
                if (aggregationGroup.batchexAliases == null) {
                    aggregationGroup.batchexAliases = new ArrayList<String>();
                    aggregationGroup.batchexFilters = new ArrayList<Query>();
                }
                if (aggregationGroup.items == null) {
                    aggregationGroup.items = new ArrayList<AggregationGroupItem>();
                }
                aggregationGroup.batchexAliases.add(alias);
                aggregationGroup.batchexFilters.add(q);
                continue;
            }
            if (type.equals("TERMS")) continue;
            if (type.equals("ExcludeList")) {
                includeList = false;
                continue;
            }
            if (type.equals("IncludeList")) {
                includeList = true;
                continue;
            }
            if (type.equals("EXCLUDE")) continue;
            if (type.equals("stopValueAny")) {
                if (aggregationGroup.stopWords == null) {
                    aggregationGroup.stopWords = new ArrayList<String>();
                    continue;
                }
                throw new IllegalArgumentException("Internal error, stopwords list is already defined");
            }
            if (type.equals("stopValue")) {
                if (aggregationGroup.stopWords == null) {
                    aggregationGroup.stopWords = new ArrayList<String>();
                }
                aggregationGroup.stopWords.add(item.item.getValue());
                continue;
            }
            if (type.equals("excludeValue")) {
                String value = item.item.getValue();
                if ("NULL".equals(value)) {
                    value = null;
                }
                if (includeList) {
                    if (aggregationGroup.include == null) {
                        aggregationGroup.include = new ArrayList<String>();
                    }
                    aggregationGroup.include.add(value);
                    continue;
                }
                if (aggregationGroup.exclude == null) {
                    aggregationGroup.exclude = new ArrayList<String>();
                }
                aggregationGroup.exclude.add(value);
                continue;
            }
            if (type.equals("alias")) {
                aggregationGroup.name = item.item.getValue();
                continue;
            }
            if (item.item.getValue().equals(")")) continue;
            if (type.equals("topbottom")) {
                if (item.item.getValue().equals("TOP")) {
                    aggregationGroup.selection = AggregationGroup.Selection.Top;
                } else if (item.item.getValue().equals("BOTTOM")) {
                    aggregationGroup.selection = AggregationGroup.Selection.Bottom;
                } else if (item.item.getValue().equals("FIRST")) {
                    aggregationGroup.selection = AggregationGroup.Selection.First;
                } else if (item.item.getValue().equals("LAST")) {
                    aggregationGroup.selection = AggregationGroup.Selection.Last;
                } else {
                    throw new RuntimeException("TOP/BOTTOM/FIRST/LAST allowed");
                }
                AggregationQueryBuilder.SetFilter(aggregationGroup, tableDef, item);
                continue;
            }
            if (type.equals("transitiveValue") || type.equals("transitive")) {
                AggregationGroupItem agItem = aggregationGroup.items.get(aggregationGroup.items.size() - 1);
                if (type.equals("transitiveValue")) {
                    agItem.transitiveDepth = Integer.parseInt(item.item.getValue());
                } else {
                    agItem.isTransitive = true;
                }
                if (item.queryItems == null) continue;
                for (int j = 0; j < item.queryItems.size(); ++j) {
                    filterItems = item.queryItems.get(j);
                    agItem.query = AggregationQueryBuilder.CompileQuery(tableDef, agItem.query, filterItems);
                    last = filterItems.get(filterItems.size() - 2);
                    lastPos = last.getPtr() + last.getValue().length();
                }
                continue;
            }
            AggregationGroupItem ai = new AggregationGroupItem();
            if (aggregationGroup.items == null) {
                aggregationGroup.items = new ArrayList<AggregationGroupItem>();
            }
            aggregationGroup.items.add(ai);
            ai.name = item.item.getValue();
            if (tableDef != null) {
                FieldDefinition fd = tableDef.getFieldDef(ai.name);
                if ("_ID".equals(ai.name)) {
                    fd = new FieldDefinition(tableDef);
                    ai.isID = true;
                }
                ai.fieldDef = fd;
                if (fd == null) {
                    throw new IllegalArgumentException(" Undefined field: " + QueryUtils.FullLinkName(aggregationGroup.items));
                }
                if (fd.isGroupField()) {
                    ai.nestedLinks = AggregationQueryBuilder.GetNestedFieldsInfo(fd);
                    ai.isLink = true;
                    Iterator i$ = fd.getNestedFields().iterator();
                    if (i$.hasNext()) {
                        FieldDefinition nestedFieldDef = (FieldDefinition)i$.next();
                        if (nestedFieldDef.isGroupField()) {
                            List<LinkInfo> info = AggregationQueryBuilder.GetNestedFieldsInfo(nestedFieldDef);
                            if (info.size() == 0) {
                                throw new IllegalArgumentException(" There are no fields in group " + nestedFieldDef.getName());
                            }
                            nestedFieldDef = info.get((int)0).fieldDef;
                        }
                        if (tableDef.isLinkField(nestedFieldDef.getName()) || nestedFieldDef.isXLinkField()) {
                            TableDefinition td = tableDef.getLinkExtentTableDef(nestedFieldDef);
                            if (td == null) {
                                throw new IllegalArgumentException(" Cannot get table definition for " + QueryUtils.FullLinkName(aggregationGroup.items));
                            }
                            tableDef = td;
                        }
                        ai.tableDef = tableDef;
                    }
                } else if (fd.isLinkField() || fd.isXLinkField()) {
                    ai.isLink = true;
                    if (fieldDetected) {
                        throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(aggregationGroup.items));
                    }
                    if ((tableDef = tableDef.getLinkExtentTableDef(fd)) == null) {
                        throw new IllegalArgumentException(" Cannot get table definition for link " + QueryUtils.FullLinkName(aggregationGroup.items));
                    }
                } else {
                    if (fieldDetected) {
                        throw new IllegalArgumentException("Error: Not a link " + QueryUtils.FullLinkName(aggregationGroup.items));
                    }
                    fieldDetected = true;
                }
                ai.tableDef = tableDef;
            }
            if (item.queryItems == null) continue;
            for (int j = 0; j < item.queryItems.size(); ++j) {
                filterItems = item.queryItems.get(j);
                ai.query = AggregationQueryBuilder.CompileQuery(tableDef, ai.query, filterItems);
                last = filterItems.get(filterItems.size() - 2);
                lastPos = last.getPtr() + last.getValue().length();
            }
        }
        if (aggregationGroup != null && aggregationGroup.items != null) {
            aggregationGroup.text = context.inputString.substring(startPos, lastPos);
            result.add(aggregationGroup);
        }
        for (i = 0; i < result.size(); ++i) {
            AggregationGroupItem item;
            group = (AggregationGroup)result.get(i);
            if (group.batch != null && group.items != null) {
                item = group.items.get(group.items.size() - 1);
                if (item.fieldDef == null) {
                    throw new IllegalArgumentException("Unknown field/link name " + item.name);
                }
                FieldType itemType = item.fieldDef.getType();
                if (itemType == FieldType.GROUP || itemType == FieldType.LINK || itemType == FieldType.XLINK || itemType == FieldType.BINARY || itemType == FieldType.BOOLEAN) {
                    throw new IllegalArgumentException("Error: BATCH is not supported for " + itemType.toString() + " field type");
                }
                for (int j = 0; j < group.batch.size(); ++j) {
                    try {
                        group.batch.set(j, AggregationQueryBuilder.convert(itemType, (String)group.batch.get(j)));
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Wrong batch value '" + group.batch.get(j) + "' for field " + item.fieldDef.getName());
                    }
                }
                if (group.batch.size() > 1) {
                    Object first = group.batch.get(0);
                    for (int j = 1; j < group.batch.size(); ++j) {
                        switch (AggregationQueryBuilder.compareBatchValues(itemType, first, group.batch.get(j))) {
                            case 0: {
                                throw new IllegalArgumentException("Duplicated batch values are not allowed");
                            }
                            case 1: {
                                throw new IllegalArgumentException("Batch values must be in an ascending order");
                            }
                        }
                        first = group.batch.get(j);
                    }
                }
            }
            if (group.truncate == null || group.items == null) continue;
            item = group.items.get(group.items.size() - 1);
            if (item.fieldDef == null) {
                throw new IllegalArgumentException("Unknown field/link name " + item.name);
            }
            if (item.fieldDef.getType() == FieldType.TIMESTAMP) continue;
            throw new IllegalArgumentException("Error: TRUNCATE may be applied only for TIMESTAMP fields");
        }
        for (i = 0; i < result.size(); ++i) {
            group = result.get(i);
            group.whereFilter = AggregationQueryBuilder.getWhereQuery(group);
        }
        return result;
    }

    private static void SetFilter(AggregationGroup aggregationGroup, TableDefinition tableDef, Item item) {
        if (item.queryItems != null) {
            for (int j = 0; j < item.queryItems.size(); ++j) {
                aggregationGroup.filter = AggregationQueryBuilder.CompileQuery(tableDef, aggregationGroup.filter, item.queryItems.get(j));
            }
        }
    }

    private static LinkQuery GetLast(LinkQuery q) {
        while (q.innerQuery != null) {
            q = (LinkQuery)q.innerQuery;
        }
        return q;
    }

    private static Query getWhereQuery(AggregationGroup group) {
        ArrayList queryList = new ArrayList();
        for (int i = 0; i < group.items.size(); ++i) {
            AggregationGroupItem item = group.items.get(i);
            if (item.query == null) continue;
            if (item.isLink) {
                int j;
                ArrayList<LinkQuery> groups = new ArrayList<LinkQuery>();
                for (j = 0; j <= i; ++j) {
                    int k;
                    AggregationGroupItem next = group.items.get(j);
                    if (next.fieldDef != null && next.fieldDef.isGroupField()) {
                        if (groups.isEmpty()) {
                            for (k = 0; k < next.nestedLinks.size(); ++k) {
                                LinkQuery lq = new LinkQuery(LinkQuery.ANY, next.nestedLinks.get((int)k).name, null);
                                groups.add(lq);
                            }
                            continue;
                        }
                        ArrayList<LinkQuery> newSet = new ArrayList<LinkQuery>();
                        for (int k2 = 0; k2 < next.nestedLinks.size(); ++k2) {
                            LinkInfo info = next.nestedLinks.get(k2);
                            for (int l = 0; l < groups.size(); ++l) {
                                LinkQuery linkQuery = (LinkQuery)QueryUtils.CloneQuery((Query)groups.get(l));
                                LinkQuery last = AggregationQueryBuilder.GetLast(linkQuery);
                                last.innerQuery = new LinkQuery(LinkQuery.ANY, info.name, null);
                                newSet.add(linkQuery);
                            }
                        }
                        groups = newSet;
                        continue;
                    }
                    if (groups.isEmpty()) {
                        groups.add(new LinkQuery(LinkQuery.ANY, next.name, null));
                        continue;
                    }
                    for (k = 0; k < groups.size(); ++k) {
                        LinkQuery linkQuery = (LinkQuery)groups.get(k);
                        LinkQuery last = AggregationQueryBuilder.GetLast(linkQuery);
                        LinkQuery lq = new LinkQuery(LinkQuery.ANY, next.name, null);
                        last.innerQuery = lq;
                    }
                }
                switch (groups.size()) {
                    case 0: {
                        throw new IllegalArgumentException("Cannot create query for " + item.name);
                    }
                    case 1: {
                        AggregationQueryBuilder.GetLast((LinkQuery)((LinkQuery)groups.get((int)0))).innerQuery = QueryUtils.CloneQuery(item.query);
                        queryList.add(groups.get(0));
                        break;
                    }
                    default: {
                        for (j = 0; j < groups.size(); ++j) {
                            AggregationQueryBuilder.GetLast((LinkQuery)((LinkQuery)groups.get((int)j))).innerQuery = QueryUtils.CloneQuery(item.query);
                        }
                        OrQuery or = new OrQuery();
                        or.subqueries.addAll(groups);
                        queryList.add(or);
                        break;
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Error: " + item.name + " is not a link or group name");
        }
        if (!queryList.isEmpty()) {
            if (queryList.size() > 1) {
                AndQuery andQuery = new AndQuery();
                andQuery.subqueries.addAll(queryList);
                return andQuery;
            }
            return (Query)queryList.get(0);
        }
        return null;
    }

    private static ArrayList<ArrayList<Item>> extractAgTokens(Context context) {
        ArrayList<ArrayList<Item>> result = new ArrayList<ArrayList<Item>>();
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < context.items.size(); ++i) {
            Item item;
            Item item2;
            GrammarItem grammarItem = context.items.get(i);
            if (grammarItem.getType().equals("newGroup")) {
                item2 = new Item();
                item2.item = grammarItem;
                item2.item.setType("endGroup");
                items.add(item2);
                result.add(items);
                items = new ArrayList();
                continue;
            }
            if (grammarItem.getType().equals("semantic") && grammarItem.getValue().equals("stopWordAny")) {
                grammarItem.setType("stopValueAny");
            }
            if (grammarItem.getType().equals("ignore")) {
                item2 = new Item();
                item2.item = grammarItem;
                items.add(item2);
            }
            if (grammarItem.getValue().equals("WHERE")) {
                ArrayList<GrammarItem> sublist = new ArrayList<GrammarItem>();
                Item prev = null;
                if (items.size() == 0) {
                    prev = new Item();
                    prev.item = grammarItem;
                    prev.item.setType("global");
                    items.add(prev);
                } else {
                    prev = (Item)items.get(items.size() - 1);
                }
                if (prev.queryItems == null) {
                    prev.queryItems = new ArrayList();
                }
                prev.queryItems.add(sublist);
                while (!(grammarItem = context.items.get(++i)).getValue().equals("ENDWHERE")) {
                    sublist.add(grammarItem);
                }
                continue;
            }
            if ("SETS".equals(grammarItem.getType())) {
                ++i;
                do {
                    item2 = new Item();
                    item2.item = new Literal("", "SETS", grammarItem.getPtr());
                    items.add(item2);
                    item2.queryItems = new ArrayList();
                    ArrayList<GrammarItem> sublist = new ArrayList<GrammarItem>();
                    item2.queryItems.add(sublist);
                    while (true) {
                        if ("WhiteSpaces".equals((grammarItem = context.items.get(++i)).getType()) || "ImpliedAnd".equals(grammarItem.getValue())) {
                            continue;
                        }
                        if ("NEXTSETS".equals(grammarItem.getType()) || "ENDSETS".equals(grammarItem.getType()) || "AS".equals(grammarItem.getValue())) break;
                        sublist.add(grammarItem);
                    }
                    if (!"AS".equals(grammarItem.getValue())) continue;
                    while ("WhiteSpaces".equals((grammarItem = context.items.get(++i)).getType()) || "ImpliedAnd".equals(grammarItem.getValue())) {
                    }
                    item2.item.setValue(grammarItem.getValue());
                    while ("WhiteSpaces".equals((grammarItem = context.items.get(++i)).getType()) || "ImpliedAnd".equals(grammarItem.getValue())) {
                    }
                } while ("NEXTSETS".equals(grammarItem.getType()) || !"ENDSETS".equals(grammarItem.getType()));
                continue;
            }
            String type = grammarItem.getType();
            if (type.equals("lexem") || type.equals("TruncateValue") || type.equals("TruncateSubfieldValue") || type.equals("BatchValue") || type.equals("topbottomvalue") || type.equals("AggregationMetricFunctionName") || type.equals("TimeZoneValue") || type.equals("TimeZoneDisplayName") || type.equals("topbottom") || type.equals("stopValueAny") || type.equals("LOWER") || type.equals("UPPER") || type.equals("GROUP") || type.equals("TERMS") || type.equals("TRUNCATE") || type.equals("endGroup") || type.equals("BATCH") || type.equals("SETS") || type.equals("ENDSETS") || type.equals("NEXTSETS") || type.equals("stopValue") || type.equals("alias") || type.equals("excludeValue") || type.equals("ExcludeList") || type.equals("IncludeList") || type.equals("transitive") || type.equals("transitiveValue")) {
                item = new Item();
                item.item = grammarItem;
                items.add(item);
            }
            if (!grammarItem.getType().equals("token") || !grammarItem.getValue().equals(",") && !grammarItem.getValue().equals(")")) continue;
            item = new Item();
            item.item = grammarItem;
            items.add(item);
        }
        if (items.size() > 0) {
            result.add(items);
        }
        return result;
    }

    private static ArrayList<Item> extractTokens(Context context) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < context.items.size(); ++i) {
            Item item;
            GrammarItem grammarItem = context.items.get(i);
            if (grammarItem.getType().equals("InputPointer")) {
                Item item2 = new Item();
                item2.item = grammarItem;
                items.add(item2);
                continue;
            }
            if (grammarItem.getType().equals("op") || grammarItem.getType().equals("number") || grammarItem.getType().equals("semantic") && grammarItem.getValue().equals("endMetric")) continue;
            if (grammarItem.getType().equals("semantic") && grammarItem.getValue().equals("stopWordAny")) {
                grammarItem.setType("stopValueAny");
            }
            if (grammarItem.getValue().equals("WHERE")) {
                ArrayList<GrammarItem> sublist = new ArrayList<GrammarItem>();
                Item prev = items.get(items.size() - 1);
                if (prev.queryItems == null) {
                    prev.queryItems = new ArrayList();
                }
                prev.queryItems.add(sublist);
                while (!(grammarItem = context.items.get(++i)).getValue().equals("ENDWHERE")) {
                    sublist.add(grammarItem);
                }
                continue;
            }
            String type = grammarItem.getType();
            if (type.equals("lexem") || type.equals("TruncateValue") || type.equals("TruncateSubfieldValue") || type.equals("BatchValue") || type.equals("topbottomvalue") || type.equals("AggregationMetricFunctionName") || type.equals("TimeZoneValue") || type.equals("TimeZoneDisplayName") || type.equals("topbottom") || type.equals("stopValueAny") || type.equals("stopValue") || type.equals("excludeValue") || type.equals("alias") || type.equals("ASC") || type.equals("DESC") || type.equals("IncludeList") || type.equals("ExcludeList")) {
                item = new Item();
                item.item = grammarItem;
                items.add(item);
            }
            if (!grammarItem.getType().equals("token") || !grammarItem.getValue().equals(",")) continue;
            item = new Item();
            item.item = grammarItem;
            items.add(item);
        }
        return items;
    }

    private static void AddLinkItem(ArrayList<Item> grammarItems, GrammarItem gitem) {
        Item item = new Item();
        item.item = gitem;
        grammarItems.add(item);
    }

    private static ArrayList<Item> extractMetricTokens(Context context) {
        Calendar calendar = Calendar.getInstance();
        long currentDate = calendar.getTimeInMillis();
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < context.items.size(); ++i) {
            Item item;
            Item item2;
            GrammarItem grammarItem = context.items.get(i);
            String itemType = grammarItem.getType();
            if (grammarItem.getType().equals("op") || grammarItem.getType().equals("number") || grammarItem.getType().equals("InputPointer")) {
                item2 = new Item();
                item2.item = grammarItem;
                items.add(item2);
                continue;
            }
            if (grammarItem.getType().equals("datediff") || grammarItem.getType().equals("semantic") && grammarItem.getValue().equals("datediff_calc")) {
                item2 = new Item();
                item2.item = grammarItem;
                items.add(item2);
                continue;
            }
            if (grammarItem.getValue().equals("CalculateNow")) {
                Item last = AggregationQueryBuilder.DropItem(items);
                String type = last.item.getType();
                String value = last.item.getValue();
                String timezone = "UTC";
                String timezoneValue = null;
                String units = null;
                Integer intvalue = null;
                while (!type.equals("Now")) {
                    if (type.equals("NowUnits")) {
                        units = value;
                    }
                    if (type.equals("PositiveNumber")) {
                        try {
                            intvalue = Integer.parseInt(value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Bad now offset units  value: " + value);
                        }
                    }
                    if (type.equals("NegativeNumber")) {
                        try {
                            intvalue = Integer.parseInt("-" + value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Bad now offset units  value: -" + value);
                        }
                    }
                    if (type.equals("TimeZoneValue")) {
                        timezoneValue = value;
                    }
                    if (type.equals("TimeZoneDisplayName")) {
                        timezone = value;
                    }
                    last = AggregationQueryBuilder.DropItem(items);
                    type = last.item.getType();
                    value = last.item.getValue();
                }
                calendar = timezoneValue != null ? TimeUtils.getCalendarByValue(timezoneValue) : TimeUtils.getCalendarByName(timezone);
                calendar.setTimeInMillis(currentDate);
                Calendar start = TimeUtils.getNowValue(calendar, units, intvalue);
                Item item3 = new Item();
                item3.item = new Literal(TimeUtils.toUtcTime(start), "datediff", -1);
                items.add(item3);
                continue;
            }
            if (itemType.equals("PeriodGMT")) {
                calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                calendar.setTimeInMillis(currentDate);
                continue;
            }
            if (itemType.equals("TimeZoneDisplayName")) {
                calendar = TimeUtils.getCalendarByName(grammarItem.getValue());
                calendar.setTimeInMillis(currentDate);
                continue;
            }
            if (itemType.equals("TimeZoneValue")) {
                calendar = TimeUtils.getCalendarByValue(grammarItem.getValue());
                calendar.setTimeInMillis(currentDate);
                continue;
            }
            if (itemType.equals("transitiveValue")) {
                AggregationQueryBuilder.AddLinkItem(items, grammarItem);
                continue;
            }
            if (itemType.equals("transitive")) {
                AggregationQueryBuilder.AddLinkItem(items, grammarItem);
                continue;
            }
            if (itemType.equals("Now")) {
                AggregationQueryBuilder.AddLinkItem(items, grammarItem);
                continue;
            }
            if (itemType.equals("PositiveNumber")) {
                AggregationQueryBuilder.AddLinkItem(items, grammarItem);
                continue;
            }
            if (itemType.equals("NegativeNumber")) {
                AggregationQueryBuilder.AddLinkItem(items, grammarItem);
                continue;
            }
            if (itemType.equals("NowUnits")) {
                AggregationQueryBuilder.AddLinkItem(items, grammarItem);
                continue;
            }
            if (grammarItem.getType().equals("semantic") && grammarItem.getValue().equals("endMetric")) {
                item2 = new Item();
                item2.item = grammarItem;
                items.add(item2);
                continue;
            }
            if (grammarItem.getType().equals("semantic") && grammarItem.getValue().equals("stopWordAny")) {
                grammarItem.setType("stopValueAny");
            }
            if (grammarItem.getValue().equals("WHERE")) {
                ArrayList<GrammarItem> sublist = new ArrayList<GrammarItem>();
                Item prev = items.get(items.size() - 1);
                if (prev.queryItems == null) {
                    prev.queryItems = new ArrayList();
                }
                prev.queryItems.add(sublist);
                while (!(grammarItem = context.items.get(++i)).getValue().equals("ENDWHERE")) {
                    sublist.add(grammarItem);
                }
                continue;
            }
            String type = grammarItem.getType();
            if (type.equals("lexem") || type.equals("TruncateValue") || type.equals("TruncateSubfieldValue") || type.equals("BatchValue") || type.equals("topbottomvalue") || type.equals("AggregationMetricFunctionName") || type.equals("TimeZoneValue") || type.equals("TimeZoneDisplayName") || type.equals("topbottom") || type.equals("stopValueAny") || type.equals("stopValue") || type.equals("excludeValue") || type.equals("alias") || type.equals("ASC") || type.equals("DESC") || type.equals("IncludeList") || type.equals("ExcludeList") || type.equals("MetricFunctionBinary") || type.equals("MetricFunctionParameter")) {
                item = new Item();
                item.item = grammarItem;
                items.add(item);
            }
            if (!grammarItem.getType().equals("token") || !grammarItem.getValue().equals(",")) continue;
            item = new Item();
            item.item = grammarItem;
            items.add(item);
        }
        return items;
    }

    public static List<LinkInfo> GetNestedFieldsInfo(FieldDefinition groupFieldDef) {
        ArrayList<LinkInfo> result = new ArrayList<LinkInfo>();
        for (FieldDefinition nestedFieldDef : groupFieldDef.getNestedFields()) {
            if (nestedFieldDef.isGroupField()) {
                result.addAll(AggregationQueryBuilder.GetNestedFieldsInfo(nestedFieldDef));
                continue;
            }
            result.add(new LinkInfo(nestedFieldDef.getName(), nestedFieldDef));
        }
        return result;
    }

    public static List<String> GetMetricFields(AggregationMetric metric) {
        if (metric == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (metric.items == null) {
            return result;
        }
        for (int i = 0; i < metric.items.size(); ++i) {
            AggregationGroupItem aggregationGroupItem = metric.items.get(i);
            result.add(aggregationGroupItem.name);
        }
        return result;
    }

    public static int compareBatchValues(FieldType type, Object arg1, Object arg2) {
        switch (type) {
            case INTEGER: {
                return ((Integer)arg1).compareTo((Integer)arg2);
            }
            case LONG: {
                return ((Long)arg1).compareTo((Long)arg2);
            }
            case FLOAT: {
                return ((Float)arg1).compareTo((Float)arg2);
            }
            case DOUBLE: {
                return ((Double)arg1).compareTo((Double)arg2);
            }
            case TEXT: {
                return ((String)arg1).compareTo((String)arg2);
            }
            case TIMESTAMP: {
                return ((Date)arg1).compareTo((Date)arg2);
            }
        }
        throw new IllegalArgumentException("Not supported type for batch: " + type);
    }

    private static Object convert(FieldType type, String value) {
        switch (type) {
            case BOOLEAN: {
                return value;
            }
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case TEXT: {
                return value;
            }
            case TIMESTAMP: {
                for (SimpleDateFormat sdf : QueryUtils.DATE_FORMATS) {
                    try {
                        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                        return sdf.parse(value);
                    }
                    catch (Exception e) {
                    }
                }
                throw new IllegalArgumentException("Unknown timestamp format: " + value);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    static boolean isCorrectTimeZone(String name) {
        String[] timeZoneIds = TimeZone.getAvailableIDs();
        if (availableTimeZones == null) {
            HashSet<String> zones = new HashSet<String>();
            for (String id : timeZoneIds) {
                zones.add(id);
            }
            availableTimeZones = zones;
        }
        return availableTimeZones.contains(name);
    }
}

