/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.search.iterator.NoneIterator;
import com.dell.doradus.search.iterator.OrIterable;
import com.dell.doradus.search.iterator.TermIterable;
import com.dell.doradus.service.spider.SpiderHelper;
import com.dell.doradus.service.spider.SpiderService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TermsIterable
implements Iterable<ObjectID> {
    private TableDefinition m_table;
    private List<Integer> m_shards;
    private ObjectID m_continuation;
    private boolean m_inclusive;
    private Set<String> m_terms = new HashSet<String>();

    public TermsIterable(TableDefinition table, List<Integer> shards, ObjectID continuation, boolean inclusive) {
        this.m_table = table;
        this.m_shards = shards;
        if (this.m_shards == null) {
            this.m_shards = new ArrayList<Integer>(1);
            this.m_shards.add(0);
            if (table.isSharded()) {
                Set<Integer> allShards = SpiderService.instance().getShards(table).keySet();
                this.m_shards.addAll(allShards);
            }
        }
        this.m_continuation = continuation;
        this.m_inclusive = inclusive;
    }

    public void add(String term) {
        this.m_terms.add(term);
    }

    @Override
    public Iterator<ObjectID> iterator() {
        int count = ServerConfig.getInstance().dbesoptions_linkBuffer;
        if (this.m_shards.size() == 0) {
            return NoneIterator.instance;
        }
        if (this.m_terms.size() == 0) {
            return NoneIterator.instance;
        }
        if (this.m_shards.size() * this.m_terms.size() == 1) {
            List<ObjectID> lst = SpiderHelper.getTermDocs(this.m_table, this.m_shards.get(0), this.m_terms.iterator().next(), this.m_continuation, this.m_inclusive, count);
            return new TermIterable(this.m_table, this.m_shards.get(0), this.m_terms.iterator().next(), count, lst).iterator();
        }
        OrIterable or = new OrIterable(this.m_shards.size() * this.m_terms.size());
        for (Integer shard : this.m_shards) {
            Map<String, List<ObjectID>> map = SpiderHelper.getTermDocs(this.m_table, shard, this.m_terms, this.m_continuation, this.m_inclusive, count);
            for (Map.Entry<String, List<ObjectID>> e : map.entrySet()) {
                if (e.getValue().size() == 0) continue;
                or.add(new TermIterable(this.m_table, shard, e.getKey(), count, e.getValue()));
            }
        }
        return or.iterator();
    }
}

