/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.service.spider.SpiderHelper;
import java.util.Iterator;
import java.util.List;

public class TermIterator
implements Iterator<ObjectID> {
    private TableDefinition m_table;
    private Integer m_shard;
    private String m_term;
    private int m_bufferSize;
    private List<ObjectID> m_buffer;
    private int m_next;

    public TermIterator(TableDefinition table, Integer shard, String term, int bufferSize, List<ObjectID> buffer) {
        this.m_table = table;
        this.m_shard = shard;
        this.m_term = term;
        this.m_bufferSize = bufferSize;
        this.m_buffer = buffer;
        this.m_next = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.m_next == this.m_buffer.size()) {
            if (this.m_buffer.size() != this.m_bufferSize) {
                return false;
            }
            ObjectID continuation = this.m_buffer.get(this.m_buffer.size() - 1);
            this.m_buffer = SpiderHelper.getTermDocs(this.m_table, this.m_shard, this.m_term, continuation, false, this.m_bufferSize);
            this.m_next = 0;
        }
        return this.m_next < this.m_buffer.size();
    }

    @Override
    public ObjectID next() {
        if (!this.hasNext()) {
            throw new RuntimeException("Read past the end of the iterator");
        }
        return this.m_buffer.get(this.m_next++);
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }
}

