/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.iterator.NoneIterator;
import com.dell.doradus.search.iterator.TermIterator;
import java.util.Iterator;
import java.util.List;

public class TermIterable
implements Iterable<ObjectID> {
    private TableDefinition m_table;
    private Integer m_shard;
    private String m_term;
    private int m_bufferSize;
    private List<ObjectID> m_buffer;

    public TermIterable(TableDefinition table, Integer shard, String term, int bufferSize, List<ObjectID> buffer) {
        this.m_table = table;
        this.m_shard = shard;
        this.m_term = term;
        this.m_bufferSize = bufferSize;
        this.m_buffer = buffer;
    }

    @Override
    public Iterator<ObjectID> iterator() {
        if (this.m_buffer.size() == 0) {
            return NoneIterator.instance;
        }
        if (this.m_buffer.size() < this.m_bufferSize) {
            return this.m_buffer.iterator();
        }
        return new TermIterator(this.m_table, this.m_shard, this.m_term, this.m_bufferSize, this.m_buffer);
    }
}

