/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.util.DefaultComparator;
import com.dell.doradus.search.util.HeapList;
import java.util.Iterator;
import java.util.List;

public class OrIterator
implements Iterator<ObjectID> {
    private DefaultComparator<ObjectID> m_comp = new DefaultComparator();
    private HeapList<IxV> m_heap;
    private IxV m_current;

    public OrIterator(List<Iterator<ObjectID>> iterators) {
        this.m_heap = new HeapList(iterators.size() - 1);
        for (Iterator<ObjectID> i : iterators) {
            IxV ixv = new IxV(i);
            ixv.next();
            this.m_current = this.m_heap.AddEx(ixv);
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_current.V != null;
    }

    @Override
    public ObjectID next() {
        ObjectID oldval = this.m_current.V;
        while (this.m_comp.compare(this.m_current.V, oldval) == 0) {
            this.m_current.next();
            this.m_current = this.m_heap.AddEx(this.m_current);
        }
        return oldval;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Cannot remove");
    }

    class IxV
    implements Comparable<IxV> {
        public Iterator<ObjectID> I;
        public ObjectID V;

        public IxV() {
        }

        public IxV(Iterator<ObjectID> i) {
            this.I = i;
        }

        public void next() {
            this.V = this.I.hasNext() ? this.I.next() : null;
        }

        @Override
        public int compareTo(IxV other) {
            return OrIterator.this.m_comp.compare(other.V, this.V);
        }
    }
}

