/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.search.iterator.LinkIterable;
import com.dell.doradus.search.iterator.LinkIterator;
import com.dell.doradus.search.iterator.NoneIterator;
import com.dell.doradus.search.iterator.OrIterable;
import com.dell.doradus.service.spider.SpiderHelper;
import com.dell.doradus.service.spider.SpiderService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LinksIterable
implements Iterable<ObjectID> {
    private FieldDefinition m_link;
    private List<Integer> m_shards;
    private ObjectID m_continuation;
    private boolean m_inclusive;
    private Iterable<ObjectID> m_keys;

    public LinksIterable(FieldDefinition link, List<Integer> shards, ObjectID continuation, boolean inclusive, Iterable<ObjectID> keys) {
        this.m_link = link;
        this.m_shards = shards;
        if (this.m_shards == null) {
            this.m_shards = new ArrayList<Integer>(1);
            this.m_shards.add(0);
            if (link.isSharded()) {
                this.m_shards.addAll(SpiderService.instance().getShards(link.getInverseTableDef()).keySet());
            }
        }
        this.m_continuation = continuation;
        this.m_inclusive = inclusive;
        this.m_keys = keys;
    }

    @Override
    public Iterator<ObjectID> iterator() {
        OrIterable or;
        if (this.m_shards.size() == 0) {
            return NoneIterator.instance;
        }
        int maxobjects = 64;
        int maxmaxobjects = 65536;
        int count = ServerConfig.getInstance().dbesoptions_linkBuffer;
        ArrayList<ObjectID> keys = new ArrayList<ObjectID>();
        for (ObjectID key : this.m_keys) {
            keys.add(key);
        }
        if (keys.size() == 0) {
            return NoneIterator.instance;
        }
        if (keys.size() * this.m_shards.size() == 1) {
            List<ObjectID> lst = SpiderHelper.getLinks(this.m_link, this.m_shards.get(0), (ObjectID)keys.get(0), this.m_continuation, this.m_inclusive, count);
            return new LinkIterator(this.m_link, this.m_shards.get(0), (ObjectID)keys.get(0), count, lst);
        }
        if (keys.size() <= maxobjects) {
            or = new OrIterable(this.m_shards.size() * keys.size());
            for (Integer shard : this.m_shards) {
                Map<ObjectID, List<ObjectID>> map = SpiderHelper.getLinks(this.m_link, shard, keys, this.m_continuation, this.m_inclusive, count);
                for (Map.Entry<ObjectID, List<ObjectID>> e : map.entrySet()) {
                    if (e.getValue().size() == 0) continue;
                    or.add(new LinkIterable(this.m_link, shard, e.getKey(), count, e.getValue()));
                }
            }
            return or.iterator();
        }
        if (keys.size() <= maxmaxobjects) {
            or = new OrIterable(keys.size());
            for (Integer shard : this.m_shards) {
                for (ObjectID key : keys) {
                    List<ObjectID> lst = SpiderHelper.getLinks(this.m_link, shard, key, this.m_continuation, this.m_inclusive, count);
                    or.add(new LinkIterable(this.m_link, shard, key, count, lst));
                }
            }
            return or.iterator();
        }
        HashSet<ObjectID> set = new HashSet<ObjectID>();
        for (Integer shard : this.m_shards) {
            for (ObjectID key : keys) {
                List<ObjectID> lst = SpiderHelper.getLinks(this.m_link, shard, key, this.m_continuation, this.m_inclusive, count);
                LinkIterable iterator = new LinkIterable(this.m_link, shard, key, count, lst);
                for (ObjectID obj : iterator) {
                    set.add(obj);
                }
            }
        }
        ArrayList<ObjectID> result = new ArrayList<ObjectID>(set.size());
        result.addAll(set);
        Collections.sort(result);
        return result.iterator();
    }
}

