/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.service.spider.SpiderHelper;
import java.util.Iterator;
import java.util.List;

public class LinkIterator
implements Iterator<ObjectID> {
    private FieldDefinition m_link;
    private Integer m_shard;
    private ObjectID m_id;
    private int m_bufferSize;
    private List<ObjectID> m_buffer;
    private int m_next;

    public LinkIterator(FieldDefinition link, Integer shard, ObjectID id, int bufferSize, List<ObjectID> buffer) {
        this.m_link = link;
        this.m_shard = shard;
        this.m_id = id;
        this.m_bufferSize = bufferSize;
        this.m_buffer = buffer;
        this.m_next = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.m_next == this.m_buffer.size()) {
            if (this.m_buffer.size() != this.m_bufferSize) {
                return false;
            }
            ObjectID continuation = this.m_buffer.get(this.m_buffer.size() - 1);
            this.m_buffer = SpiderHelper.getLinks(this.m_link, this.m_shard, this.m_id, continuation, false, this.m_bufferSize);
            this.m_next = 0;
        }
        return this.m_next < this.m_buffer.size();
    }

    @Override
    public ObjectID next() {
        if (!this.hasNext()) {
            throw new RuntimeException("Read past the end of the iterator");
        }
        return this.m_buffer.get(this.m_next++);
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }
}

