/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.core.ObjectID;
import java.util.Iterator;

public class AndNotIterator
implements Iterator<ObjectID> {
    private Iterator<ObjectID> m_plus;
    private Iterator<ObjectID> m_minus;
    private ObjectID m_next_plus;
    private ObjectID m_next_minus;

    public AndNotIterator(Iterator<ObjectID> plus, Iterator<ObjectID> minus) {
        this.m_plus = plus;
        this.m_minus = minus;
        this.m_next_minus = this.m_minus.hasNext() ? this.m_minus.next() : null;
        this.move();
    }

    @Override
    public boolean hasNext() {
        return this.m_next_plus != null;
    }

    @Override
    public ObjectID next() {
        ObjectID next = this.m_next_plus;
        if (next == null) {
            throw new RuntimeException("Read past the end of the iterator");
        }
        this.move();
        return next;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Cannot remove");
    }

    private void move() {
        do {
            if (!this.m_plus.hasNext()) {
                this.m_next_plus = null;
                return;
            }
            this.m_next_plus = this.m_plus.next();
            while (this.m_next_minus != null && this.m_next_minus.compareTo(this.m_next_plus) < 0) {
                ObjectID objectID = this.m_next_minus = this.m_minus.hasNext() ? this.m_minus.next() : null;
            }
        } while (this.m_next_plus.equals(this.m_next_minus));
    }
}

