/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.iterator;

import com.dell.doradus.core.ObjectID;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AndIterator
implements Iterator<ObjectID> {
    private List<IxT> m_iterators;
    private ObjectID m_next;

    public AndIterator(List<Iterator<ObjectID>> iterators) {
        this.m_iterators = new ArrayList<IxT>(iterators.size());
        for (Iterator<ObjectID> i : iterators) {
            this.m_iterators.add(new IxT(i));
        }
        this.move();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public ObjectID next() {
        ObjectID next = this.m_next;
        if (next == null) {
            throw new RuntimeException("Read past the end of the iterator");
        }
        this.move();
        return next;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Cannot remove");
    }

    private void move() {
        for (IxT v : this.m_iterators) {
            do {
                if (!v.I.hasNext()) {
                    this.m_next = null;
                    return;
                }
                v.C = v.I.next();
                if (this.m_next != null) continue;
                this.m_next = v.C;
            } while (v.C == null || this.m_next.compareTo(v.C) > 0);
            this.m_next = v.C;
        }
        while (!this.m_next.equals(this.m_iterators.get((int)0).C)) {
            for (IxT v : this.m_iterators) {
                while (this.m_next.compareTo(v.C) > 0) {
                    if (!v.I.hasNext()) {
                        this.m_next = null;
                        return;
                    }
                    v.C = v.I.next();
                    if (this.m_next != null) continue;
                    this.m_next = v.C;
                }
                this.m_next = v.C;
            }
        }
    }

    class IxT {
        public Iterator<ObjectID> I;
        public ObjectID C;

        public IxT(Iterator<ObjectID> i) {
            this.I = i;
        }
    }
}

