/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.query.RangeQuery;
import java.util.Set;

public class FilterRangeInt
implements Filter {
    private RangeQuery m_range;
    private Long m_min;
    private Long m_max;

    public FilterRangeInt(RangeQuery range) {
        this.m_range = range;
        if (range.min != null) {
            this.m_min = Long.parseLong(range.min);
        }
        if (range.max != null) {
            this.m_max = Long.parseLong(range.max);
        }
    }

    @Override
    public boolean check(Entity entity) {
        int c;
        Long v;
        String value = entity.get(this.m_range.field);
        if (value == null) {
            return false;
        }
        try {
            v = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (this.m_min != null) {
            c = v.compareTo(this.m_min);
            if (c == 0 && this.m_range.minInclusive) {
                c = 1;
            }
            if (c <= 0) {
                return false;
            }
        }
        if (this.m_range.max != null) {
            c = v.compareTo(this.m_max);
            if (c == 0 && this.m_range.maxInclusive) {
                c = -1;
            }
            if (c >= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addFields(Set<String> fields) {
        fields.add(this.m_range.field);
    }
}

