/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.query.RangeQuery;
import java.util.Set;

public class FilterRange
implements Filter {
    private RangeQuery m_range;

    public FilterRange(RangeQuery range) {
        this.m_range = range;
    }

    @Override
    public boolean check(Entity entity) {
        String value = entity.get(this.m_range.field);
        if (value == null) {
            return false;
        }
        char sep = "\ufffe".charAt(0);
        if (value.indexOf(sep) < 0) {
            return this.checkRange(value);
        }
        for (String val : Utils.split((String)value, (char)sep)) {
            if (!this.checkRange(val)) continue;
            return true;
        }
        return false;
    }

    private boolean checkRange(String value) {
        int c;
        if (this.m_range.min != null) {
            c = value.compareToIgnoreCase(this.m_range.min);
            if (c == 0 && this.m_range.minInclusive) {
                c = 1;
            }
            if (c <= 0) {
                return false;
            }
        }
        if (this.m_range.max != null) {
            c = value.compareToIgnoreCase(this.m_range.max);
            if (c == 0 && this.m_range.maxInclusive) {
                c = -1;
            }
            if (c >= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addFields(Set<String> fields) {
        fields.add(this.m_range.field);
    }
}

