/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.filter.FilterEquals;
import com.dell.doradus.search.query.LinkQuery;
import java.util.Set;

public class FilterMVSEquals
implements Filter {
    private String m_field;
    private String m_value;
    private Quantifier m_quantifier;

    public FilterMVSEquals(String field, String value, String quantifier) {
        this.m_field = field;
        this.m_value = value;
        if (LinkQuery.ANY.equals(quantifier)) {
            this.m_quantifier = Quantifier.ANY;
        } else if (LinkQuery.ALL.equals(quantifier)) {
            this.m_quantifier = Quantifier.ALL;
        } else if (LinkQuery.NONE.equals(quantifier)) {
            this.m_quantifier = Quantifier.NONE;
        } else {
            throw new IllegalArgumentException("Unknown MVS quantifier: " + quantifier);
        }
    }

    @Override
    public boolean check(Entity entity) {
        String fieldValue = entity.get(this.m_field);
        if (fieldValue == null) {
            return false;
        }
        if (this.m_quantifier == Quantifier.ANY) {
            for (String subvalue : Utils.split((String)fieldValue, (String)"\ufffe")) {
                if (!FilterEquals.compare(subvalue, this.m_value)) continue;
                return true;
            }
            return false;
        }
        if (this.m_quantifier == Quantifier.ALL) {
            boolean hasValues = false;
            for (String subvalue : Utils.split((String)fieldValue, (String)"\ufffe")) {
                hasValues = true;
                if (FilterEquals.compare(subvalue, this.m_value)) continue;
                return false;
            }
            return hasValues;
        }
        if (this.m_quantifier == Quantifier.NONE) {
            for (String subvalue : Utils.split((String)fieldValue, (String)"\ufffe")) {
                if (!FilterEquals.compare(subvalue, this.m_value)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown quantifier: " + this.m_quantifier.toString());
    }

    @Override
    public void addFields(Set<String> fields) {
        fields.add(this.m_field);
    }

    static enum Quantifier {
        ANY,
        NONE,
        ALL;

    }
}

