/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.Searcher;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.TransitiveLinkQuery;
import java.util.List;
import java.util.Set;

public class FilterLinkTransitive
implements Filter {
    public static final int MAX_DEPTH = 20;
    private TransitiveLinkQuery m_query;
    private Filter m_inner;
    private List<String> m_innerFields;
    private Quantifier m_quantifier;
    private int m_depth;

    public FilterLinkTransitive(Searcher searcher, TableDefinition table, TransitiveLinkQuery query, Filter inner) {
        this.m_query = query;
        this.m_inner = inner;
        this.m_innerFields = Searcher.getFields(this.m_inner);
        this.m_depth = query.depth;
        if (LinkQuery.ANY.equals(this.m_query.quantifier)) {
            this.m_quantifier = Quantifier.ANY;
        } else if (LinkQuery.ALL.equals(this.m_query.quantifier)) {
            this.m_quantifier = Quantifier.ALL;
        } else if (LinkQuery.NONE.equals(this.m_query.quantifier)) {
            this.m_quantifier = Quantifier.NONE;
        } else {
            throw new IllegalArgumentException("Unknown link quantifier: " + query.quantifier);
        }
    }

    @Override
    public boolean check(Entity entity) {
        if (this.m_depth == 0) {
            this.m_depth = 20;
        }
        return this.check(this.m_depth - 1, entity);
    }

    private boolean check(int level, Entity entity) {
        EntitySequence links = entity.getLinkedEntities(this.m_query.link, this.m_innerFields);
        if (this.m_quantifier == Quantifier.ANY) {
            for (Entity e : links) {
                if (this.m_inner.check(e)) {
                    return true;
                }
                if (level <= 0 || !this.check(level - 1, e)) continue;
                return true;
            }
            return false;
        }
        if (this.m_quantifier == Quantifier.ALL) {
            boolean hasLinks = false;
            for (Entity e : links) {
                hasLinks = true;
                if (!this.m_inner.check(e)) {
                    return false;
                }
                if (level <= 0 || this.check(level - 1, e)) continue;
                return false;
            }
            return hasLinks;
        }
        if (this.m_quantifier == Quantifier.NONE) {
            for (Entity e : links) {
                if (this.m_inner.check(e)) {
                    return false;
                }
                if (level <= 0 || !this.check(level - 1, e)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown quantifier: " + this.m_quantifier.toString());
    }

    @Override
    public void addFields(Set<String> fields) {
    }

    static enum Quantifier {
        ANY,
        NONE,
        ALL;

    }
}

