/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.search.Searcher;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.query.RangeQuery;
import java.util.Set;

public class FilterLinkCountRange
implements Filter {
    private String m_link;
    private int m_min;
    private int m_max;
    private Filter m_inner;

    public FilterLinkCountRange(String link, RangeQuery query, Filter inner) {
        this.m_link = link;
        this.m_min = Integer.MIN_VALUE;
        this.m_max = Integer.MAX_VALUE;
        if (query.min != null) {
            this.m_min = Integer.parseInt(query.min.toString());
            if (!query.minInclusive) {
                ++this.m_min;
            }
        }
        if (query.max != null) {
            this.m_max = Integer.parseInt(query.max.toString());
            if (query.maxInclusive) {
                ++this.m_max;
            }
        }
        this.m_inner = inner;
    }

    @Override
    public boolean check(Entity entity) {
        EntitySequence links = entity.getLinkedEntities(this.m_link, Searcher.EMPTY_ARRAY);
        int count = 0;
        for (Entity e : links) {
            if (e == null) break;
            if (this.m_inner != null && !this.m_inner.check(e) || this.m_max > ++count) continue;
            return false;
        }
        return count >= this.m_min && count < this.m_max;
    }

    @Override
    public void addFields(Set<String> fields) {
    }
}

