/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.Searcher;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.query.LinkQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FilterLink
implements Filter {
    private LinkQuery m_query;
    private Filter m_inner;
    private List<String> m_innerFields;
    private Quantifier m_quantifier;
    private List<String> m_links = new ArrayList<String>();

    public FilterLink(Searcher searcher, TableDefinition table, LinkQuery query, Filter inner) {
        this.m_query = query;
        this.m_inner = inner;
        this.m_innerFields = Searcher.getFields(this.m_inner);
        if (LinkQuery.ANY.equals(this.m_query.quantifier)) {
            this.m_quantifier = Quantifier.ANY;
        } else if (LinkQuery.ALL.equals(this.m_query.quantifier)) {
            this.m_quantifier = Quantifier.ALL;
        } else if (LinkQuery.NONE.equals(this.m_query.quantifier)) {
            this.m_quantifier = Quantifier.NONE;
        } else {
            throw new IllegalArgumentException("Unknown link quantifier: " + query.quantifier);
        }
        this.addGroupFields(table.getFieldDef(this.m_query.link));
    }

    private void addGroupFields(FieldDefinition fieldDef) {
        if (fieldDef.isLinkField()) {
            this.m_links.add(fieldDef.getName());
        } else if (fieldDef.isGroupField()) {
            for (FieldDefinition child : fieldDef.getNestedFields()) {
                this.addGroupFields(child);
            }
        }
    }

    @Override
    public boolean check(Entity entity) {
        ArrayList<EntitySequence> links = new ArrayList<EntitySequence>(this.m_links.size());
        for (String link : this.m_links) {
            links.add(entity.getLinkedEntities(link, this.m_innerFields));
        }
        if (this.m_quantifier == Quantifier.ANY) {
            for (EntitySequence es : links) {
                for (Entity e : es) {
                    if (!this.m_inner.check(e)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.m_quantifier == Quantifier.ALL) {
            boolean hasLinks = false;
            for (EntitySequence es : links) {
                for (Entity e : es) {
                    hasLinks = true;
                    if (this.m_inner.check(e)) continue;
                    return false;
                }
            }
            return hasLinks;
        }
        if (this.m_quantifier == Quantifier.NONE) {
            for (EntitySequence es : links) {
                for (Entity e : es) {
                    if (!this.m_inner.check(e)) continue;
                    return false;
                }
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown quantifier: " + this.m_quantifier.toString());
    }

    @Override
    public void addFields(Set<String> fields) {
    }

    static enum Quantifier {
        ANY,
        NONE,
        ALL;

    }
}

