/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.query.RangeQuery;
import java.util.Set;

public class FilterFieldCountRange
implements Filter {
    private String m_field;
    private int m_min;
    private int m_max;

    public FilterFieldCountRange(String field, RangeQuery query) {
        this.m_field = field;
        this.m_min = Integer.MIN_VALUE;
        this.m_max = Integer.MAX_VALUE;
        if (query.min != null) {
            this.m_min = Integer.parseInt(query.min.toString());
            if (!query.minInclusive) {
                ++this.m_min;
            }
        }
        if (query.max != null) {
            this.m_max = Integer.parseInt(query.max.toString());
            if (query.maxInclusive) {
                ++this.m_max;
            }
        }
    }

    @Override
    public boolean check(Entity entity) {
        String value = entity.get(this.m_field);
        int count = 0;
        if (value != null) {
            int n = count = value.indexOf("\ufffe") == -1 ? 1 : Utils.split((String)value, (String)"\ufffe").size();
        }
        return count >= this.m_min && count < this.m_max;
    }

    @Override
    public void addFields(Set<String> fields) {
    }
}

