/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.filter.Filter;
import java.util.Set;

public class FilterEquals
implements Filter {
    private String m_field;
    private String m_value;

    public FilterEquals(String field, String value) {
        this.m_field = field;
        this.m_value = value;
    }

    public static boolean compare(String fieldValue, String value) {
        if (fieldValue == null && value == null) {
            return true;
        }
        if (fieldValue == null || value == null) {
            return false;
        }
        if (value.equals("*")) {
            return true;
        }
        if (fieldValue.indexOf("\ufffe") >= 0) {
            for (String subvalue : Utils.split((String)fieldValue, (String)"\ufffe")) {
                if (!FilterEquals.compare(subvalue, value)) continue;
                return true;
            }
            return false;
        }
        return Utils.matchesPattern((String)fieldValue, (String)value);
    }

    @Override
    public boolean check(Entity entity) {
        String fieldValue = entity.get(this.m_field);
        return FilterEquals.compare(fieldValue, this.m_value);
    }

    @Override
    public void addFields(Set<String> fields) {
        fields.add(this.m_field);
    }
}

