/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.analyzer.DateTrie;
import com.dell.doradus.search.filter.Filter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;

public class FilterDatePart
implements Filter {
    private int m_part;
    private String m_field;
    private String m_value;
    private DateTrie m_trie = new DateTrie();

    public FilterDatePart(int part, String field, String value) {
        this.m_part = part;
        this.m_field = field;
        this.m_value = value;
    }

    @Override
    public boolean check(Entity entity) {
        String fieldValue = entity.get(this.m_field);
        if (fieldValue == null || fieldValue.length() == 0) {
            return false;
        }
        if (this.m_value == null || this.m_value.equals("*")) {
            return true;
        }
        Date date = this.m_trie.parse(fieldValue);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        int part = cal.get(this.m_part);
        if (this.m_part == 2) {
            ++part;
        }
        String fieldPart = "" + part;
        return Utils.matchesPattern((String)fieldPart, (String)this.m_value);
    }

    @Override
    public void addFields(Set<String> fields) {
        fields.add(this.m_field);
    }
}

