/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.filter;

import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.analyzer.SimpleText;
import com.dell.doradus.search.filter.Filter;
import java.util.List;
import java.util.Set;

public class FilterContains
implements Filter {
    private String m_field;
    private String m_value;

    public FilterContains(String field, String value) {
        this.m_field = field;
        this.m_value = value;
    }

    public static boolean compare(String fieldValue, String value) {
        if (fieldValue == null) {
            return false;
        }
        if (value == null || value.equals("*")) {
            return true;
        }
        if (fieldValue.indexOf("\ufffe") >= 0) {
            for (String subvalue : Utils.split((String)fieldValue, (String)"\ufffe")) {
                if (!FilterContains.compare(subvalue, value)) continue;
                return true;
            }
            return false;
        }
        List<String> fieldTokens = new SimpleText().tokenize(fieldValue);
        List<String> valueTokens = new SimpleText().tokenizeWithWildcards(value);
        if (fieldTokens.size() == 0) {
            return false;
        }
        if (valueTokens.size() == 0) {
            return true;
        }
        if (valueTokens.size() > fieldTokens.size()) {
            return false;
        }
        int i = 0;
        while (i <= fieldTokens.size() - valueTokens.size()) {
            boolean match = true;
            int j = 0;
            while (j < valueTokens.size()) {
                if (!Utils.matchesPattern((String)fieldTokens.get(i + j), (String)valueTokens.get(j))) {
                    match = false;
                    break;
                }
                ++j;
            }
            if (match) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean check(Entity entity) {
        String fieldValue = entity.get(this.m_field);
        return FilterContains.compare(fieldValue, this.m_value);
    }

    @Override
    public void addFields(Set<String> fields) {
        fields.add(this.m_field);
    }
}

