/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.builder;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.fieldanalyzer.TextAnalyzer;
import com.dell.doradus.search.FilteredIterable;
import com.dell.doradus.search.SearchParameters;
import com.dell.doradus.search.Searcher;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.iterator.AllIterable;
import com.dell.doradus.search.query.Query;
import java.util.List;

public abstract class SearchBuilder {
    protected Searcher m_searcher;
    protected SearchParameters m_params;
    protected TableDefinition m_table;
    protected List<Integer> m_shards;

    public void set(Searcher searcher, SearchParameters params, TableDefinition tableDef) {
        this.m_searcher = searcher;
        this.m_params = params;
        this.m_table = tableDef;
    }

    public void set(List<Integer> shards) {
        this.m_shards = shards;
    }

    public FilteredIterable create(Iterable<ObjectID> sequence, Filter filter) {
        return new FilteredIterable(this.m_searcher, filter, sequence, this.m_table);
    }

    public AllIterable all() {
        return new AllIterable(this.m_table, this.m_shards, this.m_params.continuation, this.m_params.inclusive);
    }

    public FieldAnalyzer analyzer(String field) {
        FieldDefinition f = this.m_table.getFieldDef(field);
        if (f == null || !f.isScalarField()) {
            return TextAnalyzer.instance();
        }
        return FieldAnalyzer.findAnalyzer(f);
    }

    public abstract FilteredIterable search(Query var1);

    public abstract Filter filter(Query var1);
}

