/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.builder;

import com.dell.doradus.fieldanalyzer.DateAnalyzer;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.fieldanalyzer.IntegerAnalyzer;
import com.dell.doradus.fieldanalyzer.OpaqueTextAnalyzer;
import com.dell.doradus.fieldanalyzer.TextAnalyzer;
import com.dell.doradus.search.FilteredIterable;
import com.dell.doradus.search.analyzer.DateTrie;
import com.dell.doradus.search.analyzer.NumericTrie;
import com.dell.doradus.search.builder.SearchBuilder;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.filter.FilterRange;
import com.dell.doradus.search.filter.FilterRangeDate;
import com.dell.doradus.search.filter.FilterRangeInt;
import com.dell.doradus.search.iterator.TermsIterable;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.RangeQuery;
import com.dell.doradus.service.spider.SpiderHelper;
import java.util.Date;
import java.util.List;

public class BuilderRange
extends SearchBuilder {
    private static final long MAXIMUM_VALUE = 0x4000000000000L;

    @Override
    public FilteredIterable search(Query query) {
        RangeQuery qu = (RangeQuery)query;
        String field = qu.field;
        if (field == null || "*".equals(field) || "".equals(field)) {
            return null;
        }
        FieldAnalyzer analyzer = this.analyzer(field);
        TermsIterable terms = new TermsIterable(this.m_table, this.m_shards, this.m_params.continuation, this.m_params.inclusive);
        if (analyzer instanceof DateAnalyzer) {
            DateTrie dateTrie = new DateTrie();
            Date minimum = dateTrie.parse("0001-01-01 00:00:00");
            Date maximum = dateTrie.parse("9999-01-01 00:00:00");
            List<String> years = SpiderHelper.getTerms(this.m_table, field, "year/", 100);
            if (years.size() == 100) {
                return null;
            }
            if (years.size() > 0) {
                String minYear = years.get(0).substring(5);
                String maxYear = years.get(years.size() - 1).substring(5);
                minimum = dateTrie.parse(String.valueOf(minYear) + "-01-01 00:00:00");
                maximum = dateTrie.parse(String.valueOf(maxYear) + "-12-31 23:59:59");
                maximum.setTime(maximum.getTime() + 1000L);
            }
            if (qu.min != null) {
                minimum = dateTrie.parse(qu.min);
                if (!qu.minInclusive) {
                    minimum.setTime(minimum.getTime() + 1000L);
                }
            }
            if (qu.max != null) {
                maximum = dateTrie.parse(qu.max);
                if (qu.maxInclusive) {
                    maximum.setTime(maximum.getTime() + 1000L);
                }
            }
            List<String> tokens = new DateTrie(minimum, maximum).getSearchTerms();
            for (String token : tokens) {
                terms.add(FieldAnalyzer.makeTermKey(field, token));
            }
        } else if (analyzer instanceof IntegerAnalyzer) {
            long minimum = -1125899906842624L;
            long maximum = 0x4000000000000L;
            if (qu.min != null) {
                minimum = Long.parseLong(qu.min);
                if (!qu.minInclusive) {
                    ++minimum;
                }
            }
            if (qu.max != null) {
                maximum = Long.parseLong(qu.max);
                if (qu.maxInclusive) {
                    ++maximum;
                }
            }
            List<String> tokens = new NumericTrie(32, minimum, maximum).getSearchTerms();
            for (String token : tokens) {
                terms.add(FieldAnalyzer.makeTermKey(field, token));
            }
        } else {
            String min = qu.min;
            if (min == null) {
                min = "";
            } else if (!qu.minInclusive) {
                min = String.valueOf(min) + "\u0000";
            }
            min = min.toLowerCase();
            String max = qu.max;
            if (max == null) {
                max = "\uffff";
            } else if (qu.maxInclusive) {
                max = String.valueOf(max) + "\u0000";
            }
            max = max.toLowerCase();
            if (analyzer instanceof TextAnalyzer) {
                min = OpaqueTextAnalyzer.getOpaqueTerm(min);
                max = OpaqueTextAnalyzer.getOpaqueTerm(max);
            }
            int idx = 0;
            while (min.length() > idx && max.length() > idx && min.charAt(idx) == max.charAt(idx)) {
                ++idx;
            }
            String prefix = min.substring(0, idx);
            List<String> counters = SpiderHelper.getTerms(this.m_table, field, prefix, 100);
            if (counters.size() >= 100) {
                return null;
            }
            for (String val : counters) {
                if (val.startsWith("'") && val.endsWith("'")) {
                    val = val.substring(1, val.length() - 1);
                }
                if (val.compareTo(min) < 0 || val.compareTo(max) >= 0) continue;
                terms.add(FieldAnalyzer.makeTermKey(field, val));
            }
        }
        return this.create(terms, null);
    }

    @Override
    public Filter filter(Query query) {
        RangeQuery qu = (RangeQuery)query;
        String field = qu.field;
        if (field == null || "*".equals(field) || "".equals(field)) {
            throw new IllegalArgumentException("all-field range query not supported");
        }
        FieldAnalyzer analyzer = this.analyzer(field);
        if (analyzer instanceof DateAnalyzer) {
            return new FilterRangeDate(qu);
        }
        if (analyzer instanceof IntegerAnalyzer) {
            return new FilterRangeInt(qu);
        }
        return new FilterRange(qu);
    }
}

