/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.builder;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.search.FilteredIterable;
import com.dell.doradus.search.builder.SearchBuilder;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.filter.FilterMVSContains;
import com.dell.doradus.search.filter.FilterMVSEquals;
import com.dell.doradus.search.filter.FilterNot;
import com.dell.doradus.search.filter.FilterOr;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.MVSBinaryQuery;
import com.dell.doradus.search.query.Query;

public class BuilderMVSBinary
extends SearchBuilder {
    @Override
    public FilteredIterable search(Query query) {
        MVSBinaryQuery qu = (MVSBinaryQuery)query;
        if (!LinkQuery.ANY.equals(qu.quantifier)) {
            return null;
        }
        return this.m_searcher.search(this.m_params, this.m_table, qu.innerQuery);
    }

    @Override
    public Filter filter(Query query) {
        MVSBinaryQuery qu = (MVSBinaryQuery)query;
        if (qu.innerQuery.field == null || qu.innerQuery.field.length() == 0 || qu.innerQuery.field.equals("*")) {
            throw new IllegalArgumentException("all-fields MVS query not supported");
        }
        FieldDefinition f = this.m_table.getFieldDef(qu.innerQuery.field);
        if (f != null && f.isGroupField()) {
            FilterOr filter = new FilterOr();
            for (FieldDefinition nested : f.getNestedFields()) {
                if (!nested.isScalarField()) continue;
                Filter inner = null;
                if (BinaryQuery.EQUALS.equals(qu.innerQuery.operation)) {
                    inner = new FilterMVSEquals(nested.getName(), qu.innerQuery.value, qu.quantifier);
                } else if (BinaryQuery.CONTAINS.equals(qu.innerQuery.operation)) {
                    inner = new FilterMVSContains(nested.getName(), qu.innerQuery.value, qu.quantifier);
                } else {
                    throw new IllegalArgumentException("operation " + qu.innerQuery.operation + " not supported");
                }
                if (LinkQuery.ALL.equals(qu.quantifier)) {
                    inner = new FilterNot(inner);
                }
                filter.add(inner);
            }
            if (!LinkQuery.ANY.equals(qu.quantifier)) {
                return new FilterNot(filter);
            }
            return filter;
        }
        if (BinaryQuery.EQUALS.equals(qu.innerQuery.operation)) {
            return new FilterMVSEquals(qu.innerQuery.field, qu.innerQuery.value, qu.quantifier);
        }
        if (BinaryQuery.CONTAINS.equals(qu.innerQuery.operation)) {
            return new FilterMVSContains(qu.innerQuery.field, qu.innerQuery.value, qu.quantifier);
        }
        throw new IllegalArgumentException("operation " + qu.innerQuery.operation + " not supported");
    }
}

