/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.builder;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.FilteredIterable;
import com.dell.doradus.search.SearchParameters;
import com.dell.doradus.search.builder.SearchBuilder;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.filter.FilterAll;
import com.dell.doradus.search.filter.FilterLink;
import com.dell.doradus.search.iterator.LinksIterable;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.Query;

public class BuilderLink
extends SearchBuilder {
    @Override
    public FilteredIterable search(Query query) {
        LinkQuery qu = (LinkQuery)query;
        if (!LinkQuery.ANY.equals(qu.quantifier)) {
            return null;
        }
        FieldDefinition link = this.m_table.getFieldDef(qu.link);
        if (link.isGroupField()) {
            return null;
        }
        TableDefinition extent = this.m_table.getAppDef().getTableDef(link.getLinkExtent());
        FieldDefinition inverse = extent.getFieldDef(link.getLinkInverse());
        SearchParameters newparams = new SearchParameters();
        newparams.l2r = this.m_params.l2r;
        FilteredIterable inner = this.m_searcher.search(newparams, extent, qu.getInnerQuery());
        if (inverse.isSharded()) {
            LinksIterable seq = new LinksIterable(inverse, this.m_shards, this.m_params.continuation, this.m_params.inclusive, inner);
            return this.create(seq, null);
        }
        LinksIterable seq = new LinksIterable(inverse, null, this.m_params.continuation, this.m_params.inclusive, inner);
        return this.create(seq, null);
    }

    @Override
    public Filter filter(Query query) {
        LinkQuery qu = (LinkQuery)query;
        FieldDefinition link = this.m_table.getFieldDef(qu.link);
        if (link.isGroupField()) {
            for (FieldDefinition l : link.getNestedFields()) {
                if (!l.isLinkField()) continue;
                link = l;
                break;
            }
        }
        TableDefinition extent = this.m_table.getAppDef().getTableDef(link.getLinkExtent());
        SearchParameters newparams = new SearchParameters();
        newparams.l2r = this.m_params.l2r;
        Filter inner = this.m_searcher.filter(newparams, extent, qu.getInnerQuery());
        if (inner == null) {
            inner = new FilterAll();
        }
        FilterLink condition = new FilterLink(this.m_searcher, this.m_table, qu, inner);
        return condition;
    }
}

