/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.builder;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.fieldanalyzer.DateAnalyzer;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.fieldanalyzer.IntegerAnalyzer;
import com.dell.doradus.fieldanalyzer.NullAnalyzer;
import com.dell.doradus.fieldanalyzer.OpaqueTextAnalyzer;
import com.dell.doradus.fieldanalyzer.SimpleTextAnalyzer;
import com.dell.doradus.fieldanalyzer.TextAnalyzer;
import com.dell.doradus.search.FilteredIterable;
import com.dell.doradus.search.analyzer.DateTrie;
import com.dell.doradus.search.analyzer.SimpleText;
import com.dell.doradus.search.builder.SearchBuilder;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.filter.FilterAllFieldsContains;
import com.dell.doradus.search.filter.FilterAllFieldsEquals;
import com.dell.doradus.search.filter.FilterContains;
import com.dell.doradus.search.filter.FilterEquals;
import com.dell.doradus.search.filter.FilterOr;
import com.dell.doradus.search.iterator.AndIterable;
import com.dell.doradus.search.iterator.OrIterable;
import com.dell.doradus.search.iterator.TermsIterable;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.service.spider.SpiderHelper;
import java.util.Date;
import java.util.List;

public class BuilderBinary
extends SearchBuilder {
    @Override
    public FilteredIterable search(Query query) {
        BinaryQuery qu = (BinaryQuery)query;
        String field = qu.field;
        String value = qu.value;
        if ("*".equals(field) || "".equals(field)) {
            field = null;
        }
        if (field == null && "*".equals(value)) {
            return null;
        }
        if (field != null && value == null) {
            return null;
        }
        if (field == null) {
            List<String> fields = SpiderHelper.getFields(this.m_table);
            OrIterable or = new OrIterable(fields.size());
            if (BinaryQuery.EQUALS.equals(qu.operation)) {
                for (String f : fields) {
                    FilteredIterable fi;
                    FieldAnalyzer analyzer = this.analyzer(f);
                    if (!(analyzer instanceof SimpleTextAnalyzer) && !(analyzer instanceof OpaqueTextAnalyzer)) {
                        analyzer = TextAnalyzer.instance();
                    }
                    if ((fi = this.getEquals(f, value, analyzer, qu)) == null) {
                        return this.create(this.all(), this.filter(query));
                    }
                    or.add(fi);
                }
                return this.create(or, null);
            }
            if (BinaryQuery.CONTAINS.equals(qu.operation)) {
                for (String f : fields) {
                    FilteredIterable fi = this.getContains(f, value, TextAnalyzer.instance(), qu);
                    if (fi == null) {
                        return this.create(this.all(), this.filter(query));
                    }
                    or.add(fi);
                }
                return this.create(or, null);
            }
            throw new IllegalArgumentException("operation " + qu.operation + " not supported in l2r filter");
        }
        FieldDefinition f = this.m_table.getFieldDef(field);
        if (f != null && f.isGroupField()) {
            return null;
        }
        FieldAnalyzer analyzer = this.analyzer(field);
        if (BinaryQuery.EQUALS.equals(qu.operation)) {
            FilteredIterable fi = null;
            if (!(analyzer instanceof NullAnalyzer)) {
                fi = this.getEquals(field, value, analyzer, qu);
            }
            if (fi == null) {
                return this.create(this.all(), this.filter(query));
            }
            return fi;
        }
        if (BinaryQuery.CONTAINS.equals(qu.operation)) {
            FilteredIterable fi = this.getContains(field, value, analyzer, qu);
            if (fi == null) {
                return this.create(this.all(), this.filter(query));
            }
            return fi;
        }
        throw new IllegalArgumentException("operation " + qu.operation + " not supported in l2r filter");
    }

    @Override
    public Filter filter(Query query) {
        BinaryQuery qu = (BinaryQuery)query;
        String field = qu.field;
        String value = qu.value;
        if ("*".equals(field) || "".equals(field)) {
            field = null;
        }
        if (field == null && "*".equals(value)) {
            return null;
        }
        if (field == null) {
            if (BinaryQuery.EQUALS.equals(qu.operation)) {
                return new FilterAllFieldsEquals(value);
            }
            if (BinaryQuery.CONTAINS.equals(qu.operation)) {
                return new FilterAllFieldsContains(value);
            }
            throw new IllegalArgumentException("operation " + qu.operation + " not supported in l2r filter");
        }
        FieldDefinition f = this.m_table.getFieldDef(field);
        if (f != null && f.isGroupField()) {
            FilterOr filter = new FilterOr();
            for (FieldDefinition nested : f.getNestedFields()) {
                if (!nested.isScalarField()) continue;
                Filter inner = null;
                if (BinaryQuery.EQUALS.equals(qu.operation)) {
                    inner = new FilterEquals(nested.getName(), value);
                } else if (BinaryQuery.CONTAINS.equals(qu.operation)) {
                    inner = new FilterContains(nested.getName(), value);
                } else {
                    throw new IllegalArgumentException("operation " + qu.operation + " not supported");
                }
                filter.add(inner);
            }
            return filter;
        }
        FieldAnalyzer analyzer = this.analyzer(field);
        if (BinaryQuery.EQUALS.equals(qu.operation)) {
            DateTrie dt;
            Date date;
            if (value != null && analyzer instanceof DateAnalyzer && (date = (dt = new DateTrie()).parse(value)).getTime() % 1000L == 0L) {
                value = dt.format(date);
            }
            return new FilterEquals(field, value);
        }
        if (BinaryQuery.CONTAINS.equals(qu.operation)) {
            if (analyzer instanceof DateAnalyzer) {
                return new FilterEquals(field, String.valueOf(value) + "*");
            }
            return new FilterContains(field, value);
        }
        throw new IllegalArgumentException("operation " + qu.operation + " not supported in l2r filter");
    }

    private FilteredIterable getEquals(String field, String value, FieldAnalyzer analyzer, BinaryQuery query) {
        TermsIterable terms = new TermsIterable(this.m_table, this.m_shards, this.m_params.continuation, this.m_params.inclusive);
        if (analyzer instanceof DateAnalyzer && !value.equals("*")) {
            DateTrie dt = new DateTrie();
            Date date = dt.parse(value);
            terms.add(FieldAnalyzer.makeTermKey(field, dt.format(date)));
            if (date.getTime() % 1000L != 0L) {
                return this.create(terms, new FilterEquals(field, value));
            }
        } else if (analyzer instanceof IntegerAnalyzer && !value.equals("*")) {
            terms.add(FieldAnalyzer.makeTermKey(field, value));
        } else {
            if (analyzer instanceof SimpleTextAnalyzer && !value.equals("*")) {
                FilteredIterable c = this.getContains(field, value, analyzer, query);
                return this.create(c.sequence(), new FilterEquals(field, value));
            }
            value = OpaqueTextAnalyzer.getOpaqueTerm(value);
            if (analyzer instanceof TextAnalyzer) {
                value = "'" + value + "'";
            }
            int idx = value.indexOf(63);
            int idx1 = value.indexOf(42);
            if (idx < 0 || idx > idx1 && idx1 >= 0) {
                idx = idx1;
            }
            if (idx >= 0) {
                String prefix = value.substring(0, idx);
                List<String> counters = SpiderHelper.getTerms(this.m_table, field, prefix, 100);
                if (counters.size() >= 100) {
                    return null;
                }
                for (String val : counters) {
                    if (!Utils.matchesPattern((String)val, (String)value)) continue;
                    terms.add(FieldAnalyzer.makeTermKey(field, val));
                }
            } else {
                terms.add(FieldAnalyzer.makeTermKey(field, value));
            }
        }
        return this.create(terms, null);
    }

    private FilteredIterable getContains(String field, String value, FieldAnalyzer analyzer, BinaryQuery query) {
        if (analyzer instanceof DateAnalyzer) {
            if (value.length() == 23) {
                return this.getEquals(field, value, analyzer, query);
            }
            if (value.length() == 16) {
                value = "minute/" + value;
            } else if (value.length() == 13) {
                value = "hour/" + value;
            } else if (value.length() == 10) {
                value = "day/" + value;
            } else if (value.length() == 7) {
                value = "month/" + value;
            } else if (value.length() == 4) {
                value = "year/" + value;
            } else {
                DateTrie dt = new DateTrie();
                Date date = dt.parse(value);
                value = dt.format(date);
            }
            TermsIterable terms = new TermsIterable(this.m_table, this.m_shards, this.m_params.continuation, this.m_params.inclusive);
            terms.add(FieldAnalyzer.makeTermKey(field, value));
            return this.create(terms, null);
        }
        List<String> tokens = new SimpleText().tokenizeWithWildcards(value);
        if (tokens.size() == 0) {
            return this.create(this.all(), this.filter(query));
        }
        AndIterable and = new AndIterable(tokens.size());
        for (String token : tokens) {
            TermsIterable terms = new TermsIterable(this.m_table, this.m_shards, this.m_params.continuation, this.m_params.inclusive);
            int idx = token.indexOf(63);
            int idx1 = token.indexOf(42);
            if (idx < 0 || idx > idx1 && idx1 >= 0) {
                idx = idx1;
            }
            if (idx >= 0) {
                String prefix = token.substring(0, idx);
                List<String> counters = SpiderHelper.getTerms(this.m_table, field, prefix, 100);
                if (counters.size() >= 100) {
                    return null;
                }
                for (String val : counters) {
                    if (val.charAt(0) == '\'' || !Utils.matchesPattern((String)val, (String)token)) continue;
                    terms.add(FieldAnalyzer.makeTermKey(field, val));
                }
            } else {
                terms.add(FieldAnalyzer.makeTermKey(field, token));
            }
            and.add(terms);
        }
        return this.create(and, tokens.size() > 1 ? this.filter(query) : null);
    }
}

