/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.builder;

import com.dell.doradus.search.FilteredIterable;
import com.dell.doradus.search.analyzer.DateTrie;
import com.dell.doradus.search.builder.SearchBuilder;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.filter.FilterAnd;
import com.dell.doradus.search.iterator.AndIterable;
import com.dell.doradus.search.iterator.NoneIterable;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.RangeQuery;
import com.dell.doradus.service.spider.SpiderService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class BuilderAnd
extends SearchBuilder {
    @Override
    public FilteredIterable search(Query query) {
        AndQuery qu = (AndQuery)query;
        if (qu.subqueries.size() == 0) {
            return this.create(NoneIterable.instance, null);
        }
        List<Integer> shards = this.getShards(qu);
        if (this.m_params.l2r) {
            FilteredIterable seq = this.m_searcher.search(this.m_params, this.m_table, qu.subqueries.get(0), shards);
            FilterAnd filter = new FilterAnd();
            filter.add(seq.filter());
            int i = 1;
            while (i < qu.subqueries.size()) {
                Filter f = this.m_searcher.filter(this.m_params, this.m_table, qu.subqueries.get(i));
                filter.add(f);
                ++i;
            }
            return this.create(seq.sequence(), filter);
        }
        AndIterable iter = new AndIterable(qu.subqueries.size());
        FilterAnd filter = new FilterAnd();
        for (Query q : qu.subqueries) {
            FilteredIterable seq = this.m_searcher.search(this.m_params, this.m_table, q, shards);
            iter.add(seq.sequence());
            filter.add(seq.filter());
        }
        return this.create(iter, filter);
    }

    @Override
    public Filter filter(Query query) {
        AndQuery qu = (AndQuery)query;
        FilterAnd filter = new FilterAnd();
        for (Query q : qu.subqueries) {
            filter.add(this.m_searcher.filter(this.m_params, this.m_table, q));
        }
        return filter;
    }

    private List<Integer> getShards(AndQuery query) {
        if (!this.m_table.isSharded()) {
            return null;
        }
        for (Query q : query.subqueries) {
            List<Integer> shards;
            if (!(q instanceof RangeQuery) || (shards = this.getShards((RangeQuery)q)) == null) continue;
            return shards;
        }
        return null;
    }

    private List<Integer> getShards(RangeQuery query) {
        Date date;
        if (!this.m_table.getShardingField().getName().equals(query.field)) {
            return null;
        }
        Set<Integer> shards = SpiderService.instance().getShards(this.m_table).keySet();
        if (shards.size() == 0) {
            return null;
        }
        int minShard = Integer.MIN_VALUE;
        int maxShard = Integer.MAX_VALUE;
        if (query.min != null) {
            date = new DateTrie().parse(query.min);
            minShard = this.m_table.computeShardNumber(date);
        }
        if (query.max != null) {
            date = new DateTrie().parse(query.max);
            maxShard = this.m_table.computeShardNumber(date);
        }
        ArrayList<Integer> result = new ArrayList<Integer>(shards.size());
        if (minShard <= 0 && maxShard >= 0) {
            result.add(0);
        }
        for (Integer shard : shards) {
            if (shard < minShard || shard > maxShard) continue;
            result.add(shard);
        }
        return result;
    }
}

