/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.analyzer;

import java.util.ArrayList;
import java.util.List;

public class NumericTrie {
    public int bas;
    public long min;
    public long max;

    public NumericTrie(int base) {
        this(base, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public NumericTrie(int bas, long min, long max) {
        this.bas = bas;
        this.min = min;
        this.max = max;
    }

    public List<String> tokenize(long num) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (num < 0L) {
            this.tokenize(tokens, -num, true);
        } else {
            this.tokenize(tokens, num, false);
        }
        return tokens;
    }

    public List<String> getSearchTerms() {
        ArrayList<String> terms = new ArrayList<String>();
        if (this.min < 0L && this.max >= 0L) {
            this.range(terms, 1L, -this.min + 1L, true);
            this.range(terms, 0L, this.max, false);
        } else if (this.min < 0L && this.max < 0L) {
            this.range(terms, -this.max + 1L, -this.min + 1L, true);
        } else {
            this.range(terms, this.min, this.max, false);
        }
        return terms;
    }

    private void tokenize(List<String> terms, long num, boolean lessThanZero) {
        long det = 1L;
        NumericTrie.add(terms, det, num, lessThanZero);
        while (num > 0L) {
            NumericTrie.add(terms, det *= (long)this.bas, num /= (long)this.bas, lessThanZero);
        }
    }

    private void range(List<String> terms, long a, long b, boolean lessThanZero) {
        long x = a;
        long det = 1L;
        while (x < b) {
            if (x == 0L) {
                NumericTrie.add(terms, 1L, 0L, false);
                x = 1L;
                continue;
            }
            if (x == det && x * (long)this.bas <= b) {
                NumericTrie.add(terms, det *= (long)this.bas, 0L, lessThanZero);
                x *= (long)this.bas;
                continue;
            }
            if (x % ((long)this.bas * det) == 0L && x + det * (long)this.bas <= b) {
                det *= (long)this.bas;
                continue;
            }
            if (x + det > b) {
                det /= (long)this.bas;
                continue;
            }
            NumericTrie.add(terms, det, x / det, lessThanZero);
            x += det;
        }
    }

    private static void add(List<String> terms, long det, long num, boolean lessThanZero) {
        StringBuilder sb = new StringBuilder();
        if (det != 1L) {
            sb.append(det);
            sb.append('/');
        }
        if (lessThanZero) {
            sb.append('-');
        }
        sb.append(num);
        terms.add(sb.toString());
    }
}

