/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.analyzer;

import com.dell.doradus.common.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class DateTrie {
    public Date min;
    public Date max;
    private static TimeZone m_utc = TimeZone.getTimeZone("GMT");

    public DateTrie() {
        Calendar cal = GregorianCalendar.getInstance(m_utc);
        cal.set(0, 1, 1);
        this.min = cal.getTime();
        cal.set(9999, 1, 1);
        this.max = cal.getTime();
    }

    public DateTrie(Date min, Date max) {
        this.min = min;
        this.max = max;
    }

    public Date parse(String date) {
        try {
            return Utils.dateFromString((String)date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot parse date: '" + date + "'. Only the following formats are accepted: yyyy; yyy-MM; yyyy-MM-dd; yyyy-MM-dd HH; yyyy-MM-dd HH:mm; yyyy-MM-dd HH:mm:ss; yyyy-MM-dd HH:mm:ss.SSS");
        }
    }

    public String format(Date date) {
        return Utils.formatDateUTC((Date)date);
    }

    public List<String> tokenize(Date date) {
        ArrayList<String> tokens = new ArrayList<String>();
        this.addSecond(tokens, date);
        this.addMinute(tokens, date);
        this.addHour(tokens, date);
        this.addDay(tokens, date);
        this.addMonth(tokens, date);
        this.addYear(tokens, date);
        return tokens;
    }

    public List<String> getSearchTerms() {
        ArrayList<String> terms = new ArrayList<String>();
        Calendar cal = GregorianCalendar.getInstance(m_utc);
        Calendar cal2 = GregorianCalendar.getInstance(m_utc);
        cal.setTime(this.min);
        cal2.setTime(cal.getTime());
        cal2.add(13, 1);
        while (cal.get(13) != 0 && cal2.getTime().compareTo(this.max) <= 0) {
            this.addSecond(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(13, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(12, 1);
        while (cal.get(12) != 0 && cal2.getTime().compareTo(this.max) <= 0) {
            this.addMinute(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(12, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(11, 1);
        while (cal.get(11) != 0 && cal2.getTime().compareTo(this.max) <= 0) {
            this.addHour(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(11, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(5, 1);
        while (cal.get(5) != 1 && cal2.getTime().compareTo(this.max) <= 0) {
            this.addDay(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(5, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(2, 1);
        while (cal.get(2) != 0 && cal2.getTime().compareTo(this.max) <= 0) {
            this.addMonth(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(2, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(1, 1);
        while (cal2.getTime().compareTo(this.max) <= 0) {
            this.addYear(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(1, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(2, 1);
        while (cal2.getTime().compareTo(this.max) <= 0) {
            this.addMonth(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(2, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(5, 1);
        while (cal2.getTime().compareTo(this.max) <= 0) {
            this.addDay(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(5, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(11, 1);
        while (cal2.getTime().compareTo(this.max) <= 0) {
            this.addHour(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(11, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(12, 1);
        while (cal2.getTime().compareTo(this.max) <= 0) {
            this.addMinute(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(12, 1);
        }
        cal2.setTime(cal.getTime());
        cal2.add(13, 1);
        while (cal2.getTime().compareTo(this.max) <= 0) {
            this.addSecond(terms, cal.getTime());
            cal.setTime(cal2.getTime());
            cal2.add(13, 1);
        }
        return terms;
    }

    private void addSecond(List<String> terms, Date d) {
        terms.add(Utils.formatDateUTC((Date)d, (int)13));
    }

    private void addMinute(List<String> terms, Date d) {
        terms.add("minute/" + Utils.formatDateUTC((Date)d, (int)12));
    }

    private void addHour(List<String> terms, Date d) {
        terms.add("hour/" + Utils.formatDateUTC((Date)d, (int)10));
    }

    private void addDay(List<String> terms, Date d) {
        terms.add("day/" + Utils.formatDateUTC((Date)d, (int)5));
    }

    private void addMonth(List<String> terms, Date d) {
        terms.add("month/" + Utils.formatDateUTC((Date)d, (int)2));
    }

    private void addYear(List<String> terms, Date d) {
        terms.add("year/" + Utils.formatDateUTC((Date)d, (int)1));
    }
}

