/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.search.aggregate.ValueConverter;
import java.util.GregorianCalendar;

class WeekConverter
implements ValueConverter {
    WeekConverter() {
    }

    @Override
    public String convert(String value) {
        try {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            GregorianCalendar c = new GregorianCalendar(year, month - 1, day);
            int weekday = c.get(7);
            int days = WeekConverter.difference(weekday);
            if (days != 0) {
                c.add(5, days);
            }
            return String.format("%04d-%02d-%02d 00:00:00", c.get(1), c.get(2) + 1, c.get(5));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int difference(int weekday) {
        switch (weekday) {
            case 3: {
                return -1;
            }
            case 4: {
                return -2;
            }
            case 5: {
                return -3;
            }
            case 6: {
                return -4;
            }
            case 7: {
                return -5;
            }
            case 1: {
                return -6;
            }
        }
        return 0;
    }
}

