/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.search.aggregate.ValueConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

class TimeZoneConverter
implements ValueConverter {
    final SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    final SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TimeZoneConverter(String timeZoneID) {
        this.inputFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        char ch = timeZoneID.charAt(0);
        if (ch == '+' || ch == '-') {
            timeZoneID = "GMT" + timeZoneID;
        } else if (Character.getType(ch) == 9) {
            timeZoneID = "GMT+" + timeZoneID;
        }
        this.outputFormat.setTimeZone(TimeZone.getTimeZone(timeZoneID));
    }

    @Override
    public synchronized String convert(String value) {
        try {
            return this.outputFormat.format(this.inputFormat.parse(value));
        }
        catch (ParseException e) {
            return null;
        }
    }
}

