/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.fieldanalyzer.SimpleTextAnalyzer;
import com.dell.doradus.search.aggregate.ValueTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

class TextTokenizer
implements ValueTokenizer {
    private Collection<String> m_excludes;

    TextTokenizer() {
        this(null);
    }

    TextTokenizer(Collection<String> excludes) {
        this.m_excludes = excludes;
    }

    @Override
    public Collection<String> tokenize(String value) {
        if (value == null) {
            return null;
        }
        List<String> tokens = Arrays.asList(SimpleTextAnalyzer.instance().tokenize(value));
        if (this.m_excludes != null && this.m_excludes.size() != 0) {
            tokens = new ArrayList<String>(tokens);
            tokens.removeAll(this.m_excludes);
        }
        return tokens;
    }
}

