/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.core.ObjectID;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class PrefetchIterator
implements Iterator<ObjectID> {
    protected ObjectID[] m_buffer;
    protected int m_index = 0;
    protected int m_count = 0;
    protected boolean m_hasMore = true;

    PrefetchIterator() {
    }

    protected abstract void fetchBuffer();

    public int bufferSize() {
        return this.m_count - this.m_index;
    }

    @Override
    public boolean hasNext() {
        if (this.m_index == this.m_count && this.m_hasMore) {
            this.fetchBuffer();
        }
        return this.m_hasMore || this.m_index < this.m_count;
    }

    @Override
    public ObjectID next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_buffer[this.m_index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

