/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.search.aggregate.DBEntity;
import com.dell.doradus.search.aggregate.DBEntityIterator;
import java.util.Iterator;

class PrefetchCollection
implements Iterable<DBEntity> {
    private DBEntityIterator m_sourceIterator;

    PrefetchCollection(DBEntityIterator iterator) {
        this.m_sourceIterator = iterator;
        this.m_sourceIterator.prefetchBuffer(Math.max(0, 10000 - this.m_sourceIterator.counter().value()));
    }

    @Override
    public Iterator<DBEntity> iterator() {
        return new PrefetchIterator();
    }

    class PrefetchIterator
    implements Iterator<DBEntity> {
        int m_index;

        PrefetchIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_index < PrefetchCollection.this.m_sourceIterator.buffer().size();
        }

        @Override
        public DBEntity next() {
            if (this.hasNext()) {
                return PrefetchCollection.this.m_sourceIterator.buffer().get(this.m_index++);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

