/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.QueryExecutor;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.LinkInfo;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.util.LRUCache;
import java.util.ArrayList;
import java.util.List;

class PathEntry {
    static final boolean USEQUERYCACHE = true;
    static final int QUERYCACHECAPACITY = 10000;
    static final String ANY = "*";
    TableDefinition tableDef;
    String name;
    Query query;
    String queryText;
    LRUCache<ObjectID, Boolean> queryCache;
    List<LinkInfo> nestedLinks;
    Filter filter;
    boolean isLink;
    int groupIndex = 0;
    List<Integer> groupIndexes = new ArrayList<Integer>();
    List<Integer> matchingGroupIndexes = new ArrayList<Integer>();
    List<String> fieldNames = new ArrayList<String>();
    List<PathEntry> leafBranches = new ArrayList<PathEntry>();
    List<PathEntry> linkBranches = new ArrayList<PathEntry>();
    List<PathEntry> branches = new ArrayList<PathEntry>();

    public PathEntry(TableDefinition tableDef, int groupIndex) {
        this.tableDef = tableDef;
        this.groupIndex = groupIndex;
    }

    public PathEntry(List<AggregationGroupItem> path, int index, int groupIndex, boolean isGroupPath) {
        AggregationGroupItem item = path.get(index);
        this.tableDef = item.tableDef;
        this.groupIndex = groupIndex;
        this.name = item.name;
        this.nestedLinks = item.nestedLinks;
        this.isLink = item.isLink;
        PathEntry entry = null;
        if (index == path.size() - 1) {
            if (this.isLink) {
                entry = new PathEntry(item.tableDef, groupIndex);
                entry.name = ANY;
                entry.isLink = false;
                this.add(entry, isGroupPath);
            } else if (this.name != ANY) {
                this.fieldNames.add(this.name);
            }
        } else {
            entry = new PathEntry(path, index + 1, groupIndex, isGroupPath);
            this.add(entry, isGroupPath);
        }
        if (item.query != null) {
            PathEntry.setQuery(item, isGroupPath ? this : entry);
        }
    }

    void add(PathEntry entry, boolean isGroupPath) {
        this.branches.add(entry);
        if (entry.isLink) {
            if (isGroupPath) {
                this.linkBranches.add(entry);
            }
        } else {
            if (isGroupPath) {
                this.leafBranches.add(entry);
            }
            if (!entry.name.startsWith(ANY) && !this.fieldNames.contains(entry.name)) {
                this.fieldNames.add(entry.name);
            }
        }
    }

    static void setQuery(AggregationGroupItem item, PathEntry entry) {
        entry.query = item.query;
        if (entry.query != null) {
            entry.queryText = item.query.toString();
            entry.queryCache = new LRUCache(10000);
            QueryExecutor qe = new QueryExecutor(item.tableDef);
            entry.filter = qe.filter(item.query);
        }
    }

    void addGroupPath(PathEntry anotherPath) {
        if (this.name.equals(anotherPath.name)) {
            this.mergeParameters(this, anotherPath);
            if (this.branches.size() == 0 || anotherPath.branches.size() == 0) {
                this.matchingGroupIndexes.add(anotherPath.groupIndex);
            } else {
                this.branches.get(0).addGroupPath(anotherPath.branches.get(0));
            }
        } else {
            this.groupIndexes.add(anotherPath.groupIndex);
            this.mergeBranch(anotherPath);
        }
    }

    void mergeBranch(PathEntry entry) {
        String name = entry.name;
        PathEntry branch = null;
        int i = 0;
        while (i < this.branches.size()) {
            if (this.branches.get((int)i).name.equals(name)) {
                branch = this.branches.get(i);
                this.mergeParameters(branch, entry);
                break;
            }
            ++i;
        }
        if (branch == null) {
            this.add(entry, true);
        } else if (entry.branches.size() > 0) {
            branch.mergeBranch(entry.branches.get(0));
        }
    }

    boolean checkCondition(Entity entity) {
        if (this.queryCache.containsKey(entity.id())) {
            return (Boolean)this.queryCache.get(entity.id());
        }
        boolean result = this.filter.check(entity);
        this.queryCache.put(entity.id(), result);
        return result;
    }

    void mergeParameters(PathEntry entry1, PathEntry entry2) {
        for (String name : entry2.fieldNames) {
            if (entry1.fieldNames.contains(name)) continue;
            entry1.fieldNames.add(name);
        }
        if (entry2.query != null) {
            if (entry1.query != null) {
                AndQuery query = new AndQuery();
                query.subqueries.add(entry1.query);
                query.subqueries.add(entry2.query);
                entry1.query = query;
            } else {
                entry1.query = entry2.query;
                entry1.queryCache = new LRUCache(10000);
            }
            QueryExecutor qe = new QueryExecutor(entry1.tableDef);
            entry1.filter = qe.filter(entry1.query);
        }
    }

    boolean hasUnderlyingQuery() {
        if (this.query != null) {
            return true;
        }
        for (PathEntry child : this.linkBranches) {
            if (!child.hasUnderlyingQuery()) continue;
            return true;
        }
        return false;
    }

    String toString(String indent) {
        String text = String.valueOf(indent) + this.name;
        for (PathEntry entry : this.branches) {
            text = String.valueOf(text) + "\n" + entry.toString(String.valueOf(indent) + "  ");
        }
        return text;
    }

    public String toString() {
        return this.toString("");
    }

    public static String toString(List<AggregationGroupItem> path) {
        if (path == null || path.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(path.get((int)0).name);
        int i = 1;
        while (i < path.size()) {
            builder.append('.').append(path.get((int)i).name);
            ++i;
        }
        return builder.toString();
    }
}

