/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.search.analyzer.DateTrie;
import com.dell.doradus.service.spider.SpiderHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class MaxMinHelper {
    public static ByteBuffer toByteBuffer(String value) {
        return ByteBuffer.wrap(Utils.toBytes((String)value));
    }

    public static String toString(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return Utils.toString((byte[])bytes);
    }

    public static Date getMaxDate(TableDefinition tableDefinition, String dateField) throws IOException {
        Set<Integer> shards = SpiderHelper.getShards(tableDefinition);
        String max = "";
        List<String> res = null;
        for (Integer shard : shards) {
            res = SpiderHelper.getTerms(tableDefinition, shard, dateField, "9999", "0000", 1, true);
            if (res.size() <= 0 || max.compareTo(res.get(0)) >= 0) continue;
            max = res.get(0);
        }
        if (max.length() == 0) {
            return null;
        }
        return new DateTrie().parse(max);
    }

    public static Date getMinDate(TableDefinition tableDefinition, String dateField) throws IOException {
        List<String> dates = SpiderHelper.getTerms(tableDefinition, dateField, "", 1);
        if (dates.size() == 0) {
            return null;
        }
        return new DateTrie().parse(dates.get(0));
    }
}

