/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Matcher {
    private Set<String> m_values;
    private List<String> m_templates;

    public Matcher(Collection<String> values) {
        if (values == null) {
            return;
        }
        this.m_values = new HashSet<String>();
        this.m_templates = new ArrayList<String>();
        for (String value : values) {
            if (value == null) {
                this.m_values.add(null);
                continue;
            }
            if (value.indexOf(42) >= 0 || value.indexOf(63) >= 0) {
                this.m_templates.add(value);
                continue;
            }
            this.m_values.add(value.toLowerCase());
        }
        if (this.m_values.size() == 0) {
            this.m_values = null;
        }
        if (this.m_templates.size() == 0) {
            this.m_templates = null;
        }
    }

    public boolean match(String value) {
        if (value == null) {
            return this.m_values != null && this.m_values.contains(null);
        }
        if (this.m_values != null && this.m_values.contains(value)) {
            return true;
        }
        if (this.m_templates == null) {
            return false;
        }
        for (String template : this.m_templates) {
            if (!Utils.matchesPattern((String)value, (String)template)) continue;
            return true;
        }
        return false;
    }
}

