/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.aggregate.BatchConverter;
import com.dell.doradus.search.aggregate.CaseConverter;
import com.dell.doradus.search.aggregate.DateConverter;
import com.dell.doradus.search.aggregate.GroupOutputParameters;
import com.dell.doradus.search.aggregate.PathEntry;
import com.dell.doradus.search.aggregate.TextTokenizer;
import com.dell.doradus.search.aggregate.TimeZoneConverter;
import com.dell.doradus.search.aggregate.ValueConverter;
import com.dell.doradus.search.aggregate.ValueExcludeInclude;
import com.dell.doradus.search.aggregate.ValueTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class GroupPath
extends PathEntry {
    List<ValueConverter> converters;
    ValueExcludeInclude excludeinclude;
    ValueTokenizer tokenizer;
    GroupOutputParameters groupOutputParameters;
    String path;
    AggregationGroup aggregationGroup;

    public GroupPath(AggregationGroup group, int groupIndex) {
        super(group.items, 0, groupIndex, true);
        this.path = group.name != null ? group.name : GroupPath.toString(group.items);
    }

    static GroupPath createGroupPath(TableDefinition tableDef, AggregationGroup path, int index) {
        GroupOutputParameters outputParams = new GroupOutputParameters(path.selection, path.selectionValue);
        GroupPath entry = new GroupPath(path, index);
        entry.groupOutputParameters = new GroupOutputParameters(path.selection, path.selectionValue);
        if (path.tocase != null || path.truncate != null || path.batch != null) {
            entry.converters = new ArrayList<ValueConverter>();
            if (path.tocase != null) {
                entry.converters.add(CaseConverter.getConverter(path.tocase));
            }
            if (path.truncate != null) {
                if (path.timeZone != null) {
                    entry.converters.add(new TimeZoneConverter(path.timeZone));
                }
                entry.converters.add(DateConverter.getConverter(path.truncate));
            }
            if (path.batch != null) {
                entry.converters.add(BatchConverter.getConverter(path.batch));
            }
        }
        if (path.exclude != null || path.include != null) {
            entry.excludeinclude = new ValueExcludeInclude(path.exclude, path.include);
        }
        if (path.stopWords != null) {
            entry.tokenizer = new TextTokenizer(path.stopWords);
        }
        entry.groupOutputParameters = outputParams;
        entry.aggregationGroup = path;
        return entry;
    }

    void addValueKeys(Set<String> keys, String value) {
        if (this.excludeinclude != null && !this.excludeinclude.accept(value)) {
            return;
        }
        if (value != null) {
            if (this.converters != null) {
                for (ValueConverter converter : this.converters) {
                    value = converter.convert(value);
                }
            }
            if (this.tokenizer != null) {
                Collection<String> tokens = this.tokenizer.tokenize(value);
                if (tokens != null && tokens.size() > 0) {
                    keys.addAll(tokens);
                }
                return;
            }
        }
        keys.add(value == null ? "\u0000(null)" : value);
    }
}

