/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.FieldType;
import com.dell.doradus.search.aggregate.Aggregate;
import com.dell.doradus.search.aggregate.BigIntegerAverageGroup;
import com.dell.doradus.search.aggregate.BigIntegerSumGroup;
import com.dell.doradus.search.aggregate.CountGroup;
import com.dell.doradus.search.aggregate.DateAverageGroup;
import com.dell.doradus.search.aggregate.DistinctGroup;
import com.dell.doradus.search.aggregate.DoubleAverageGroup;
import com.dell.doradus.search.aggregate.DoubleMaxGroup;
import com.dell.doradus.search.aggregate.DoubleMinGroup;
import com.dell.doradus.search.aggregate.DoubleSumGroup;
import com.dell.doradus.search.aggregate.GroupOutputParameters;
import com.dell.doradus.search.aggregate.LongMaxGroup;
import com.dell.doradus.search.aggregate.LongMinGroup;
import com.dell.doradus.search.aggregate.StringMaxGroup;
import com.dell.doradus.search.aggregate.StringMinGroup;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

abstract class Group {
    static Logger log = Aggregate.log;
    static final String SPECIAL_GROUP_NAME_PREFIX = "\u0000";
    static final String NULL_GROUP_NAME = "\u0000(null)";
    static final String COMPOSITE_GROUP_NAME = "\u0000*";
    String m_key;
    HashMap<String, Group> m_subgroups;
    List<String> m_definedselection;

    Group(String key) {
        this.m_key = key;
    }

    abstract void update(String var1);

    abstract Object getMetric();

    Group subgroup(String key) {
        Group subgroup;
        if (this.m_subgroups == null) {
            this.m_subgroups = new HashMap();
        }
        if ((subgroup = this.m_subgroups.get(key)) == null) {
            subgroup = this.createSubgroup(key);
            this.m_subgroups.put(key, subgroup);
        }
        return subgroup;
    }

    Group createSubgroup(String key) {
        try {
            return (Group)this.getClass().getDeclaredConstructor(String.class).newInstance(key);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create group instance", e);
        }
    }

    void defineGroupsSelection(List<String> groupkeys) {
        this.m_definedselection = groupkeys;
    }

    Collection<Group> subgroups(GroupOutputParameters outputParameter) {
        if (this.m_subgroups == null) {
            return null;
        }
        if (this.m_definedselection != null) {
            ArrayList<Group> list = new ArrayList<Group>();
            for (String groupkey : this.m_definedselection) {
                Group selectedGroup = this.m_subgroups.get(groupkey);
                if (selectedGroup == null) continue;
                list.add(selectedGroup);
            }
            return list;
        }
        return outputParameter.sortGroups(this.m_subgroups.values());
    }

    static Group getGroup(String function, FieldType ft) {
        if (function.equals("COUNT")) {
            return new CountGroup("");
        }
        if (function.equals("DISTINCT")) {
            return new DistinctGroup("");
        }
        if (function.equals("MIN")) {
            if (ft != null && (ft == FieldType.LONG || ft == FieldType.INTEGER)) {
                return new LongMinGroup("");
            }
            if (ft != null && (ft == FieldType.FLOAT || ft == FieldType.DOUBLE)) {
                return new DoubleMinGroup("");
            }
            return new StringMinGroup("");
        }
        if (function.equals("MAX")) {
            if (ft != null && (ft == FieldType.LONG || ft == FieldType.INTEGER)) {
                return new LongMaxGroup("");
            }
            if (ft != null && (ft == FieldType.FLOAT || ft == FieldType.DOUBLE)) {
                return new DoubleMaxGroup("");
            }
            return new StringMaxGroup("");
        }
        if (function.equals("AVERAGE")) {
            if (ft != null && (ft == FieldType.LONG || ft == FieldType.INTEGER)) {
                return new BigIntegerAverageGroup("");
            }
            if (ft != null && (ft == FieldType.FLOAT || ft == FieldType.DOUBLE)) {
                return new DoubleAverageGroup("");
            }
            if (ft != null && ft == FieldType.TIMESTAMP) {
                return new DateAverageGroup("");
            }
            throw new IllegalArgumentException("AVERAGE aggretate function is applicable to numeric fields only");
        }
        if (function.equals("SUM")) {
            if (ft != null && (ft == FieldType.LONG || ft == FieldType.INTEGER)) {
                return new BigIntegerSumGroup("");
            }
            if (ft != null && (ft == FieldType.FLOAT || ft == FieldType.DOUBLE)) {
                return new DoubleSumGroup("");
            }
            throw new IllegalArgumentException("SUM aggretate function is applicable to numeric fields only");
        }
        throw new IllegalArgumentException("Unsupported aggretate function: " + function);
    }

    static int compare(Group group1, Group group2) {
        Object metric1 = group1.getMetric();
        Object metric2 = group2.getMetric();
        if (metric1 != null && metric2 != null) {
            if (metric1 instanceof Long && metric2 instanceof Long) {
                return ((Long)metric1).compareTo((Long)metric2);
            }
            if (metric1 instanceof BigInteger && metric2 instanceof BigInteger) {
                return ((BigInteger)metric1).compareTo((BigInteger)metric2);
            }
            if (metric1 instanceof Double && metric2 instanceof Double) {
                return ((Double)metric1).compareTo((Double)metric2);
            }
            return metric1.toString().compareTo(metric2.toString());
        }
        if (metric1 != null) {
            return 1;
        }
        if (metric2 != null) {
            return -1;
        }
        return 0;
    }

    public String getDisplayName() {
        if (!this.m_key.contains(SPECIAL_GROUP_NAME_PREFIX)) {
            return this.m_key;
        }
        return this.m_key.replace(SPECIAL_GROUP_NAME_PREFIX, "");
    }

    public String getMetricValue() {
        Object metric = this.getMetric();
        return metric == null ? "" : metric.toString();
    }

    public int compareName(Group anotherGroup) {
        return this.m_key.compareTo(anotherGroup.m_key);
    }

    public boolean isComposite() {
        return this.m_key == COMPOSITE_GROUP_NAME;
    }
}

