/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.search.aggregate.QuarterConverter;
import com.dell.doradus.search.aggregate.ValueConverter;
import com.dell.doradus.search.aggregate.WeekConverter;

class DateConverter
implements ValueConverter {
    private static final String truncatePattern = "yyyy-01-01 00:00:00";
    private int m_truncateIndex;

    DateConverter(int truncateIndex) {
        this.m_truncateIndex = truncateIndex;
    }

    @Override
    public String convert(String value) {
        if (value.length() < this.m_truncateIndex) {
            return value;
        }
        return String.valueOf(value.substring(0, this.m_truncateIndex)) + truncatePattern.substring(this.m_truncateIndex);
    }

    public static ValueConverter getConverter(String parameter) {
        if ("SECOND".equals(parameter = parameter.toUpperCase())) {
            return new DateConverter(19);
        }
        if ("MINUTE".equals(parameter)) {
            return new DateConverter(17);
        }
        if ("HOUR".equals(parameter)) {
            return new DateConverter(13);
        }
        if ("DAY".equals(parameter)) {
            return new DateConverter(11);
        }
        if ("WEEK".equals(parameter)) {
            return new WeekConverter();
        }
        if ("MONTH".equals(parameter)) {
            return new DateConverter(8);
        }
        if ("QUARTER".equals(parameter)) {
            return new QuarterConverter();
        }
        if ("YEAR".equals(parameter)) {
            return new DateConverter(5);
        }
        throw new IllegalArgumentException("Illegagal TRUNCATE parameter: " + parameter);
    }
}

