/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.aggregate.DBEntitySequenceFactory;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.LinkList;
import com.dell.doradus.search.aggregate.PrefetchIterator;
import com.dell.doradus.search.util.LRUCache;
import java.util.List;

class DBLinkIterator
extends PrefetchIterator {
    private String m_link;
    private ObjectID m_id;
    private String m_category;
    private String m_cachecategory;
    private int m_capacity;
    private DBEntitySequenceFactory m_factory;
    private TableDefinition m_tableDef;

    DBLinkIterator(Entity entity, String link, LinkList linkList, int capacity, DBEntitySequenceFactory factory, String category) {
        this.m_category = category;
        this.m_tableDef = entity.getTableDef();
        this.m_id = entity.id();
        this.m_link = link;
        this.m_factory = factory;
        this.m_capacity = capacity;
        this.m_cachecategory = DBEntitySequenceFactory.toIteratorCategory(entity.getTableDef().getTableName(), this.m_link, null);
        this.setValues(linkList, 0);
    }

    private void setValues(LinkList values, int index) {
        this.m_buffer = values.links;
        this.m_hasMore = values.hasMore;
        this.m_index = index;
        this.m_count = this.m_buffer.length;
    }

    @Override
    protected void fetchBuffer() {
        String key;
        ObjectID continuationLink = this.m_buffer.length == 0 ? null : this.m_buffer[this.m_buffer.length - 1];
        LRUCache<String, LinkList> cache = this.m_factory.getContinuationLinkCache(this.m_cachecategory);
        LinkList continuationcolumns = (LinkList)cache.get(key = continuationLink == null ? this.m_id.toString() : String.format("%s:%s", this.m_id.toString(), continuationLink.toString()));
        if (continuationcolumns == null) {
            List<ObjectID> fetchedLinks = this.m_factory.fetchLinks(this.m_tableDef, this.m_id, this.m_link, continuationLink, this.m_capacity, this.m_category);
            continuationcolumns = new LinkList(fetchedLinks, this.m_capacity);
            cache.put(key, continuationcolumns);
        }
        this.setValues(continuationcolumns, continuationLink == null ? 0 : 1);
    }
}

