/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.search.aggregate.EntitySequenceOptions;
import com.dell.doradus.search.util.LRUCache;

public class DBEntitySequenceOptions
extends EntitySequenceOptions {
    public final int entityBuffer;
    public final int linkBuffer;
    public final int initialLinkBuffer;
    public final int initialLinkBufferDimension;
    public final int initialScalarBuffer;
    public static final DBEntitySequenceOptions defaultOptions = new DBEntitySequenceOptions(ServerConfig.getInstance().dbesoptions_entityBuffer, ServerConfig.getInstance().dbesoptions_linkBuffer, ServerConfig.getInstance().dbesoptions_initialLinkBuffer, ServerConfig.getInstance().dbesoptions_initialLinkBufferDimension, ServerConfig.getInstance().dbesoptions_initialScalarBuffer);

    public DBEntitySequenceOptions(int entityBuffer, int linkBuffer, int initialLinkBuffer, int initalLinkBufferDimension, int initialScalarBuffer) {
        this.entityBuffer = entityBuffer;
        this.linkBuffer = linkBuffer;
        this.initialLinkBuffer = initialLinkBuffer;
        this.initialLinkBufferDimension = initalLinkBufferDimension;
        this.initialScalarBuffer = initialScalarBuffer;
    }

    <K, T> DBEntitySequenceOptions adjustEntityBuffer(LRUCache<K, T> cache) {
        return new DBEntitySequenceOptions(Math.min(cache.getCapacity(), this.entityBuffer), this.linkBuffer, this.initialLinkBuffer, this.initialLinkBufferDimension, this.initialScalarBuffer);
    }

    <K, T> DBEntitySequenceOptions adjustInitialLinkBufferDimension(LRUCache<K, T> cache) {
        return new DBEntitySequenceOptions(this.entityBuffer, this.linkBuffer, this.initialLinkBuffer, Math.min(cache.getCapacity(), this.initialLinkBufferDimension), this.initialScalarBuffer);
    }

    DBEntitySequenceOptions setInitialLinkBufferDimension(int value) {
        return new DBEntitySequenceOptions(this.entityBuffer, this.linkBuffer, this.initialLinkBuffer, value, this.initialScalarBuffer);
    }
}

