/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.aggregate.DBEntity;
import com.dell.doradus.search.aggregate.DBEntityCollector;
import com.dell.doradus.search.aggregate.DBEntityIterator;
import com.dell.doradus.search.aggregate.DBEntityRootCollection;
import com.dell.doradus.search.aggregate.DBEntitySequenceOptions;
import com.dell.doradus.search.aggregate.DBLinkIterator;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.aggregate.EntitySequenceFactory;
import com.dell.doradus.search.aggregate.EntitySequenceOptions;
import com.dell.doradus.search.aggregate.LinkList;
import com.dell.doradus.search.util.LRUCache;
import com.dell.doradus.service.spider.SpiderHelper;
import com.dell.doradus.utilities.Timer;
import com.dell.doradus.utilities.TimerGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEntitySequenceFactory
implements EntitySequenceFactory {
    static final String ALLSCALARMARK = "*";
    private static final List<String> ALLSCALARFIELDS = new ArrayList<String>(Arrays.asList("*"));
    private Logger log = LoggerFactory.getLogger((String)DBEntitySequenceFactory.class.getSimpleName());
    TimerGroup timers = new TimerGroup(String.valueOf(DBEntitySequenceFactory.class.getSimpleName()) + ".timing", 10000000000L);
    private Map<String, LRUCache<ObjectID, LinkList>> m_linkCache;
    private Map<String, LRUCache<ObjectID, Map<String, String>>> m_scalarCache = new HashMap<String, LRUCache<ObjectID, Map<String, String>>>();
    private Map<String, LRUCache<String, LinkList>> m_continuationlinkCache;
    private int m_scalarCacheCapacity;
    private int m_linkCacheCapacity;
    private int m_continuationlinkCacheCapacity;
    private DBEntitySequenceOptions m_options;

    public DBEntitySequenceFactory() {
        this(10000, 10000, 10000, DBEntitySequenceOptions.defaultOptions);
    }

    public DBEntitySequenceFactory(int scalarCacheCapacity, int linkCacheCapacity, int continuationlinkCacheCapacity, DBEntitySequenceOptions options) {
        this.m_linkCache = new HashMap<String, LRUCache<ObjectID, LinkList>>();
        this.m_continuationlinkCache = new HashMap<String, LRUCache<String, LinkList>>();
        this.m_scalarCacheCapacity = scalarCacheCapacity;
        this.m_linkCacheCapacity = linkCacheCapacity;
        this.m_continuationlinkCacheCapacity = continuationlinkCacheCapacity;
        this.m_options = options;
    }

    @Override
    public <T> EntitySequence getSequence(TableDefinition tableDef, Iterable<T> collection) {
        return this.getSequence(tableDef, collection, null, null);
    }

    @Override
    public <T> EntitySequence getSequence(TableDefinition tableDef, Iterable<T> collection, List<String> fields) {
        return this.getSequence(tableDef, collection, fields, null);
    }

    @Override
    public <T> EntitySequence getSequence(TableDefinition tableDef, Iterable<T> collection, List<String> fields, EntitySequenceOptions options) {
        if (fields == null || fields.contains(ALLSCALARMARK)) {
            fields = ALLSCALARFIELDS;
        }
        return new DBEntityRootCollection<T>(tableDef, fields, collection, this, tableDef.getTableName(), EntitySequenceOptions.getOptions(options, DBEntitySequenceOptions.defaultOptions));
    }

    void initializeScalarFields(DBEntity caller, List<String> scalarFields, DBEntitySequenceOptions options) {
        TableDefinition tableDef = caller.getTableDef();
        String category = DBEntitySequenceFactory.toEntityCategory(tableDef.getTableName(), scalarFields);
        LRUCache<ObjectID, Map<String, String>> cache = this.getScalarCache(category);
        HashSet<ObjectID> idSet = new HashSet<ObjectID>();
        List<DBEntity> entities = DBEntitySequenceFactory.collectUninitializedEntities(caller, cache, idSet, options.adjustEntityBuffer(cache));
        if (idSet.size() == 0) {
            return;
        }
        Map<ObjectID, Map<String, String>> fetchResult = this.fetchScalarFields(tableDef, idSet, scalarFields, category);
        for (Map.Entry<ObjectID, Map<String, String>> entry : fetchResult.entrySet()) {
            cache.put(entry.getKey(), entry.getValue());
        }
        for (DBEntity entity : entities) {
            ObjectID key = entity.id();
            HashMap values = (HashMap)cache.get(key);
            if (values == null) {
                values = new HashMap();
            }
            entity.initialize(values);
        }
    }

    void initializeAllScalarFields(DBEntity caller, String continuationField, DBEntitySequenceOptions options) {
        TableDefinition tableDef = caller.getTableDef();
        String category = DBEntitySequenceFactory.toEntityCategory(tableDef.getTableName(), ALLSCALARFIELDS);
        LRUCache<ObjectID, Map<String, String>> cache = this.getScalarCache(category);
        HashSet<ObjectID> idSet = new HashSet<ObjectID>();
        List<DBEntity> entities = DBEntitySequenceFactory.collectContinueAllScalarEntities(caller, cache, idSet, continuationField, options.adjustEntityBuffer(cache));
        if (idSet.size() == 0) {
            return;
        }
        int adjustedScalarBuffer = options.entityBuffer * options.initialScalarBuffer / idSet.size();
        Map<ObjectID, Map<String, String>> fetchResult = this.fetchAllScalarFields(tableDef, idSet, continuationField, adjustedScalarBuffer, category);
        for (Map.Entry<ObjectID, Map<String, String>> entry : fetchResult.entrySet()) {
            ObjectID entityid = entry.getKey();
            Map<String, String> newvalues = entry.getValue();
            if (newvalues.size() >= adjustedScalarBuffer) {
                String lastColumn = "";
                for (String v : newvalues.keySet()) {
                    if (lastColumn.compareTo(v) >= 0) continue;
                    lastColumn = v;
                }
                newvalues.put(ALLSCALARMARK, lastColumn);
            }
            for (DBEntity entity : entities) {
                if (!entity.id().equals(entityid)) continue;
                entity.update(newvalues);
                break;
            }
            Map cachedvalues = (Map)cache.get(entityid);
            if (cachedvalues == null) {
                if (continuationField == null) {
                    cache.put(entityid, newvalues);
                }
            } else {
                cachedvalues.putAll(newvalues);
            }
            if (newvalues.containsKey(ALLSCALARMARK) || cachedvalues == null || !cachedvalues.containsKey(ALLSCALARMARK)) continue;
            cachedvalues.remove(ALLSCALARMARK);
        }
    }

    void initializeLinks(DBEntity caller, String link, List<String> fields, String category, DBEntitySequenceOptions options) {
        TableDefinition tableDef = caller.getTableDef();
        LRUCache<ObjectID, LinkList> cache = this.getLinkCache(DBEntitySequenceFactory.toIteratorCategory(tableDef.getTableName(), link, fields));
        HashSet<ObjectID> idSet = new HashSet<ObjectID>();
        TableDefinition linkedTableDef = tableDef.getLinkExtentTableDef(tableDef.getFieldDef(link));
        DBEntitySequenceOptions limitedOptions = options.adjustInitialLinkBufferDimension(cache);
        List<DBEntity> entities = this.collectUninitializedEntities(caller, category, linkedTableDef, fields, link, cache, idSet, limitedOptions);
        if (idSet.size() == 0) {
            return;
        }
        this.timers.start(String.valueOf(category) + " links", "Init");
        Timer timer = new Timer();
        int capacity = options.initialLinkBuffer;
        Map<ObjectID, List<ObjectID>> fetchResult = this.fetchLinks(tableDef, idSet, link, options.initialLinkBuffer);
        timer.stop();
        int resultCount = 0;
        for (Map.Entry<ObjectID, List<ObjectID>> entry : fetchResult.entrySet()) {
            cache.put(entry.getKey(), new LinkList(entry.getValue(), capacity));
            resultCount += entry.getValue().size();
        }
        this.timers.stop(String.valueOf(category) + " links", "Init", resultCount);
        this.log.debug("fetch {} {} of {}[{}] links ({})", new Object[]{resultCount, category, idSet.size(), options.initialLinkBuffer, timer});
        for (DBEntity entity : entities) {
            ObjectID id = entity.id();
            LinkList columns = (LinkList)cache.get(id);
            if (columns == null) {
                columns = new LinkList(new ArrayList<ObjectID>(0), 1);
            }
            DBLinkIterator linkIterator = new DBLinkIterator(entity, link, columns, this.m_options.linkBuffer, this, category);
            entity.addIterator(category, new DBEntityIterator(linkedTableDef, entity, linkIterator, fields, this, category, this.m_options));
        }
    }

    private static List<DBEntity> collectUninitializedEntities(DBEntity entity, final Map<ObjectID, Map<String, String>> cache, final Set<ObjectID> keys, final DBEntitySequenceOptions options) {
        DBEntityCollector collector = new DBEntityCollector(entity){

            @Override
            protected boolean visit(DBEntity entity, List<DBEntity> list) {
                if (!entity.initialized()) {
                    ObjectID id = entity.id();
                    Map values = (Map)cache.get(id);
                    if (values == null) {
                        keys.add(id);
                        list.add(entity);
                        return keys.size() < options.entityBuffer;
                    }
                    entity.initialize(values);
                }
                return true;
            }
        };
        return collector.collect();
    }

    private List<DBEntity> collectUninitializedEntities(DBEntity entity, final String category, final TableDefinition tableDef, final List<String> fields, final String link, final Map<ObjectID, LinkList> cache, final Set<ObjectID> keys, final DBEntitySequenceOptions options) {
        DBEntityCollector collector = new DBEntityCollector(entity){

            @Override
            protected boolean visit(DBEntity entity, List<DBEntity> list) {
                if (entity.findIterator(category) == null) {
                    ObjectID id = entity.id();
                    LinkList columns = (LinkList)cache.get(id);
                    if (columns == null) {
                        keys.add(id);
                        list.add(entity);
                        return keys.size() < options.initialLinkBufferDimension;
                    }
                    DBLinkIterator linkIterator = new DBLinkIterator(entity, link, columns, ((DBEntitySequenceFactory)DBEntitySequenceFactory.this).m_options.linkBuffer, DBEntitySequenceFactory.this, category);
                    entity.addIterator(category, new DBEntityIterator(tableDef, entity, linkIterator, fields, DBEntitySequenceFactory.this, category, DBEntitySequenceFactory.this.m_options));
                }
                return true;
            }
        };
        return collector.collect();
    }

    private static List<DBEntity> collectContinueAllScalarEntities(DBEntity entity, final Map<ObjectID, Map<String, String>> cache, final Set<ObjectID> keys, final String continuationField, final DBEntitySequenceOptions options) {
        DBEntityCollector collector = new DBEntityCollector(entity){

            @Override
            protected boolean visit(DBEntity entity, List<DBEntity> list) {
                ObjectID id = entity.id();
                if (!entity.initialized()) {
                    Map values = (Map)cache.get(id);
                    if (values == null) {
                        if (continuationField != null) {
                            return true;
                        }
                        keys.add(id);
                        list.add(entity);
                        return keys.size() < options.entityBuffer;
                    }
                    entity.initialize(values);
                }
                if (continuationField == null) {
                    return true;
                }
                if (continuationField.equals(entity.getContinuationField())) {
                    keys.add(id);
                    list.add(entity);
                    return keys.size() < options.entityBuffer;
                }
                return true;
            }
        };
        return collector.collect();
    }

    private <C, K, T> LRUCache<K, T> getCache(Map<C, LRUCache<K, T>> cacheMap, int capacity, C category) {
        LRUCache<K, T> cache = cacheMap.get(category);
        if (cache == null) {
            cache = new LRUCache(capacity);
            cacheMap.put(category, cache);
        }
        return cache;
    }

    public LRUCache<ObjectID, Map<String, String>> getScalarCache(String category) {
        return this.getCache(this.m_scalarCache, this.m_scalarCacheCapacity, category);
    }

    public LRUCache<ObjectID, LinkList> getLinkCache(String category) {
        return this.getCache(this.m_linkCache, this.m_linkCacheCapacity, category);
    }

    public LRUCache<String, LinkList> getContinuationLinkCache(String category) {
        return this.getCache(this.m_continuationlinkCache, this.m_continuationlinkCacheCapacity, category);
    }

    private Map<ObjectID, Map<String, String>> fetchAllScalarFields(TableDefinition tableDef, Collection<ObjectID> ids, String continuationField, int count, String category) {
        String[] timerInfo = new String[]{category, "Init all scalar fields"};
        this.timers.start(timerInfo[0], timerInfo[1]);
        Map<ObjectID, Map<String, String>> map = SpiderHelper.getScalarValues(tableDef, ids, continuationField, count);
        long time = this.timers.stop(timerInfo[0], timerInfo[1], ids.size());
        this.log.debug("fetch {} {}, {} fields from {} ({})", new Object[]{ids.size(), category, count, continuationField, Timer.toString(time)});
        return map;
    }

    private Map<ObjectID, Map<String, String>> fetchScalarFields(TableDefinition tableDef, Collection<ObjectID> ids, List<String> fields, String category) {
        this.timers.start(category, "Init Fields");
        Map<ObjectID, Map<String, String>> map = SpiderHelper.getScalarValues(tableDef, ids, fields);
        long time = this.timers.stop(category, "Init Fields", ids.size());
        this.log.debug("fetch {} {} ({})", new Object[]{ids.size(), category, Timer.toString(time)});
        return map;
    }

    String fetchScalarFieldValue(TableDefinition tableDef, ObjectID id, String field) {
        String fieldDetails = new StringBuffer().append(tableDef.getTableName()).append('[').append(field).append(']').toString();
        this.timers.start("Fetch Field Value", fieldDetails);
        String value = SpiderHelper.fetchScalarFieldValue(tableDef, id, field);
        this.timers.stop("Fetch Field Value", fieldDetails, value == null ? 0 : 1);
        return value;
    }

    List<ObjectID> fetchLinks(TableDefinition tableDef, ObjectID id, String link, ObjectID continuationLink, int count, String category) {
        this.timers.start(String.valueOf(category) + " links", "Continuation");
        FieldDefinition linkField = tableDef.getFieldDef(link);
        List<ObjectID> list = SpiderHelper.getLinks(linkField, id, continuationLink, true, count);
        int resultCount = continuationLink == null ? list.size() : list.size() - 1;
        long time = this.timers.stop(String.valueOf(category) + " links", "Continuation", resultCount);
        this.log.debug("fetch {} {} continuation links ({})", new Object[]{resultCount, category, Timer.toString(time)});
        return list;
    }

    private Map<ObjectID, List<ObjectID>> fetchLinks(TableDefinition tableDef, Collection<ObjectID> ids, String link, int count) {
        FieldDefinition linkField = tableDef.getFieldDef(link);
        return SpiderHelper.getLinks(linkField, ids, null, true, count);
    }

    static String toEntityCategory(String table, List<String> fields) {
        if (fields == null || fields.size() == 0) {
            return String.valueOf(table) + "[]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(table).append('[').append(fields.get(0));
        int i = 1;
        while (i < fields.size()) {
            buffer.append(',').append(fields.get(i));
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    static String toIteratorCategory(String type, String link, List<String> fields) {
        return DBEntitySequenceFactory.toEntityCategory(String.valueOf(type) + "." + link, fields);
    }
}

