/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.IDHelper;
import com.dell.doradus.search.aggregate.DBEntityIterator;
import com.dell.doradus.search.aggregate.DBEntitySequenceFactory;
import com.dell.doradus.search.aggregate.DBEntitySequenceOptions;
import com.dell.doradus.search.aggregate.DisposableDBEntityCollection;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.PrefetchIterator;
import java.util.Iterator;
import java.util.List;

class DBEntityRootCollection<T>
extends DisposableDBEntityCollection {
    private DBEntitySequenceFactory m_factory;
    private TableDefinition m_tableDef;
    private Iterable<T> m_idCollection;
    private List<String> m_fields;
    private String m_category;
    private DBEntitySequenceOptions m_options;

    DBEntityRootCollection(TableDefinition tableDef, List<String> fields, Iterable<T> idCollection, DBEntitySequenceFactory factory, String category, DBEntitySequenceOptions options) {
        this.m_factory = factory;
        this.m_tableDef = tableDef;
        this.m_fields = fields;
        this.m_idCollection = idCollection;
        this.m_category = category;
        this.m_options = options;
    }

    @Override
    protected DBEntityIterator createIterator() {
        return new DBEntityIterator(this.m_tableDef, null, new StringIterator(this.m_idCollection.iterator()), this.m_fields, this.m_factory, this.m_category, this.m_options);
    }

    class StringIterator
    extends PrefetchIterator
    implements Iterator<ObjectID> {
        static final int defaultBufferSize = 1000;
        private Iterator<T> m_iterator;

        StringIterator(Iterator<T> iterator) {
            this(iterator, 1000);
        }

        StringIterator(Iterator<T> iterator, int bufferSize) {
            this.m_iterator = iterator;
            this.m_buffer = new ObjectID[bufferSize];
        }

        @Override
        protected void fetchBuffer() {
            this.m_count = 0;
            while (this.m_count < this.m_buffer.length && this.m_iterator.hasNext()) {
                this.m_buffer[this.m_count] = this.getNext();
                ++this.m_count;
            }
            this.m_index = 0;
            this.m_hasMore = this.m_count == this.m_buffer.length;
        }

        private ObjectID getNext() {
            Object obj = this.m_iterator.next();
            if (obj instanceof Entity) {
                return ((Entity)obj).id();
            }
            if (obj instanceof DBObject) {
                return IDHelper.createID(((DBObject)obj).getObjectID());
            }
            return (ObjectID)obj;
        }
    }
}

