/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.aggregate.DBEntity;
import com.dell.doradus.search.aggregate.DBEntitySequenceFactory;
import com.dell.doradus.search.aggregate.DBEntitySequenceOptions;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.EntityCounter;
import com.dell.doradus.search.aggregate.PrefetchCollection;
import com.dell.doradus.search.aggregate.PrefetchIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

class DBEntityIterator
implements Iterator<Entity> {
    private static final Map<String, String> EMPTY_MAP = new HashMap<String, String>();
    private TableDefinition m_tableDef;
    private DBEntity m_parentEntity;
    private Iterator<ObjectID> m_idIterator;
    private String m_category;
    private DBEntitySequenceOptions m_options;
    private DBEntitySequenceFactory m_factory;
    private List<String> m_fields;
    private List<DBEntity> m_buffer;
    private boolean m_hasMore;
    private boolean m_isDisposed;
    private EntityCounter m_counter;

    DBEntityIterator(TableDefinition tableDef, DBEntity parentEntity, Iterator<ObjectID> idIterator, List<String> fields, DBEntitySequenceFactory factory, String category, DBEntitySequenceOptions options) {
        this.m_factory = factory;
        this.m_tableDef = tableDef;
        this.m_parentEntity = parentEntity;
        this.m_idIterator = idIterator;
        this.m_options = options;
        this.m_category = category;
        this.m_fields = fields;
        this.m_hasMore = true;
        this.m_counter = EntityCounter.get(this.m_category);
        this.m_buffer = new ArrayList<DBEntity>();
        this.prefetchAvailableBuffer();
    }

    @Override
    public boolean hasNext() {
        if (this.m_isDisposed) {
            return false;
        }
        if (this.m_buffer.size() == 0) {
            this.prefetchBuffer();
        }
        if (this.m_buffer.size() == 0) {
            this.dispose();
            return false;
        }
        return true;
    }

    @Override
    public Entity next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DBEntity entity = this.m_buffer.get(0);
        if (!entity.initialized()) {
            this.initializeScalarFields(entity);
        }
        this.m_buffer.remove(0);
        this.m_counter.decrement();
        return entity;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    void dispose() {
        this.m_isDisposed = true;
        this.m_parentEntity = null;
        this.m_idIterator = null;
        this.m_fields = null;
        this.m_buffer = null;
    }

    boolean isDisposed() {
        return this.m_isDisposed;
    }

    DBEntity parentEntity() {
        return this.m_parentEntity;
    }

    void prefetchAvailableBuffer() {
        if (this.m_idIterator instanceof PrefetchIterator) {
            this.prefetchBuffer(((PrefetchIterator)this.m_idIterator).bufferSize());
        }
    }

    public void prefetchBuffer() {
        if (this.m_hasMore && !this.m_isDisposed) {
            this.prefetchBuffer(this.m_options.entityBuffer - this.m_buffer.size());
        }
    }

    public void prefetchBuffer(int count) {
        while (this.m_hasMore && this.m_buffer.size() < this.m_options.entityBuffer && count > 0) {
            if (this.m_idIterator.hasNext()) {
                ObjectID id = this.m_idIterator.next();
                DBEntity entity = new DBEntity(this.m_tableDef, id, null, this.m_factory, this, this.m_category);
                this.m_counter.increment();
                if (this.m_fields.size() == 0) {
                    entity.initialize(EMPTY_MAP);
                }
                this.m_buffer.add(entity);
                --count;
                continue;
            }
            this.m_hasMore = false;
        }
    }

    String category() {
        return this.m_category;
    }

    List<DBEntity> buffer() {
        return this.m_buffer;
    }

    EntityCounter counter() {
        return this.m_counter;
    }

    PrefetchCollection bufferedEntities() {
        return new PrefetchCollection(this);
    }

    void initializeScalarFields(DBEntity entity) {
        if (this.m_fields.size() == 1 && this.m_fields.get(0).equals("*")) {
            this.m_factory.initializeAllScalarFields(entity, null, this.m_options);
        } else {
            this.m_factory.initializeScalarFields(entity, this.m_fields, this.m_options);
        }
    }

    void initializeAllScalarFields(DBEntity entity, String continuationField) {
        this.m_factory.initializeAllScalarFields(entity, continuationField, this.m_options);
    }

    boolean containsField(String field) {
        if (this.m_fields.contains("*")) {
            return true;
        }
        return this.m_fields.contains(field);
    }
}

