/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.search.aggregate.DBEntity;
import com.dell.doradus.search.aggregate.DBEntityIterator;
import java.util.ArrayList;
import java.util.List;

abstract class DBEntityCollector {
    protected List<DBEntity> m_list;
    private List<DBEntityIterator> m_path;
    private DBEntity m_entity;
    private DBEntityIterator m_iterator;
    private int m_counter;
    private int m_entityCategory = 10000;

    DBEntityCollector(DBEntity entity) {
        this.m_entity = entity;
        this.m_iterator = this.m_entity.parentIterator();
    }

    List<DBEntity> collect() {
        this.m_list = new ArrayList<DBEntity>();
        if (!this.visit(this.m_entity, this.m_list)) {
            return this.m_list;
        }
        if (this.m_list.size() == 0) {
            return this.m_list;
        }
        if (this.m_iterator != null) {
            DBEntityIterator iterator = this.m_iterator;
            this.m_path = new ArrayList<DBEntityIterator>();
            while (iterator != null && !iterator.isDisposed()) {
                this.m_path.add(0, iterator);
                if (!this.collect(iterator, 0)) {
                    return this.m_list;
                }
                iterator = iterator.parentEntity() != null ? iterator.parentEntity().parentIterator() : null;
            }
        }
        return this.m_list;
    }

    private boolean collect(DBEntityIterator iterator, int pathIndex) {
        if (pathIndex < this.m_path.size() - 1) {
            DBEntityIterator caller = this.m_path.get(pathIndex + 1);
            String category = caller.category();
            for (DBEntity entity : iterator.bufferedEntities()) {
                DBEntityIterator childIterator = entity.findIterator(category);
                if (childIterator == null || childIterator == caller || this.collect(childIterator, pathIndex + 1)) continue;
                return false;
            }
        } else {
            return this.collect(iterator);
        }
        return true;
    }

    private boolean collect(DBEntityIterator iterator) {
        iterator.prefetchBuffer(this.m_entityCategory - this.m_counter);
        for (DBEntity entity : iterator.bufferedEntities()) {
            if (++this.m_counter > this.m_entityCategory) {
                return false;
            }
            if (entity == this.m_entity || this.visit(entity, this.m_list)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean visit(DBEntity var1, List<DBEntity> var2);
}

