/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.aggregate.DBEntityCollection;
import com.dell.doradus.search.aggregate.DBEntityIterator;
import com.dell.doradus.search.aggregate.DBEntitySequenceFactory;
import com.dell.doradus.search.aggregate.DBEntitySequenceOptions;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.aggregate.EntitySequenceOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DBEntity
implements Entity {
    static final String CONTINUATIONMARK = "*";
    private ObjectID m_id;
    private DBEntityIterator m_parentIterator;
    private Map<String, String> m_scalarMap;
    private TableDefinition m_tableDef;
    private String m_category;
    private DBEntitySequenceFactory m_factory;
    private Map<String, DBEntityIterator> m_childIterators;

    DBEntity(TableDefinition tableDef, ObjectID id, Map<String, String> scalarMap, DBEntitySequenceFactory factory, DBEntityIterator parentIterator, String category) {
        this.m_factory = factory;
        this.m_parentIterator = parentIterator;
        this.m_tableDef = tableDef;
        this.m_category = category;
        this.m_id = id;
        this.m_scalarMap = scalarMap;
    }

    @Override
    public ObjectID id() {
        return this.m_id;
    }

    @Override
    public TableDefinition getTableDef() {
        return this.m_tableDef;
    }

    @Override
    public String get(String field) {
        if (!this.initialized()) {
            return null;
        }
        if (!this.parentIterator().containsField(field)) {
            return this.m_factory.fetchScalarFieldValue(this.m_tableDef, this.id(), field);
        }
        while (true) {
            String value = this.m_scalarMap.get(field);
            String continuationField = this.m_scalarMap.get(CONTINUATIONMARK);
            if (value != null || continuationField == null) {
                return value;
            }
            this.m_parentIterator.initializeAllScalarFields(this, continuationField);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Iterable<String> getAllFields() {
        if (this.initialized()) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            this.m_parentIterator.initializeAllScalarFields(this, continuationField);
lbl4:
            // 2 sources

            ** while ((continuationField = this.m_scalarMap.get((Object)"*")) != null)
        }
lbl5:
        // 1 sources

        return this.m_scalarMap.keySet();
    }

    @Override
    public EntitySequence getLinkedEntities(String link, List<String> fields) {
        return this.getLinkedEntities(link, fields, null);
    }

    @Override
    public EntitySequence getLinkedEntities(String link, List<String> fields, EntitySequenceOptions options) {
        return new DBEntityCollection(this, link, fields, EntitySequenceOptions.getOptions(options, DBEntitySequenceOptions.defaultOptions));
    }

    DBEntityIterator parentIterator() {
        return this.m_parentIterator;
    }

    DBEntityIterator findIterator(String type) {
        if (this.m_childIterators != null) {
            return this.m_childIterators.get(type);
        }
        return null;
    }

    void addIterator(String category, DBEntityIterator iterator) {
        if (this.m_childIterators == null) {
            this.m_childIterators = new HashMap<String, DBEntityIterator>();
        }
        this.m_childIterators.put(category, iterator);
    }

    DBEntityIterator createIterator(String link, List<String> fields, DBEntitySequenceOptions options) {
        String linkType;
        DBEntityIterator iterator;
        if (this.m_childIterators == null) {
            this.m_childIterators = new HashMap<String, DBEntityIterator>();
        }
        if ((iterator = this.m_childIterators.get(linkType = DBEntitySequenceFactory.toIteratorCategory(this.m_category, link, fields))) == null) {
            this.m_factory.initializeLinks(this, link, fields, linkType, options);
        }
        iterator = this.m_childIterators.get(linkType);
        this.m_childIterators.remove(linkType);
        return iterator;
    }

    boolean initialized() {
        return this.m_scalarMap != null;
    }

    String getContinuationField() {
        if (!this.initialized()) {
            return null;
        }
        return this.m_scalarMap.get(CONTINUATIONMARK);
    }

    void initialize(Map<String, String> values) {
        this.m_scalarMap = values;
    }

    void update(Map<String, String> values) {
        if (this.m_scalarMap == null) {
            this.m_scalarMap = values;
        } else {
            this.m_scalarMap.putAll(values);
            if (this.m_scalarMap.containsKey(CONTINUATIONMARK) && !values.containsKey(CONTINUATIONMARK)) {
                this.m_scalarMap.remove(CONTINUATIONMARK);
            }
        }
    }
}

